/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.internal.firebase-iid.zza;
import com.google.android.gms.internal.firebase-iid.zze;
import com.google.android.gms.internal.firebase-iid.zzf;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.iid.FirebaseIidMessengerCompat;
import com.google.firebase.iid.MessengerIpcClient$Connection$$Lambda$0;
import com.google.firebase.iid.MessengerIpcClient$Connection$$Lambda$1;
import com.google.firebase.iid.MessengerIpcClient$Connection$$Lambda$2;
import com.google.firebase.iid.MessengerIpcClient$Connection$$Lambda$3;
import com.google.firebase.iid.MessengerIpcClient$Connection$$Lambda$4;
import com.google.firebase.iid.MessengerIpcClient$Connection$$Lambda$5;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class MessengerIpcClient {
    public static final String KEY_ONE_WAY = "oneWay";
    public static final String KEY_PACKAGE = "pkg";
    public static final String KEY_DATA = "data";
    public static final String KEY_ACK = "ack";
    public static final String KEY_UNSUPPORTED = "unsupported";
    @GuardedBy(value="MessengerIpcClient.class")
    private static MessengerIpcClient instance;
    private final Context context;
    private final ScheduledExecutorService executor;
    @GuardedBy(value="this")
    private Connection connection = new Connection();
    @GuardedBy(value="this")
    private int nextRequestId = 1;

    @KeepForSdk
    public static synchronized MessengerIpcClient getInstance(Context context) {
        if (instance == null) {
            instance = new MessengerIpcClient(context, zza.zza().zza(1, (ThreadFactory)new NamedThreadFactory("MessengerIpcClient"), zzf.zza));
        }
        return instance;
    }

    @VisibleForTesting
    @KeepForSdk
    public static synchronized void resetForTesting() {
        instance = null;
    }

    @VisibleForTesting
    MessengerIpcClient(Context context, ScheduledExecutorService scheduledExecutorService) {
        this.executor = scheduledExecutorService;
        this.context = context.getApplicationContext();
    }

    @KeepForSdk
    public Task<Void> sendOneWayRequest(int n, Bundle bundle) {
        return this.sendRequest(new OneWayRequest(this.getNextRequestId(), n, bundle));
    }

    public Task<Bundle> sendRequestForResponse(int n, Bundle bundle) {
        return this.sendRequest(new TwoWayRequest(this.getNextRequestId(), n, bundle));
    }

    private synchronized <T> Task<T> sendRequest(Request<T> request) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            String string = String.valueOf(request);
            Log.d((String)"MessengerIpcClient", (String)new StringBuilder(9 + String.valueOf(string).length()).append("Queueing ").append(string).toString());
        }
        if (!this.connection.enqueueRequest(request)) {
            this.connection = new Connection();
            this.connection.enqueueRequest(request);
        }
        return request.getTask();
    }

    private synchronized int getNextRequestId() {
        return this.nextRequestId++;
    }

    static class MessengerWrapper {
        private final Messenger messenger;
        private final FirebaseIidMessengerCompat messengerCompat;

        MessengerWrapper(IBinder iBinder) throws RemoteException {
            String string = iBinder.getInterfaceDescriptor();
            if ("android.os.IMessenger".equals(string)) {
                this.messenger = new Messenger(iBinder);
                this.messengerCompat = null;
                return;
            }
            if ("com.google.android.gms.iid.IMessengerCompat".equals(string)) {
                this.messengerCompat = new FirebaseIidMessengerCompat(iBinder);
                this.messenger = null;
                return;
            }
            String string2 = String.valueOf(string);
            Log.w((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Invalid interface descriptor: ".concat(string2) : new String("Invalid interface descriptor: ")));
            throw new RemoteException();
        }

        void send(Message message) throws RemoteException {
            if (this.messenger != null) {
                this.messenger.send(message);
                return;
            }
            if (this.messengerCompat != null) {
                this.messengerCompat.send(message);
                return;
            }
            throw new IllegalStateException("Both messengers are null");
        }
    }

    private class Connection
    implements ServiceConnection {
        @GuardedBy(value="this")
        int state = 0;
        final Messenger appMessenger = new Messenger((Handler)new zze(Looper.getMainLooper(), new MessengerIpcClient$Connection$$Lambda$0(this)));
        MessengerWrapper gmsCoreMessenger;
        @GuardedBy(value="this")
        final Queue<Request<?>> requestsToBeSent = new ArrayDeque();
        @GuardedBy(value="this")
        final SparseArray<Request<?>> requestsWaitingForResponse = new SparseArray();

        private Connection() {
        }

        synchronized boolean enqueueRequest(Request<?> request) {
            switch (this.state) {
                case 0: {
                    this.requestsToBeSent.add(request);
                    this.startConnection();
                    return true;
                }
                case 1: {
                    this.requestsToBeSent.add(request);
                    return true;
                }
                case 2: {
                    this.requestsToBeSent.add(request);
                    this.scheduleSendingRequests();
                    return true;
                }
                case 3: 
                case 4: {
                    return false;
                }
            }
            int n = this.state;
            throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n).toString());
        }

        @GuardedBy(value="this")
        void startConnection() {
            Preconditions.checkState((this.state == 0 ? 1 : 0) != 0);
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
            }
            this.state = 1;
            Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
            intent.setPackage("com.google.android.gms");
            if (!ConnectionTracker.getInstance().bindService(MessengerIpcClient.this.context, intent, (ServiceConnection)this, 1)) {
                this.handleDisconnect(0, "Unable to bind to service");
                return;
            }
            MessengerIpcClient.this.executor.schedule(new MessengerIpcClient$Connection$$Lambda$1(this), 30L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean receivedResponse(Message message) {
            Request request;
            int n = message.arg1;
            if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
                Log.d((String)"MessengerIpcClient", (String)new StringBuilder(41).append("Received response to request: ").append(n).toString());
            }
            Connection connection = this;
            synchronized (connection) {
                request = (Request)this.requestsWaitingForResponse.get(n);
                if (request == null) {
                    Log.w((String)"MessengerIpcClient", (String)new StringBuilder(50).append("Received response for unknown request: ").append(n).toString());
                    return true;
                }
                this.requestsWaitingForResponse.remove(n);
                this.unbindIfFinished();
            }
            request.handleResponse(message.getData());
            return true;
        }

        @MainThread
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Service connected");
            }
            MessengerIpcClient.this.executor.execute(new MessengerIpcClient$Connection$$Lambda$2(this, iBinder));
        }

        void scheduleSendingRequests() {
            MessengerIpcClient.this.executor.execute(new MessengerIpcClient$Connection$$Lambda$3(this));
        }

        void sendRequestOverMessenger(Request<?> request) {
            String string;
            if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
                string = String.valueOf(request);
                Log.d((String)"MessengerIpcClient", (String)new StringBuilder(8 + String.valueOf(string).length()).append("Sending ").append(string).toString());
            }
            string = request.createMessage(MessengerIpcClient.this.context, this.appMessenger);
            try {
                this.gmsCoreMessenger.send((Message)string);
                return;
            }
            catch (RemoteException remoteException) {
                this.handleDisconnect(2, remoteException.getMessage());
                return;
            }
        }

        @MainThread
        public void onServiceDisconnected(ComponentName componentName) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
            }
            MessengerIpcClient.this.executor.execute(new MessengerIpcClient$Connection$$Lambda$4(this));
        }

        synchronized void handleDisconnect(int n, String string) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
                String string2 = String.valueOf(string);
                Log.d((String)"MessengerIpcClient", (String)(string2.length() != 0 ? "Disconnected: ".concat(string2) : new String("Disconnected: ")));
            }
            switch (this.state) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: 
                case 2: {
                    if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                        Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                    }
                    this.state = 4;
                    ConnectionTracker.getInstance().unbindService(MessengerIpcClient.this.context, (ServiceConnection)this);
                    this.failAllPendingReqests(new RequestFailedException(n, string));
                    return;
                }
                case 3: {
                    this.state = 4;
                    return;
                }
                case 4: {
                    return;
                }
            }
            int n2 = this.state;
            throw new IllegalStateException(new StringBuilder(26).append("Unknown state: ").append(n2).toString());
        }

        @GuardedBy(value="this")
        void failAllPendingReqests(RequestFailedException requestFailedException) {
            Iterator iterator = this.requestsToBeSent.iterator();
            while (iterator.hasNext()) {
                ((Request)iterator.next()).fail(requestFailedException);
            }
            this.requestsToBeSent.clear();
            for (int i = 0; i < this.requestsWaitingForResponse.size(); ++i) {
                ((Request)this.requestsWaitingForResponse.valueAt(i)).fail(requestFailedException);
            }
            this.requestsWaitingForResponse.clear();
        }

        synchronized void unbindIfFinished() {
            if (this.state == 2 && this.requestsToBeSent.isEmpty() && this.requestsWaitingForResponse.size() == 0) {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
                }
                this.state = 3;
                ConnectionTracker.getInstance().unbindService(MessengerIpcClient.this.context, (ServiceConnection)this);
            }
        }

        synchronized void timeoutConnection() {
            if (this.state == 1) {
                this.handleDisconnect(1, "Timed out while binding");
            }
        }

        synchronized void timeoutRequest(int n) {
            Request request = (Request)this.requestsWaitingForResponse.get(n);
            if (request != null) {
                Log.w((String)"MessengerIpcClient", (String)new StringBuilder(31).append("Timing out request: ").append(n).toString());
                this.requestsWaitingForResponse.remove(n);
                request.fail(new RequestFailedException(3, "Timed out waiting for response"));
                this.unbindIfFinished();
            }
        }

        final /* synthetic */ void lambda$onServiceDisconnected$3$MessengerIpcClient$Connection() {
            this.handleDisconnect(2, "Service disconnected");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final /* synthetic */ void lambda$scheduleSendingRequests$2$MessengerIpcClient$Connection() {
            while (true) {
                Request<?> request;
                Connection connection = this;
                synchronized (connection) {
                    if (this.state != 2) {
                        return;
                    }
                    if (this.requestsToBeSent.isEmpty()) {
                        this.unbindIfFinished();
                        return;
                    }
                    request = this.requestsToBeSent.poll();
                    this.requestsWaitingForResponse.put(request.requestId, request);
                    MessengerIpcClient.this.executor.schedule(new MessengerIpcClient$Connection$$Lambda$5(this, request), 30L, TimeUnit.SECONDS);
                }
                this.sendRequestOverMessenger(request);
            }
        }

        final /* synthetic */ void lambda$scheduleSendingRequests$1$MessengerIpcClient$Connection(Request request) {
            this.timeoutRequest(request.requestId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final /* synthetic */ void lambda$onServiceConnected$0$MessengerIpcClient$Connection(IBinder iBinder) {
            Connection connection = this;
            synchronized (connection) {
                if (iBinder == null) {
                    this.handleDisconnect(0, "Null service connection");
                    return;
                }
                try {
                    this.gmsCoreMessenger = new MessengerWrapper(iBinder);
                }
                catch (RemoteException remoteException) {
                    this.handleDisconnect(0, remoteException.getMessage());
                    return;
                }
                this.state = 2;
                this.scheduleSendingRequests();
                return;
            }
        }
    }

    private static class TwoWayRequest
    extends Request<Bundle> {
        TwoWayRequest(int n, int n2, Bundle bundle) {
            super(n, n2, bundle);
        }

        @Override
        boolean isOneWay() {
            return false;
        }

        @Override
        void handleResponseInternal(Bundle bundle) {
            Bundle bundle2 = bundle.getBundle(MessengerIpcClient.KEY_DATA);
            if (bundle2 == null) {
                bundle2 = Bundle.EMPTY;
            }
            this.finish(bundle2);
        }
    }

    private static class OneWayRequest
    extends Request<Void> {
        OneWayRequest(int n, int n2, Bundle bundle) {
            super(n, n2, bundle);
        }

        @Override
        boolean isOneWay() {
            return true;
        }

        @Override
        void handleResponseInternal(Bundle bundle) {
            if (bundle.getBoolean(MessengerIpcClient.KEY_ACK, false)) {
                this.finish(null);
                return;
            }
            this.fail(new RequestFailedException(4, "Invalid response to one way request"));
        }
    }

    private static abstract class Request<T> {
        final int requestId;
        final TaskCompletionSource<T> taskCompletionSource = new TaskCompletionSource();
        final int what;
        final Bundle data;

        Request(int n, int n2, Bundle bundle) {
            this.requestId = n;
            this.what = n2;
            this.data = bundle;
        }

        abstract boolean isOneWay();

        Message createMessage(Context context, Messenger messenger) {
            Message message = Message.obtain();
            Message.obtain().what = this.what;
            message.arg1 = this.requestId;
            message.replyTo = messenger;
            Bundle bundle = new Bundle();
            bundle.putBoolean(MessengerIpcClient.KEY_ONE_WAY, this.isOneWay());
            bundle.putString(MessengerIpcClient.KEY_PACKAGE, context.getPackageName());
            bundle.putBundle(MessengerIpcClient.KEY_DATA, this.data);
            message.setData(bundle);
            return message;
        }

        Task<T> getTask() {
            return this.taskCompletionSource.getTask();
        }

        void finish(T t) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
                String string = String.valueOf(this);
                String string2 = String.valueOf(t);
                Log.d((String)"MessengerIpcClient", (String)new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Finishing ").append(string).append(" with ").append(string2).toString());
            }
            this.taskCompletionSource.setResult(t);
        }

        void fail(RequestFailedException requestFailedException) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
                String string = String.valueOf(this);
                String string2 = String.valueOf(requestFailedException);
                Log.d((String)"MessengerIpcClient", (String)new StringBuilder(14 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Failing ").append(string).append(" with ").append(string2).toString());
            }
            this.taskCompletionSource.setException((Exception)requestFailedException);
        }

        void handleResponse(Bundle bundle) {
            if (bundle.getBoolean(MessengerIpcClient.KEY_UNSUPPORTED, false)) {
                this.fail(new RequestFailedException(4, "Not supported by GmsCore"));
                return;
            }
            this.handleResponseInternal(bundle);
        }

        abstract void handleResponseInternal(Bundle var1);

        public String toString() {
            int n = this.what;
            int n2 = this.requestId;
            boolean bl = this.isOneWay();
            return new StringBuilder(55).append("Request { what=").append(n).append(" id=").append(n2).append(" oneWay=").append(bl).append("}").toString();
        }
    }

    public static class RequestFailedException
    extends Exception {
        private final int errorCode;

        public RequestFailedException(int n, String string) {
            super(string);
            this.errorCode = n;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ErrorCode {
            public static final int FAILED_TO_CONNECT = 0;
            public static final int CONNECTION_TIMEOUT = 1;
            public static final int REMOTE_ERROR = 2;
            public static final int REQUEST_TIMEOUT = 3;
            public static final int UNSUPPORTED = 4;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @KeepForSdk
    public static @interface What {
        public static final int LEGACY_IID_TOKEN_REQUEST = 0;
        public static final int IID_TOKEN_REQUEST = 1;
        @KeepForSdk
        public static final int FCM_ACK = 2;
    }
}

