/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.ECGenParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionKeyUtil {
    public static KeyPair generateEcP256KeyPair() {
        return EncryptionKeyUtil.getEcKeyGen().generateKeyPair();
    }

    public static boolean isEcP256Supported() {
        try {
            EncryptionKeyUtil.getEcKeyGen();
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    private static KeyPairGenerator getEcKeyGen() {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("EC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        try {
            keyPairGenerator.initialize(new ECGenParameterSpec("prime256v1"));
            return keyPairGenerator;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            try {
                keyPairGenerator.initialize(new ECGenParameterSpec("secp256r1"));
                return keyPairGenerator;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException2) {
                throw new RuntimeException("Unable to find the NIST P-256 curve");
            }
        }
    }

    public static KeyPair generateRSA2048KeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public static SecretKey parseAESKey(byte[] byArray) {
        return new SecretKeySpec(byArray, "AES");
    }
}

