/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.BroadcastProcessor;
import com.google.firebase.iid.FcmBroadcastProcessor$$Lambda$0;
import com.google.firebase.iid.FcmBroadcastProcessor$$Lambda$1;
import com.google.firebase.iid.FcmBroadcastProcessor$$Lambda$2;
import com.google.firebase.iid.FcmBroadcastProcessor$$Lambda$3;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.ServiceStarter;
import com.google.firebase.iid.WithinAppServiceConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class FcmBroadcastProcessor
implements BroadcastProcessor {
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static WithinAppServiceConnection fcmServiceConn;
    private final Context context;
    private final ExecutorService executor;

    public FcmBroadcastProcessor(Context context, ExecutorService executorService) {
        this.context = context;
        this.executor = executorService;
    }

    @Override
    @KeepForSdk
    public Task<Integer> process(Intent intent) {
        String string = intent.getStringExtra("gcm.rawData64");
        if (string != null) {
            intent.putExtra("rawData", Base64.decode((String)string, (int)0));
            intent.removeExtra("gcm.rawData64");
        }
        return this.startMessagingService(this.context, intent);
    }

    @SuppressLint(value={"InlinedApi"})
    public Task<Integer> startMessagingService(Context context, Intent intent) {
        boolean bl;
        boolean bl2 = PlatformVersion.isAtLeastO() && context.getApplicationInfo().targetSdkVersion >= 26;
        boolean bl3 = bl = (intent.getFlags() & 0x10000000) != 0;
        if (bl2 && !bl) {
            return FcmBroadcastProcessor.bindToMessagingService(context, intent);
        }
        return Tasks.call((Executor)this.executor, (Callable)new FcmBroadcastProcessor$$Lambda$0(context, intent)).continueWithTask((Executor)this.executor, (Continuation)new FcmBroadcastProcessor$$Lambda$1(context, intent));
    }

    private static Task<Integer> bindToMessagingService(Context context, Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Binding to service");
        }
        return FcmBroadcastProcessor.getServiceConnection(context, "com.google.firebase.MESSAGING_EVENT").sendIntent(intent).continueWith(FirebaseIidExecutors.directExecutor(), FcmBroadcastProcessor$$Lambda$2.$instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WithinAppServiceConnection getServiceConnection(Context context, String string) {
        Object object = lock;
        synchronized (object) {
            if (fcmServiceConn == null) {
                fcmServiceConn = new WithinAppServiceConnection(context, string);
            }
            return fcmServiceConn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            fcmServiceConn = null;
            return;
        }
    }

    static final /* synthetic */ Integer lambda$bindToMessagingService$3$FcmBroadcastProcessor(Task task) throws Exception {
        return -1;
    }

    static final /* synthetic */ Task lambda$startMessagingService$2$FcmBroadcastProcessor(Context context, Intent intent, Task task) throws Exception {
        if (!PlatformVersion.isAtLeastO() || (Integer)task.getResult() != 402) {
            return task;
        }
        return FcmBroadcastProcessor.bindToMessagingService(context, intent).continueWith(FirebaseIidExecutors.directExecutor(), FcmBroadcastProcessor$$Lambda$3.$instance);
    }

    static final /* synthetic */ Integer lambda$startMessagingService$1$FcmBroadcastProcessor(Task task) throws Exception {
        return 403;
    }

    static final /* synthetic */ Integer lambda$startMessagingService$0$FcmBroadcastProcessor(Context context, Intent intent) throws Exception {
        return ServiceStarter.getInstance().startMessagingService(context, intent);
    }
}

