/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.IMessengerCompat;

@KeepForSdk
public class FirebaseIidMessengerCompat
implements Parcelable {
    Messenger messenger;
    IMessengerCompat messengerCompat;
    public static final Parcelable.Creator<FirebaseIidMessengerCompat> CREATOR = new Parcelable.Creator<FirebaseIidMessengerCompat>(){

        public FirebaseIidMessengerCompat createFromParcel(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            if (iBinder != null) {
                return new FirebaseIidMessengerCompat(iBinder);
            }
            return null;
        }

        public FirebaseIidMessengerCompat[] newArray(int n) {
            return new FirebaseIidMessengerCompat[n];
        }
    };

    @KeepForSdk
    public FirebaseIidMessengerCompat(Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.messenger = new Messenger(handler);
            return;
        }
        this.messengerCompat = new IMessengerCompat.Impl(handler);
    }

    public FirebaseIidMessengerCompat(IBinder iBinder) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.messenger = new Messenger(iBinder);
            return;
        }
        this.messengerCompat = new IMessengerCompat.Proxy(iBinder);
    }

    public static int getSendingUid(Message message) {
        if (Build.VERSION.SDK_INT >= 21) {
            return FirebaseIidMessengerCompat.getSendingUidNew(message);
        }
        return message.arg2;
    }

    @TargetApi(value=21)
    private static int getSendingUidNew(Message message) {
        return message.sendingUid;
    }

    public void send(Message message) throws RemoteException {
        if (this.messenger != null) {
            this.messenger.send(message);
            return;
        }
        this.messengerCompat.send(message);
    }

    @KeepForSdk
    public IBinder getBinder() {
        if (this.messenger != null) {
            return this.messenger.getBinder();
        }
        return this.messengerCompat.asBinder();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            return this.getBinder().equals(((FirebaseIidMessengerCompat)object).getBinder());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.getBinder().hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.messenger != null) {
            parcel.writeStrongBinder(this.messenger.getBinder());
            return;
        }
        parcel.writeStrongBinder(this.messengerCompat.asBinder());
    }

    public static final class HandleOldParcelNameClassLoader
    extends ClassLoader {
        @Override
        protected final Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            if ("com.google.android.gms.iid.MessengerCompat".equals(string)) {
                if (FirebaseInstanceId.isDebugLogEnabled()) {
                    Log.d((String)"FirebaseInstanceId", (String)"Using renamed FirebaseIidMessengerCompat class");
                }
                return FirebaseIidMessengerCompat.class;
            }
            return super.loadClass(string, bl);
        }
    }
}

