/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.legacy.content.WakefulBroadcastReceiver;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.BroadcastProcessor;
import com.google.firebase.iid.FcmBroadcastProcessor;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.FirebaseInstanceIdReceiver$$Lambda$0;
import com.google.firebase.iid.IidBroadcastProcessor;
import com.google.firebase.iid.ServiceStarter;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public final class FirebaseInstanceIdReceiver
extends WakefulBroadcastReceiver {
    private final ExecutorService processorExecutor = FirebaseIidExecutors.newCachedSingleThreadExecutor();

    public final void onReceive(@NonNull Context context, @NonNull Intent intent) {
        if (intent == null) {
            return;
        }
        this.onReceiveInternal(context, FirebaseInstanceIdReceiver.normalizeIntent(context, intent));
    }

    private static Intent normalizeIntent(Context context, Intent intent) {
        Intent intent2 = ServiceStarter.unwrapServiceIntent(intent);
        if (intent2 != null) {
            intent = intent2;
        }
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        if (Build.VERSION.SDK_INT <= 18) {
            intent.removeCategory(context.getPackageName());
        }
        return intent;
    }

    private final void onReceiveInternal(Context context, Intent intent) {
        BroadcastProcessor broadcastProcessor = "google.com/iid".equals(intent.getStringExtra("from")) ? new IidBroadcastProcessor(this.processorExecutor) : new FcmBroadcastProcessor(context, this.processorExecutor);
        boolean bl = this.isOrderedBroadcast();
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        broadcastProcessor.process(intent).addOnCompleteListener((Executor)this.processorExecutor, (OnCompleteListener)new FirebaseInstanceIdReceiver$$Lambda$0(bl, pendingResult));
    }

    static final /* synthetic */ void lambda$onReceiveInternal$0$FirebaseInstanceIdReceiver(boolean bl, BroadcastReceiver.PendingResult pendingResult, Task task) {
        if (bl) {
            pendingResult.setResultCode(task.isSuccessful() ? (Integer)task.getResult() : 500);
        }
        pendingResult.finish();
    }
}

