/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.firebase.FirebaseApp;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class Metadata {
    private final Context context;
    @GuardedBy(value="this")
    private String appVersionCode;
    @GuardedBy(value="this")
    private String appVersionName;
    @GuardedBy(value="this")
    private int gmsVersionCode;
    @GuardedBy(value="this")
    private int iidImplementation = 0;

    public Metadata(Context context) {
        this.context = context;
    }

    @KeepForSdk
    public boolean isGmscorePresent() {
        return this.getIidImplementation() != 0;
    }

    public synchronized int getIidImplementation() {
        List list;
        Intent intent;
        if (this.iidImplementation != 0) {
            return this.iidImplementation;
        }
        PackageManager packageManager = this.context.getPackageManager();
        if (packageManager.checkPermission("com.google.android.c2dm.permission.SEND", "com.google.android.gms") == -1) {
            Log.e((String)"FirebaseInstanceId", (String)"Google Play services missing or without correct permission.");
            return 0;
        }
        if (!PlatformVersion.isAtLeastO()) {
            intent = new Intent("com.google.android.c2dm.intent.REGISTER");
            intent.setPackage("com.google.android.gms");
            list = packageManager.queryIntentServices(intent, 0);
            if (list != null && list.size() > 0) {
                this.iidImplementation = 1;
                return this.iidImplementation;
            }
        }
        intent = new Intent("com.google.iid.TOKEN_REQUEST");
        intent.setPackage("com.google.android.gms");
        list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null && list.size() > 0) {
            this.iidImplementation = 2;
            return this.iidImplementation;
        }
        Log.w((String)"FirebaseInstanceId", (String)"Failed to resolve IID implementation package, falling back");
        this.iidImplementation = PlatformVersion.isAtLeastO() ? 2 : 1;
        return this.iidImplementation;
    }

    public static String getDefaultSenderId(FirebaseApp firebaseApp) {
        String string = firebaseApp.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        String string2 = firebaseApp.getOptions().getApplicationId();
        if (!string2.startsWith("1:")) {
            return string2;
        }
        String[] stringArray = string2.split(":");
        if (stringArray.length < 2) {
            return null;
        }
        String string3 = stringArray[1];
        if (string3.isEmpty()) {
            return null;
        }
        return string3;
    }

    public static String getIdFromPublicKey(PublicKey publicKey) {
        byte[] byArray = publicKey.getEncoded();
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA1").digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)n;
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    public synchronized String getAppVersionCode() {
        if (this.appVersionCode == null) {
            this.populateAppVersionInfo();
        }
        return this.appVersionCode;
    }

    public synchronized String getAppVersionName() {
        if (this.appVersionName == null) {
            this.populateAppVersionInfo();
        }
        return this.appVersionName;
    }

    public synchronized int getGmsVersionCode() {
        PackageInfo packageInfo;
        if (this.gmsVersionCode == 0 && (packageInfo = this.getPackageInfo("com.google.android.gms")) != null) {
            this.gmsVersionCode = packageInfo.versionCode;
        }
        return this.gmsVersionCode;
    }

    private synchronized void populateAppVersionInfo() {
        PackageInfo packageInfo = this.getPackageInfo(this.context.getPackageName());
        if (packageInfo != null) {
            this.appVersionCode = Integer.toString(packageInfo.versionCode);
            this.appVersionName = packageInfo.versionName;
        }
    }

    private PackageInfo getPackageInfo(String string) {
        try {
            return this.context.getPackageManager().getPackageInfo(string, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to find package ").append(string2).toString());
            return null;
        }
    }
}

