/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.iid.FirebaseInstanceIdReceiver;
import com.google.firebase.iid.WakeLockHolder;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class ServiceStarter {
    public static final int SUCCESS = -1;
    @KeepForSdk
    public static final int ERROR_UNKNOWN = 500;
    public static final String ACTION_MESSAGING_EVENT = "com.google.firebase.MESSAGING_EVENT";
    private static ServiceStarter instance;
    @GuardedBy(value="this")
    @Nullable
    private String firebaseMessagingServiceClassName = null;
    private Boolean hasWakeLockPermission = null;
    private Boolean hasAccessNetworkStatePermission = null;
    private final Queue<Intent> messagingEvents = new ArrayDeque<Intent>();

    @KeepForSdk
    public static synchronized ServiceStarter getInstance() {
        if (instance == null) {
            instance = new ServiceStarter();
        }
        return instance;
    }

    private ServiceStarter() {
    }

    public static PendingIntent createMessagingPendingIntent(Context context, int n, Intent intent, int n2) {
        Intent intent2 = ServiceStarter.wrapServiceIntent(context, ACTION_MESSAGING_EVENT, intent);
        return PendingIntent.getBroadcast((Context)context, (int)n, (Intent)intent2, (int)n2);
    }

    @KeepForSdk
    public static void startMessagingServiceViaReceiver(Context context, Intent intent) {
        context.sendBroadcast(ServiceStarter.wrapServiceIntent(context, ACTION_MESSAGING_EVENT, intent));
    }

    private static Intent wrapServiceIntent(Context context, String string, Intent intent) {
        Intent intent2 = new Intent(context, FirebaseInstanceIdReceiver.class);
        intent2.setAction(string);
        intent2.putExtra("wrapped_intent", (Parcelable)intent);
        return intent2;
    }

    @Nullable
    public static Intent unwrapServiceIntent(Intent intent) {
        Parcelable parcelable = intent.getParcelableExtra("wrapped_intent");
        if (parcelable instanceof Intent) {
            return (Intent)parcelable;
        }
        return null;
    }

    @MainThread
    @KeepForSdk
    public Intent getMessagingEvent() {
        return this.messagingEvents.poll();
    }

    @MainThread
    public int startMessagingService(Context context, Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Starting service");
        }
        this.messagingEvents.offer(intent);
        Intent intent2 = new Intent(ACTION_MESSAGING_EVENT);
        intent2.setPackage(context.getPackageName());
        return this.doStartService(context, intent2);
    }

    private int doStartService(Context context, Intent intent) {
        String string = this.resolveServiceClassName(context, intent);
        if (string != null) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                String string2 = String.valueOf(string);
                Log.d((String)"FirebaseInstanceId", (String)(string2.length() != 0 ? "Restricting intent to a specific service: ".concat(string2) : new String("Restricting intent to a specific service: ")));
            }
            intent.setClassName(context.getPackageName(), string);
        }
        try {
            ComponentName componentName;
            if (this.hasWakeLockPermission(context)) {
                componentName = WakeLockHolder.startWakefulService(context, intent);
            } else {
                componentName = context.startService(intent);
                Log.d((String)"FirebaseInstanceId", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (componentName == null) {
                Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message: ServiceIntent not found.");
                return 404;
            }
            return -1;
        }
        catch (SecurityException securityException) {
            Log.e((String)"FirebaseInstanceId", (String)"Error while delivering the message to the serviceIntent", (Throwable)securityException);
            return 401;
        }
        catch (IllegalStateException illegalStateException) {
            String string3 = String.valueOf(illegalStateException);
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(45 + String.valueOf(string3).length()).append("Failed to start service while in background: ").append(string3).toString());
            return 402;
        }
    }

    @Nullable
    private synchronized String resolveServiceClassName(Context context, Intent intent) {
        if (this.firebaseMessagingServiceClassName != null) {
            return this.firebaseMessagingServiceClassName;
        }
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to resolve target intent service, skipping classname enforcement");
            return null;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        if (!context.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
            String string = serviceInfo.packageName;
            String string2 = serviceInfo.name;
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(94 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Error resolving target intent service, skipping classname enforcement. Resolved service was: ").append(string).append("/").append(string2).toString());
            return null;
        }
        if (serviceInfo.name.startsWith(".")) {
            String string = String.valueOf(context.getPackageName());
            String string3 = String.valueOf(serviceInfo.name);
            this.firebaseMessagingServiceClassName = string3.length() != 0 ? string.concat(string3) : new String(string);
        } else {
            this.firebaseMessagingServiceClassName = serviceInfo.name;
        }
        return this.firebaseMessagingServiceClassName;
    }

    boolean hasWakeLockPermission(Context context) {
        if (this.hasWakeLockPermission == null) {
            this.hasWakeLockPermission = context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0;
        }
        if (!this.hasWakeLockPermission.booleanValue() && Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Missing Permission: android.permission.WAKE_LOCK this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.hasWakeLockPermission;
    }

    boolean hasAccessNetworkStatePermission(Context context) {
        if (this.hasAccessNetworkStatePermission == null) {
            this.hasAccessNetworkStatePermission = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
        }
        if (!this.hasWakeLockPermission.booleanValue() && Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"Missing Permission: android.permission.ACCESS_NETWORK_STATE this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.hasAccessNetworkStatePermission;
    }

    @VisibleForTesting
    public static void setForTesting(ServiceStarter serviceStarter) {
        instance = serviceStarter;
    }
}

