/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.stats.WakeLock;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public final class WakeLockHolder {
    private static final long WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final Object syncObject = new Object();
    @GuardedBy(value="WakeLockHolder.syncObject")
    private static WakeLock wakeLock;

    @GuardedBy(value="WakeLockHolder.syncObject")
    private static void checkAndInitWakeLock(Context context) {
        if (wakeLock == null) {
            wakeLock = new WakeLock(context, 1, "wake:com.google.firebase.iid.WakeLockHolder");
            wakeLock.setReferenceCounted(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentName startWakefulService(@NonNull Context context, @NonNull Intent intent) {
        Object object = syncObject;
        synchronized (object) {
            WakeLockHolder.checkAndInitWakeLock(context);
            boolean bl = WakeLockHolder.isWakefulIntent(intent);
            WakeLockHolder.setAsWakefulIntent(intent, true);
            ComponentName componentName = context.startService(intent);
            if (componentName == null) {
                return null;
            }
            if (!bl) {
                wakeLock.acquire(WAKE_LOCK_ACQUIRE_TIMEOUT_MILLIS);
            }
            return componentName;
        }
    }

    private static void setAsWakefulIntent(@NonNull Intent intent, boolean bl) {
        intent.putExtra("com.google.firebase.iid.WakeLockHolder.wakefulintent", bl);
    }

    @VisibleForTesting
    static boolean isWakefulIntent(@NonNull Intent intent) {
        return intent.getBooleanExtra("com.google.firebase.iid.WakeLockHolder.wakefulintent", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void completeWakefulIntent(@NonNull Intent intent) {
        Object object = syncObject;
        synchronized (object) {
            if (wakeLock != null && WakeLockHolder.isWakefulIntent(intent)) {
                WakeLockHolder.setAsWakefulIntent(intent, false);
                wakeLock.release();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void acquireWakeLock(Intent intent, long l) {
        Object object = syncObject;
        synchronized (object) {
            if (wakeLock != null) {
                WakeLockHolder.setAsWakefulIntent(intent, true);
                wakeLock.acquire(l);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void initWakeLock(Context context) {
        Object object = syncObject;
        synchronized (object) {
            WakeLockHolder.checkAndInitWakeLock(context);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static void reset() {
        Object object = syncObject;
        synchronized (object) {
            wakeLock = null;
            return;
        }
    }
}

