/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Intent;
import android.os.Binder;
import android.os.Process;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.WithinAppServiceBinder$$Lambda$0;
import com.google.firebase.iid.WithinAppServiceConnection;

@KeepForSdk
public class WithinAppServiceBinder
extends Binder {
    private final IntentHandler intentHandler;

    @KeepForSdk
    public WithinAppServiceBinder(IntentHandler intentHandler) {
        this.intentHandler = intentHandler;
    }

    void send(WithinAppServiceConnection.BindRequest bindRequest) {
        if (Binder.getCallingUid() != Process.myUid()) {
            throw new SecurityException("Binding only allowed within app");
        }
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"service received new intent via bind strategy");
        }
        this.intentHandler.handle(bindRequest.intent).addOnCompleteListener(FirebaseIidExecutors.directExecutor(), (OnCompleteListener)new WithinAppServiceBinder$$Lambda$0(bindRequest));
    }

    static final /* synthetic */ void lambda$send$0$WithinAppServiceBinder(WithinAppServiceConnection.BindRequest bindRequest, Task task) {
        bindRequest.finish();
    }

    public static interface IntentHandler {
        @KeepForSdk
        public Task<Void> handle(Intent var1);
    }
}

