/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.iid.WithinAppServiceBinder;
import com.google.firebase.iid.WithinAppServiceConnection$BindRequest$$Lambda$0;
import com.google.firebase.iid.WithinAppServiceConnection$BindRequest$$Lambda$1;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class WithinAppServiceConnection
implements ServiceConnection {
    private final Context context;
    private final Intent connectionIntent;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Queue<BindRequest> intentQueue = new ArrayDeque<BindRequest>();
    @Nullable
    private WithinAppServiceBinder binder;
    @GuardedBy(value="this")
    private boolean connectionInProgress = false;

    public WithinAppServiceConnection(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0, (ThreadFactory)new NamedThreadFactory("Firebase-FirebaseInstanceIdServiceConnection")));
    }

    @VisibleForTesting
    WithinAppServiceConnection(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.context = context.getApplicationContext();
        this.connectionIntent = new Intent(string).setPackage(this.context.getPackageName());
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public synchronized Task<Void> sendIntent(Intent intent) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"new intent queued in the bind-strategy delivery");
        }
        BindRequest bindRequest = new BindRequest(intent);
        bindRequest.arrangeTimeout(this.scheduledExecutorService);
        this.intentQueue.add(bindRequest);
        this.flushQueue();
        return bindRequest.getTask();
    }

    private synchronized void flushQueue() {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            Log.d((String)"FirebaseInstanceId", (String)"flush queue called");
        }
        while (!this.intentQueue.isEmpty()) {
            if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                Log.d((String)"FirebaseInstanceId", (String)"found intent to be delivered");
            }
            if (this.binder != null && this.binder.isBinderAlive()) {
                if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
                    Log.d((String)"FirebaseInstanceId", (String)"binder is alive, sending the intent.");
                }
                BindRequest bindRequest = this.intentQueue.poll();
                this.binder.send(bindRequest);
                continue;
            }
            this.startConnectionIfNeeded();
            return;
        }
    }

    @GuardedBy(value="this")
    private void startConnectionIfNeeded() {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            boolean bl = !this.connectionInProgress;
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
        }
        if (this.connectionInProgress) {
            return;
        }
        this.connectionInProgress = true;
        try {
            if (ConnectionTracker.getInstance().bindService(this.context, this.connectionIntent, (ServiceConnection)this, 65)) {
                return;
            }
            Log.e((String)"FirebaseInstanceId", (String)"binding to the service failed");
        }
        catch (SecurityException securityException) {
            Log.e((String)"FirebaseInstanceId", (String)"Exception while binding the service", (Throwable)securityException);
        }
        this.connectionInProgress = false;
        this.finishAllInQueue();
    }

    @GuardedBy(value="this")
    private void finishAllInQueue() {
        while (!this.intentQueue.isEmpty()) {
            this.intentQueue.poll().finish();
        }
    }

    public synchronized void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        String string;
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            string = String.valueOf(componentName);
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
        }
        this.connectionInProgress = false;
        if (!(iBinder instanceof WithinAppServiceBinder)) {
            string = String.valueOf(iBinder);
            Log.e((String)"FirebaseInstanceId", (String)new StringBuilder(28 + String.valueOf(string).length()).append("Invalid service connection: ").append(string).toString());
            this.finishAllInQueue();
            return;
        }
        this.binder = (WithinAppServiceBinder)iBinder;
        this.flushQueue();
    }

    public void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"FirebaseInstanceId", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.flushQueue();
    }

    static class BindRequest {
        final Intent intent;
        private final TaskCompletionSource<Void> taskCompletionSource = new TaskCompletionSource();

        BindRequest(Intent intent) {
            this.intent = intent;
        }

        void arrangeTimeout(ScheduledExecutorService scheduledExecutorService) {
            ScheduledFuture<?> scheduledFuture = scheduledExecutorService.schedule(new WithinAppServiceConnection$BindRequest$$Lambda$0(this), 9000L, TimeUnit.MILLISECONDS);
            this.getTask().addOnCompleteListener((Executor)scheduledExecutorService, (OnCompleteListener)new WithinAppServiceConnection$BindRequest$$Lambda$1(scheduledFuture));
        }

        Task<Void> getTask() {
            return this.taskCompletionSource.getTask();
        }

        void finish() {
            this.taskCompletionSource.trySetResult(null);
        }

        static final /* synthetic */ void lambda$arrangeTimeout$1$WithinAppServiceConnection$BindRequest(ScheduledFuture scheduledFuture, Task task) {
            scheduledFuture.cancel(false);
        }

        final /* synthetic */ void lambda$arrangeTimeout$0$WithinAppServiceConnection$BindRequest() {
            String string = this.intent.getAction();
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(61 + String.valueOf(string).length()).append("Service took too long to process intent: ").append(string).append(" App may get closed.").toString());
            this.finish();
        }
    }
}

