/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.Event;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$0;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$1;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$2;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$3;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$4;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$5;
import com.google.firebase.iid.FirebaseInstanceId$AutoInit$$Lambda$0;
import com.google.firebase.iid.GmsRpc;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.InstanceIdResultImpl;
import com.google.firebase.iid.Metadata;
import com.google.firebase.iid.RequestDeduplicator;
import com.google.firebase.iid.Store;
import com.google.firebase.iid.SyncTask;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseInstanceId {
    private static final long MAX_DELAY_SEC = TimeUnit.HOURS.toSeconds(8L);
    private static Store store;
    private static final Pattern API_KEY_FORMAT;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    static ScheduledExecutorService syncExecutor;
    @VisibleForTesting
    final Executor fileIoExecutor;
    private final FirebaseApp app;
    private final Metadata metadata;
    private final GmsRpc rpc;
    private final RequestDeduplicator requestDeduplicator;
    private final FirebaseInstallationsApi firebaseInstallations;
    @GuardedBy(value="this")
    private boolean syncScheduledOrRunning = false;
    private final AutoInit autoInit;

    @NonNull
    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    public static FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId.checkRequiredFirebaseOptions(firebaseApp);
        FirebaseInstanceId firebaseInstanceId = (FirebaseInstanceId)firebaseApp.get(FirebaseInstanceId.class);
        Preconditions.checkNotNull((Object)firebaseInstanceId, (Object)"Firebase Instance ID component is not present");
        return firebaseInstanceId;
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Subscriber subscriber, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        this(firebaseApp, new Metadata(firebaseApp.getApplicationContext()), FirebaseIidExecutors.newCachedSingleThreadExecutor(), FirebaseIidExecutors.newCachedSingleThreadExecutor(), subscriber, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FirebaseInstanceId(FirebaseApp firebaseApp, Metadata metadata, Executor executor, Executor executor2, Subscriber subscriber, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi) {
        if (Metadata.getDefaultSenderId(firebaseApp) == null) {
            throw new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
        }
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (store == null) {
                store = new Store(firebaseApp.getApplicationContext());
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            this.app = firebaseApp;
            this.metadata = metadata;
            this.rpc = new GmsRpc(firebaseApp, metadata, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
            this.fileIoExecutor = executor2;
            this.autoInit = new AutoInit(subscriber);
            this.requestDeduplicator = new RequestDeduplicator(executor);
            this.firebaseInstallations = firebaseInstallationsApi;
            executor2.execute(new FirebaseInstanceId$$Lambda$0(this));
            return;
        }
    }

    private void startSyncIfNecessary() {
        Store.Token token = this.getTokenWithoutTriggeringSync();
        if (this.tokenNeedsRefresh(token)) {
            this.startSync();
        }
    }

    FirebaseApp getApp() {
        return this.app;
    }

    synchronized void setSyncScheduledOrRunning(boolean bl) {
        this.syncScheduledOrRunning = bl;
    }

    synchronized void startSync() {
        if (!this.syncScheduledOrRunning) {
            this.syncWithDelaySecondsInternal(0L);
        }
    }

    synchronized void syncWithDelaySecondsInternal(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), MAX_DELAY_SEC);
        SyncTask syncTask = new SyncTask(this, l2);
        this.enqueueTaskWithDelaySeconds(syncTask, l);
        this.syncScheduledOrRunning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueTaskWithDelaySeconds(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (FirebaseInstanceId.class) {
            if (syncExecutor == null) {
                syncExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("FirebaseInstanceId"));
            }
            syncExecutor.schedule(runnable, l, TimeUnit.SECONDS);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    @WorkerThread
    @NonNull
    public String getId() {
        FirebaseInstanceId.checkRequiredFirebaseOptions(this.app);
        this.startSyncIfNecessary();
        return this.getIdWithoutTriggeringSync();
    }

    private static void checkRequiredFirebaseOptions(@NonNull FirebaseApp firebaseApp) {
        Preconditions.checkNotEmpty((String)firebaseApp.getOptions().getProjectId(), (Object)"Please set your project ID. A valid Firebase project ID is required to communicate with Firebase server APIs: It identifies your project with Google.");
        Preconditions.checkNotEmpty((String)firebaseApp.getOptions().getApplicationId(), (Object)"Please set your Application ID. A valid Firebase App ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.");
        Preconditions.checkNotEmpty((String)firebaseApp.getOptions().getApiKey(), (Object)"Please set a valid API key. A Firebase API key is required to communicate with Firebase server APIs: It authenticates your project with Google.");
        Preconditions.checkArgument((boolean)FirebaseInstanceId.isValidAppIdFormat(firebaseApp.getOptions().getApplicationId()), (Object)"Please set your Application ID. A valid Firebase App ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.Please refer to https://firebase.google.com/support/privacy/init-options.");
        Preconditions.checkArgument((boolean)FirebaseInstanceId.isValidApiKeyFormat(firebaseApp.getOptions().getApiKey()), (Object)"Please set a valid API key. A Firebase API key is required to communicate with Firebase server APIs: It authenticates your project with Google.Please refer to https://firebase.google.com/support/privacy/init-options.");
    }

    static boolean isValidAppIdFormat(@Nonnull String string) {
        return string.contains(":");
    }

    static boolean isValidApiKeyFormat(@Nonnull String string) {
        return API_KEY_FORMAT.matcher(string).matches();
    }

    String getIdWithoutTriggeringSync() {
        try {
            store.setCreationTime(this.app.getPersistenceKey());
            return (String)FirebaseInstanceId.awaitTaskAllowOnMainThread(this.firebaseInstallations.getId());
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    public long getCreationTime() {
        return store.getCreationTime(this.app.getPersistenceKey());
    }

    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        FirebaseInstanceId.checkRequiredFirebaseOptions(this.app);
        return this.getInstanceId(Metadata.getDefaultSenderId(this.app), "*");
    }

    private Task<InstanceIdResult> getInstanceId(String string, String string2) {
        String string3 = FirebaseInstanceId.rationaliseScope(string2);
        return Tasks.forResult(null).continueWithTask(this.fileIoExecutor, (Continuation)new FirebaseInstanceId$$Lambda$1(this, string, string3));
    }

    @WorkerThread
    public void deleteInstanceId() throws IOException {
        FirebaseInstanceId.checkRequiredFirebaseOptions(this.app);
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        this.awaitTask(this.firebaseInstallations.delete());
        this.resetStorageAndScheduleSync();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        FirebaseInstanceId.checkRequiredFirebaseOptions(this.app);
        Store.Token token = this.getTokenWithoutTriggeringSync();
        if (this.tokenNeedsRefresh(token)) {
            this.startSync();
        }
        return Store.Token.getTokenOrNull(token);
    }

    @Nullable
    @WorkerThread
    public String getToken(@NonNull String string, @NonNull String string2) throws IOException {
        FirebaseInstanceId.checkRequiredFirebaseOptions(this.app);
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        return this.awaitTask(this.getInstanceId(string, string2)).getToken();
    }

    @Nullable
    Store.Token getTokenWithoutTriggeringSync() {
        return this.getTokenWithoutTriggeringSync(Metadata.getDefaultSenderId(this.app), "*");
    }

    @Nullable
    @VisibleForTesting
    Store.Token getTokenWithoutTriggeringSync(String string, String string2) {
        return store.getToken(this.getSubtype(), string, string2);
    }

    String blockingGetMasterToken() throws IOException {
        return this.getToken(Metadata.getDefaultSenderId(this.app), "*");
    }

    private <T> T awaitTask(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if ("INSTANCE_ID_RESET".equals(throwable.getMessage())) {
                    this.resetStorageAndScheduleSync();
                }
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
    }

    private static <T> T awaitTaskAllowOnMainThread(@NonNull Task<T> task) throws InterruptedException {
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        task.addOnCompleteListener(FirebaseInstanceId$$Lambda$2.$instance, (OnCompleteListener)new FirebaseInstanceId$$Lambda$3(countDownLatch));
        countDownLatch.await(30000L, TimeUnit.MILLISECONDS);
        return FirebaseInstanceId.getResultOrThrowException(task);
    }

    private static <T> T getResultOrThrowException(@NonNull Task<T> task) {
        if (task.isSuccessful()) {
            return (T)task.getResult();
        }
        if (task.isCanceled()) {
            throw new CancellationException("Task is already canceled");
        }
        if (task.isComplete()) {
            throw new IllegalStateException(task.getException());
        }
        throw new IllegalThreadStateException("Firebase Installations getId Task has timed out.");
    }

    @WorkerThread
    public void deleteToken(@NonNull String string, @NonNull String string2) throws IOException {
        FirebaseInstanceId.checkRequiredFirebaseOptions(this.app);
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException("MAIN_THREAD");
        }
        string2 = FirebaseInstanceId.rationaliseScope(string2);
        String string3 = this.getIdWithoutTriggeringSync();
        this.awaitTask(this.rpc.deleteToken(string3, string, string2));
        store.deleteToken(this.getSubtype(), string, string2);
    }

    @VisibleForTesting
    @KeepForSdk
    public static synchronized void clearInstancesForTest() {
        if (syncExecutor != null) {
            syncExecutor.shutdownNow();
        }
        syncExecutor = null;
        store = null;
    }

    static boolean isDebugLogEnabled() {
        return Log.isLoggable((String)"FirebaseInstanceId", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseInstanceId", (int)3);
    }

    synchronized void resetStorageAndScheduleSync() {
        store.deleteAll();
        if (this.isFcmAutoInitEnabled()) {
            this.startSync();
        }
    }

    @VisibleForTesting
    public boolean isGmsCorePresent() {
        return this.metadata.isGmscorePresent();
    }

    @VisibleForTesting
    @KeepForSdk
    public boolean isFcmAutoInitEnabled() {
        return this.autoInit.isEnabled();
    }

    @VisibleForTesting
    @KeepForSdk
    public void setFcmAutoInitEnabled(boolean bl) {
        this.autoInit.setEnabled(bl);
    }

    private static String rationaliseScope(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    private String getSubtype() {
        if ("[DEFAULT]".equals(this.app.getName())) {
            return "";
        }
        return this.app.getPersistenceKey();
    }

    boolean tokenNeedsRefresh(@Nullable Store.Token token) {
        return token == null || token.needsRefresh(this.metadata.getAppVersionCode());
    }

    static final /* synthetic */ void lambda$awaitTaskAllowOnMainThread$4$FirebaseInstanceId(CountDownLatch countDownLatch, Task task) {
        countDownLatch.countDown();
    }

    final /* synthetic */ Task lambda$getInstanceId$3$FirebaseInstanceId(String string, String string2, Task task) throws Exception {
        String string3 = this.getIdWithoutTriggeringSync();
        Store.Token token = this.getTokenWithoutTriggeringSync(string, string2);
        if (!this.tokenNeedsRefresh(token)) {
            return Tasks.forResult((Object)new InstanceIdResultImpl(string3, token.token));
        }
        return this.requestDeduplicator.getOrStartGetTokenRequest(string, string2, new FirebaseInstanceId$$Lambda$4(this, string3, string, string2));
    }

    final /* synthetic */ Task lambda$getInstanceId$2$FirebaseInstanceId(String string, String string2, String string3) {
        return this.rpc.getToken(string, string2, string3).onSuccessTask(this.fileIoExecutor, (SuccessContinuation)new FirebaseInstanceId$$Lambda$5(this, string2, string3, string));
    }

    final /* synthetic */ Task lambda$getInstanceId$1$FirebaseInstanceId(String string, String string2, String string3, String string4) throws Exception {
        store.saveToken(this.getSubtype(), string, string2, string4, this.metadata.getAppVersionCode());
        return Tasks.forResult((Object)new InstanceIdResultImpl(string3, string4));
    }

    final /* synthetic */ void lambda$new$0$FirebaseInstanceId() {
        if (this.isFcmAutoInitEnabled()) {
            this.startSyncIfNecessary();
        }
    }

    static {
        API_KEY_FORMAT = Pattern.compile("\\AA[\\w-]{38}\\z");
    }

    private class AutoInit {
        private boolean isFcmLibraryPresent;
        private final Subscriber subscriber;
        @GuardedBy(value="this")
        private boolean initialized;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> dataCollectionDefaultChangeEventHandler;
        @GuardedBy(value="this")
        @Nullable
        private Boolean fcmAutoInitEnabled;

        AutoInit(Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        synchronized void initialize() {
            if (this.initialized) {
                return;
            }
            this.isFcmLibraryPresent = this.isFcmPresent();
            this.fcmAutoInitEnabled = this.readEnabled();
            if (this.fcmAutoInitEnabled == null && this.isFcmLibraryPresent) {
                this.dataCollectionDefaultChangeEventHandler = new FirebaseInstanceId$AutoInit$$Lambda$0(this);
                this.subscriber.subscribe(DataCollectionDefaultChange.class, this.dataCollectionDefaultChangeEventHandler);
            }
            this.initialized = true;
        }

        synchronized boolean isEnabled() {
            this.initialize();
            if (this.fcmAutoInitEnabled != null) {
                return this.fcmAutoInitEnabled;
            }
            return this.isFcmLibraryPresent && FirebaseInstanceId.this.app.isDataCollectionDefaultEnabled();
        }

        synchronized void setEnabled(boolean bl) {
            this.initialize();
            if (this.dataCollectionDefaultChangeEventHandler != null) {
                this.subscriber.unsubscribe(DataCollectionDefaultChange.class, this.dataCollectionDefaultChangeEventHandler);
                this.dataCollectionDefaultChangeEventHandler = null;
            }
            SharedPreferences.Editor editor = FirebaseInstanceId.this.app.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseInstanceId.this.startSyncIfNecessary();
            }
            this.fcmAutoInitEnabled = bl;
        }

        @Nullable
        private Boolean readEnabled() {
            Context context = FirebaseInstanceId.this.app.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        private boolean isFcmPresent() {
            try {
                Class.forName("com.google.firebase.messaging.FirebaseMessaging");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Context context = FirebaseInstanceId.this.app.getApplicationContext();
                Intent intent = new Intent("com.google.firebase.MESSAGING_EVENT");
                intent.setPackage(context.getPackageName());
                ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
                return resolveInfo != null && resolveInfo.serviceInfo != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final /* synthetic */ void lambda$initialize$0$FirebaseInstanceId$AutoInit(Event event) {
            AutoInit autoInit = this;
            synchronized (autoInit) {
                if (this.isEnabled()) {
                    FirebaseInstanceId.this.startSyncIfNecessary();
                }
                return;
            }
        }
    }
}

