/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceIdInternalReceiver;
import com.google.firebase.iid.FirebaseInstanceIdService;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zze;
import com.google.firebase.iid.zzg;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class FirebaseInstanceId {
    private static Map<String, FirebaseInstanceId> zzaTZ = new ArrayMap();
    private static zze zzbSC;
    private final FirebaseApp zzbSD;
    private final zzd zzbSE;
    private final String zzbSF;

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    public static synchronized FirebaseInstanceId getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseInstanceId firebaseInstanceId = zzaTZ.get(firebaseApp.getOptions().getApplicationId());
        if (firebaseInstanceId == null) {
            zzd zzd2 = zzd.zzb(firebaseApp.getApplicationContext(), null);
            if (zzbSC == null) {
                zzbSC = new zze(zzd2.zzUs());
            }
            firebaseInstanceId = new FirebaseInstanceId(firebaseApp, zzd2);
            zzaTZ.put(firebaseApp.getOptions().getApplicationId(), firebaseInstanceId);
        }
        return firebaseInstanceId;
    }

    private FirebaseInstanceId(FirebaseApp firebaseApp, zzd zzd2) {
        this.zzbSD = firebaseApp;
        this.zzbSE = zzd2;
        this.zzbSF = this.zzUm();
        if (this.zzbSF == null) {
            throw new IllegalStateException("IID failing to initialize, FirebaseApp is missing project ID");
        }
        FirebaseInstanceIdService.zza(this.zzbSD.getApplicationContext(), this);
    }

    String zzUm() {
        String string = this.zzbSD.getOptions().getGcmSenderId();
        if (string != null) {
            return string;
        }
        String string2 = this.zzbSD.getOptions().getApplicationId();
        if (string2.startsWith("1:")) {
            String[] stringArray = string2.split(":");
            if (stringArray.length < 2) {
                return null;
            }
            String string3 = stringArray[1];
            if (string3.isEmpty()) {
                return null;
            }
            return string3;
        }
        return string2;
    }

    public String getId() {
        return FirebaseInstanceId.zza(this.zzbSE.zzCd());
    }

    public long getCreationTime() {
        return this.zzbSE.getCreationTime();
    }

    public void deleteInstanceId() throws IOException {
        this.zzbSE.zzb("*", "*", null);
        this.zzbSE.zzCe();
    }

    @Nullable
    public String getToken() {
        String string = this.zzUn();
        if (string == null) {
            FirebaseInstanceIdService.zzby(this.zzbSD.getApplicationContext());
        }
        return string;
    }

    @Nullable
    String zzUn() {
        return this.zzbSE.zzUs().zzi("", this.zzbSF, "*");
    }

    String zzUo() throws IOException {
        return this.getToken(this.zzbSF, "*");
    }

    @WorkerThread
    public String getToken(String string, String string2) throws IOException {
        return this.zzbSE.getToken(string, string2, null);
    }

    @WorkerThread
    public void deleteToken(String string, String string2) throws IOException {
        this.zzbSE.zzb(string, string2, null);
    }

    public void zziy(String string) {
        zzbSC.zziy(string);
        FirebaseInstanceIdService.zzby(this.zzbSD.getApplicationContext());
    }

    zze zzUp() {
        return zzbSC;
    }

    void zziz(String string) throws IOException {
        if (this.getToken() == null) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzbSE.getToken(this.getToken(), string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    void zziA(String string) throws IOException {
        if (this.getToken() == null) {
            throw new IOException("token not available");
        }
        Bundle bundle = new Bundle();
        String string2 = String.valueOf("/topics/");
        String string3 = String.valueOf(string);
        bundle.putString("gcm.topic", string3.length() != 0 ? string2.concat(string3) : new String(string2));
        String string4 = String.valueOf("/topics/");
        String string5 = String.valueOf(string);
        this.zzbSE.zzb(this.getToken(), string5.length() != 0 ? string4.concat(string5) : new String(string4), bundle);
    }

    static String zzbx(Context context) {
        return FirebaseInstanceId.getInstance().zzbSD.getOptions().getApplicationId();
    }

    static String zzp(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = messageDigest.digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)(n & 0xFF);
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"FirebaseInstanceId", (String)"Unexpected error, device missing required alghorithms");
            return null;
        }
    }

    static int zzaU(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return 0;
        }
    }

    static String zzaV(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string = String.valueOf((Object)nameNotFoundException);
            Log.w((String)"FirebaseInstanceId", (String)new StringBuilder(38 + String.valueOf(string).length()).append("Never happens: can't find own package ").append(string).toString());
            return null;
        }
    }

    static void zza(Context context, zzg zzg2) {
        zzg2.zzCk();
        Intent intent = new Intent();
        intent.putExtra("CMD", "RST");
        context.sendBroadcast(FirebaseInstanceIdInternalReceiver.zzh(context, intent));
    }

    static void zzaW(Context context) {
        Intent intent = new Intent();
        intent.setPackage(context.getPackageName());
        intent.putExtra("CMD", "SYNC");
        context.sendBroadcast(FirebaseInstanceIdInternalReceiver.zzh(context, intent));
    }
}

