/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.iid.MessengerCompat;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzd;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class zzf {
    static String ait = null;
    static int aiu = 0;
    static int aiv = 0;
    static int aiw = 0;
    Context zzahs;
    Map<String, Object> aix = new HashMap<String, Object>();
    Messenger ahg;
    Messenger aiy;
    MessengerCompat aiz;
    PendingIntent ahc;
    long aiA;
    long aiB;
    int aiC;
    int aiD;
    long aiE;

    public zzf(Context context) {
        this.zzahs = context;
    }

    public static String zzdg(Context context) {
        if (ait != null) {
            return ait;
        }
        aiu = Process.myUid();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentServices(new Intent("com.google.android.c2dm.intent.REGISTER"), 0);
        for (ResolveInfo resolveInfo : list) {
            String string;
            if (0 == packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", resolveInfo.serviceInfo.packageName)) {
                try {
                    string = packageManager.getApplicationInfo(resolveInfo.serviceInfo.packageName, 0);
                    int n = ((ApplicationInfo)string).uid;
                    Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(17).append("Found ").append(n).toString());
                    aiv = ((ApplicationInfo)string).uid;
                    ait = resolveInfo.serviceInfo.packageName;
                    return ait;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    continue;
                }
            }
            string = String.valueOf(resolveInfo.serviceInfo.packageName);
            String string2 = String.valueOf("com.google.android.c2dm.intent.REGISTER");
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(56 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Possible malicious package ").append(string).append(" declares ").append(string2).append(" without permission").toString());
        }
        Log.w((String)"InstanceID/Rpc", (String)"Failed to resolve REGISTER intent, falling back");
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gms", 0);
            ait = applicationInfo.packageName;
            aiv = applicationInfo.uid;
            return ait;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.gsf", 0);
                ait = applicationInfo.packageName;
                aiv = applicationInfo.uid;
                return ait;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                Log.w((String)"InstanceID/Rpc", (String)"Both Google Play Services and legacy GSF package are missing");
                return null;
            }
        }
    }

    static String zza(KeyPair keyPair, String ... stringArray) {
        byte[] byArray;
        try {
            byArray = TextUtils.join((CharSequence)"\n", (Object[])stringArray).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to encode string", (Throwable)unsupportedEncodingException);
            return null;
        }
        try {
            PrivateKey privateKey = keyPair.getPrivate();
            String string = privateKey instanceof RSAPrivateKey ? "SHA256withRSA" : "SHA256withECDSA";
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return FirebaseInstanceId.zzv(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            Log.e((String)"InstanceID/Rpc", (String)"Unable to sign registration request", (Throwable)generalSecurityException);
            return null;
        }
    }

    void zzbon() {
        if (this.ahg != null) {
            return;
        }
        zzf.zzdg(this.zzahs);
        this.ahg = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                zzf.this.zze(message);
            }
        });
    }

    public void zze(Message message) {
        if (message == null) {
            return;
        }
        if (message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader(MessengerCompat.class.getClassLoader());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof MessengerCompat) {
                    this.aiz = (MessengerCompat)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.aiy = (Messenger)parcelable;
                }
            }
            this.zzv((Intent)message.obj);
        } else {
            Log.w((String)"InstanceID/Rpc", (String)"Dropping invalid message");
        }
    }

    synchronized void zzs(Intent intent) {
        if (this.ahc == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.ahc = PendingIntent.getBroadcast((Context)this.zzahs, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.ahc);
    }

    public void zza(Bundle bundle, KeyPair keyPair, String string) throws IOException {
        long l = SystemClock.elapsedRealtime();
        if (this.aiE != 0L && l <= this.aiE) {
            long l2 = this.aiE - l;
            int n = this.aiD;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(78).append("Backoff mode, next request attempt: ").append(l2).append(" interval: ").append(n).toString());
            throw new IOException("RETRY_LATER");
        }
        this.zzbon();
        if (ait == null) {
            throw new IOException("MISSING_INSTANCEID_SERVICE");
        }
        this.aiA = SystemClock.elapsedRealtime();
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(ait);
        bundle.putString("gmsv", Integer.toString(FirebaseInstanceId.zzaj(this.zzahs, zzf.zzdg(this.zzahs))));
        bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
        bundle.putString("app_ver", Integer.toString(FirebaseInstanceId.zzeq(this.zzahs)));
        bundle.putString("app_ver_name", FirebaseInstanceId.zzde(this.zzahs));
        bundle.putString("cliv", "fiid-9877000");
        bundle.putString("appid", FirebaseInstanceId.zza(keyPair));
        String string2 = FirebaseInstanceId.zzep(this.zzahs);
        if (string2 != null) {
            bundle.putString("gmp_app_id", string2);
        }
        String string3 = FirebaseInstanceId.zzv(keyPair.getPublic().getEncoded());
        bundle.putString("pub2", string3);
        bundle.putString("sig", zzf.zza(keyPair, this.zzahs.getPackageName(), string3));
        intent.putExtras(bundle);
        this.zzs(intent);
        this.zzb(intent, string);
    }

    protected void zzb(Intent intent, String string) {
        block7: {
            String string2;
            this.aiA = SystemClock.elapsedRealtime();
            intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            intent.putExtra("X-kid", new StringBuilder(5 + String.valueOf(string).length()).append("|ID|").append(string).append("|").toString());
            boolean bl = "com.google.android.gsf".equals(ait);
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                string2 = String.valueOf(intent.getExtras());
                Log.d((String)"InstanceID/Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
            }
            if (bl) {
                this.zzahs.startService(intent);
                return;
            }
            intent.putExtra("google.messenger", (Parcelable)this.ahg);
            if (this.aiy != null || this.aiz != null) {
                string2 = Message.obtain();
                ((Message)string2).obj = intent;
                try {
                    if (this.aiy != null) {
                        this.aiy.send((Message)string2);
                    } else {
                        this.aiz.send((Message)string2);
                    }
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!Log.isLoggable((String)"InstanceID/Rpc", (int)3)) break block7;
                    Log.d((String)"InstanceID/Rpc", (String)"Messenger failed, fallback to startService");
                }
            }
        }
        this.zzahs.startService(intent);
    }

    String zzt(Intent intent) throws IOException {
        if (intent == null) {
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        String string = intent.getStringExtra("registration_id");
        if (string == null) {
            string = intent.getStringExtra("unregistered");
        }
        if (string == null) {
            string = intent.getStringExtra("error");
            if (string != null) {
                throw new IOException(string);
            }
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Unexpected response from GCM ").append(string2).toString(), (Throwable)new Throwable());
            throw new IOException("SERVICE_NOT_AVAILABLE");
        }
        return string;
    }

    void zzu(Intent intent) {
        String string = intent.getStringExtra("error");
        if (string == null) {
            String string2 = String.valueOf(intent.getExtras());
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("Unexpected response, no error or registration id ").append(string2).toString());
            return;
        }
        if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
            String string3 = String.valueOf(string);
            Log.d((String)"InstanceID/Rpc", (String)(string3.length() != 0 ? "Received InstanceID error ".concat(string3) : new String("Received InstanceID error ")));
        }
        String string4 = null;
        if (string.startsWith("|")) {
            String[] stringArray = string.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            if (stringArray.length > 2) {
                string4 = stringArray[2];
                string = stringArray[3];
                if (string.startsWith(":")) {
                    string = string.substring(1);
                }
            } else {
                string = "UNKNOWN";
            }
            intent.putExtra("error", string);
        }
        if (null == string4) {
            this.zzai(string);
        } else {
            this.zzi(string4, string);
        }
        long l = intent.getLongExtra("Retry-After", 0L);
        if (l > 0L) {
            this.aiB = SystemClock.elapsedRealtime();
            this.aiD = (int)l * 1000;
            this.aiE = SystemClock.elapsedRealtime() + (long)this.aiD;
            int n = this.aiD;
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(52).append("Explicit request from server to backoff: ").append(n).toString());
        } else if ("SERVICE_NOT_AVAILABLE".equals(string) || "AUTHENTICATION_FAILED".equals(string)) {
            this.zzkp(string);
        }
    }

    private void zzkp(String string) {
        if (!"com.google.android.gsf".equals(ait)) {
            return;
        }
        ++this.aiC;
        if (this.aiC < 3) {
            return;
        }
        if (this.aiC == 3) {
            this.aiD = 1000 + new Random().nextInt(1000);
        }
        this.aiD *= 2;
        this.aiE = SystemClock.elapsedRealtime() + (long)this.aiD;
        int n = this.aiD;
        Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Backoff due to ").append(string).append(" for ").append(n).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzai(Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            for (String string : this.aix.keySet()) {
                Object object2 = this.aix.get(string);
                this.aix.put(string, object);
                this.zzh(object2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzi(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Object object2 = this.aix.get(string);
            this.aix.put(string, object);
            this.zzh(object2, object);
        }
    }

    private void zzh(Object object, Object object2) {
        if (object instanceof ConditionVariable) {
            ((ConditionVariable)object).open();
        }
        if (object instanceof Messenger) {
            Messenger messenger = (Messenger)object;
            Message message = Message.obtain();
            message.obj = object2;
            try {
                messenger.send(message);
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf((Object)remoteException);
                Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Failed to send response ").append(string).toString());
            }
        }
    }

    void zzv(Intent intent) {
        if (intent == null) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                Log.d((String)"InstanceID/Rpc", (String)"Unexpected response: null");
            }
            return;
        }
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
            if (Log.isLoggable((String)"InstanceID/Rpc", (int)3)) {
                String string2 = String.valueOf(intent.getAction());
                Log.d((String)"InstanceID/Rpc", (String)(string2.length() != 0 ? "Unexpected response ".concat(string2) : new String("Unexpected response ")));
            }
            return;
        }
        String string3 = intent.getStringExtra("registration_id");
        if (string3 == null) {
            string3 = intent.getStringExtra("unregistered");
        }
        if (string3 == null) {
            this.zzu(intent);
            return;
        }
        this.aiA = SystemClock.elapsedRealtime();
        this.aiE = 0L;
        this.aiC = 0;
        this.aiD = 0;
        String string4 = null;
        if (string3.startsWith("|")) {
            String[] stringArray = string3.split("\\|");
            if (!"ID".equals(stringArray[1])) {
                String string5 = String.valueOf(string3);
                Log.w((String)"InstanceID/Rpc", (String)(string5.length() != 0 ? "Unexpected structured response ".concat(string5) : new String("Unexpected structured response ")));
            }
            string4 = stringArray[2];
            if (stringArray.length > 4) {
                if ("SYNC".equals(stringArray[3])) {
                    FirebaseInstanceId.zzdf(this.zzahs);
                } else if ("RST".equals(stringArray[3])) {
                    FirebaseInstanceId.zza(this.zzahs, zzd.zzb(this.zzahs, null).J());
                    intent.removeExtra("registration_id");
                    this.zzi(string4, intent);
                    return;
                }
            }
            if ((string3 = stringArray[stringArray.length - 1]).startsWith(":")) {
                string3 = string3.substring(1);
            }
            intent.putExtra("registration_id", string3);
        }
        if (null == string4) {
            this.zzai(intent);
        } else {
            this.zzi(string4, intent);
        }
    }

    Intent zza(Bundle bundle, KeyPair keyPair) throws IOException {
        Intent intent = this.zzb(bundle, keyPair);
        if (intent != null && intent.hasExtra("google.messenger") && (intent = this.zzb(bundle, keyPair)) != null && intent.hasExtra("google.messenger")) {
            intent = null;
        }
        return intent;
    }

    public static synchronized String zzboo() {
        return Integer.toString(aiw++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent zzb(Bundle bundle, KeyPair keyPair) throws IOException {
        ConditionVariable conditionVariable = new ConditionVariable();
        String string = zzf.zzboo();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.aix.put(string, conditionVariable);
        }
        this.zza(bundle, keyPair, string);
        conditionVariable.block(30000L);
        clazz = this.getClass();
        synchronized (clazz) {
            Object object = this.aix.remove(string);
            if (object instanceof Intent) {
                return (Intent)object;
            }
            if (object instanceof String) {
                throw new IOException((String)object);
            }
            String string2 = String.valueOf(object);
            Log.w((String)"InstanceID/Rpc", (String)new StringBuilder(12 + String.valueOf(string2).length()).append("No response ").append(string2).toString());
            throw new IOException("TIMEOUT");
        }
    }
}

