/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.util.zzw;
import com.google.firebase.iid.FirebaseInstanceId;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class zzg {
    SharedPreferences aiG;
    Context zzahs;

    public zzg(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    public zzg(Context context, String string) {
        this.zzahs = context;
        this.aiG = context.getSharedPreferences(string, 4);
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("-no-backup");
        this.zzkq(string3.length() != 0 ? string2.concat(string3) : new String(string2));
    }

    public synchronized long zztv(String string) {
        String string2 = this.zzbu(string, "cre");
        String string3 = this.aiG.getString(string2, null);
        if (string3 != null) {
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public SharedPreferences M() {
        return this.aiG;
    }

    private void zzkq(String string) {
        block4: {
            File file = zzw.getNoBackupFilesDir((Context)this.zzahs);
            File file2 = new File(file, string);
            if (file2.exists()) {
                return;
            }
            try {
                if (file2.createNewFile() && !this.isEmpty()) {
                    Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                    FirebaseInstanceId.zza(this.zzahs, this);
                }
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                String string2 = String.valueOf(iOException.getMessage());
                Log.d((String)"InstanceID/Store", (String)(string2.length() != 0 ? "Error creating file in no backup dir: ".concat(string2) : new String("Error creating file in no backup dir: ")));
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.aiG.getAll().isEmpty();
    }

    private String zzp(String string, String string2, String string3) {
        String string4 = String.valueOf("|T|");
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string4).append(string2).append("|").append(string3).toString();
    }

    private String zzbu(String string, String string2) {
        String string3 = String.valueOf("|S|");
        return new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string).append(string3).append(string2).toString();
    }

    private void zzkr(String string) {
        SharedPreferences.Editor editor = this.aiG.edit();
        Map map = this.aiG.getAll();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            editor.remove(string2);
        }
        editor.commit();
    }

    public synchronized void zzbop() {
        this.aiG.edit().clear().commit();
    }

    public synchronized zza zzq(String string, String string2, String string3) {
        return zza.zztx(this.aiG.getString(this.zzp(string, string2, string3), null));
    }

    public synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = zza.zzc(string4, string5, System.currentTimeMillis());
        if (string6 == null) {
            return;
        }
        SharedPreferences.Editor editor = this.aiG.edit();
        editor.putString(this.zzp(string, string2, string3), string6);
        editor.commit();
    }

    public synchronized void zzi(String string, String string2, String string3) {
        String string4 = this.zzp(string, string2, string3);
        SharedPreferences.Editor editor = this.aiG.edit();
        editor.remove(string4);
        editor.commit();
    }

    synchronized KeyPair zztw(String string) {
        KeyPair keyPair = com.google.firebase.iid.zza.zzboh();
        long l = System.currentTimeMillis();
        SharedPreferences.Editor editor = this.aiG.edit();
        editor.putString(this.zzbu(string, "|P|"), FirebaseInstanceId.zzv(keyPair.getPublic().getEncoded()));
        editor.putString(this.zzbu(string, "|K|"), FirebaseInstanceId.zzv(keyPair.getPrivate().getEncoded()));
        editor.putString(this.zzbu(string, "cre"), Long.toString(l));
        editor.commit();
        return keyPair;
    }

    synchronized void zzkt(String string) {
        this.zzkr(String.valueOf(string).concat("|"));
    }

    public synchronized void zzku(String string) {
        this.zzkr(String.valueOf(string).concat("|T|"));
    }

    public synchronized KeyPair zzks(String string) {
        String string2 = this.aiG.getString(this.zzbu(string, "|P|"), null);
        String string3 = this.aiG.getString(this.zzbu(string, "|K|"), null);
        if (string2 == null || string3 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)8);
            byte[] byArray2 = Base64.decode((String)string3, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            String string4 = String.valueOf(generalSecurityException);
            Log.w((String)"InstanceID/Store", (String)new StringBuilder(19 + String.valueOf(string4).length()).append("Invalid key stored ").append(string4).toString());
            FirebaseInstanceId.zza(this.zzahs, this);
            return null;
        }
    }

    static class zza {
        private static final long bkQ = TimeUnit.DAYS.toMillis(7L);
        final String axH;
        final String aii;
        final long timestamp;

        private zza(String string, String string2, long l) {
            this.axH = string;
            this.aii = string2;
            this.timestamp = l;
        }

        static zza zztx(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            if (string.startsWith("{")) {
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    return new zza(jSONObject.getString("token"), jSONObject.getString("appVersion"), jSONObject.getLong("timestamp"));
                }
                catch (JSONException jSONException) {
                    String string2 = String.valueOf((Object)jSONException);
                    Log.w((String)"InstanceID/Store", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Failed to parse token: ").append(string2).toString());
                    return null;
                }
            }
            return new zza(string, null, 0L);
        }

        static String zzc(String string, String string2, long l) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("token", (Object)string);
                jSONObject.put("appVersion", (Object)string2);
                jSONObject.put("timestamp", l);
                return jSONObject.toString();
            }
            catch (JSONException jSONException) {
                String string3 = String.valueOf((Object)jSONException);
                Log.w((String)"InstanceID/Store", (String)new StringBuilder(24 + String.valueOf(string3).length()).append("Failed to encode token: ").append(string3).toString());
                return null;
            }
        }

        boolean zzty(String string) {
            return System.currentTimeMillis() > this.timestamp + bkQ || !string.equals(this.aii);
        }
    }
}

