/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class InAppMessageLayoutConfig {
    private Float maxImageHeightWeight;
    private Float maxImageWidthWeight;
    private Float maxBodyHeightWeight;
    private Float maxBodyWidthWeight;
    private Integer maxDialogHeightPx;
    private Integer maxDialogWidthPx;
    private Integer windowFlag;
    private Integer viewWindowGravity;
    private Integer windowWidth;
    private Integer windowHeight;
    private Boolean backgroundEnabled;
    private Boolean animate;
    private Boolean autoDismiss;

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public Float maxImageHeightWeight() {
        return this.maxImageHeightWeight;
    }

    public Float maxImageWidthWeight() {
        return this.maxImageWidthWeight;
    }

    @Nullable
    public Float maxBodyHeightWeight() {
        return this.maxBodyHeightWeight;
    }

    @Nullable
    public Float maxBodyWidthWeight() {
        return this.maxBodyWidthWeight;
    }

    public Integer maxDialogHeightPx() {
        return this.maxDialogHeightPx;
    }

    public Integer maxDialogWidthPx() {
        return this.maxDialogWidthPx;
    }

    public Integer windowFlag() {
        return this.windowFlag;
    }

    public Integer viewWindowGravity() {
        return this.viewWindowGravity;
    }

    public Integer windowWidth() {
        return this.windowWidth;
    }

    public Integer windowHeight() {
        return this.windowHeight;
    }

    public Boolean backgroundEnabled() {
        return this.backgroundEnabled;
    }

    public Boolean animate() {
        return this.animate;
    }

    public Boolean autoDismiss() {
        return this.autoDismiss;
    }

    public int getMaxImageHeight() {
        return (int)(this.maxImageHeightWeight().floatValue() * (float)this.maxDialogHeightPx().intValue());
    }

    public int getMaxImageWidth() {
        return (int)(this.maxImageWidthWeight().floatValue() * (float)this.maxDialogWidthPx().intValue());
    }

    public int getMaxBodyHeight() {
        return (int)(this.maxBodyHeightWeight().floatValue() * (float)this.maxDialogHeightPx().intValue());
    }

    public int getMaxBodyWidth() {
        return (int)(this.maxBodyWidthWeight().floatValue() * (float)this.maxDialogWidthPx().intValue());
    }

    public static class Builder {
        private final InAppMessageLayoutConfig config = new InAppMessageLayoutConfig();

        public Builder setMaxImageHeightWeight(Float maxImageHeightWeight) {
            this.config.maxImageHeightWeight = maxImageHeightWeight;
            return this;
        }

        public Builder setMaxImageWidthWeight(Float maxImageWidthWeight) {
            this.config.maxImageWidthWeight = maxImageWidthWeight;
            return this;
        }

        public Builder setMaxBodyHeightWeight(Float maxBodyHeightWeight) {
            this.config.maxBodyHeightWeight = maxBodyHeightWeight;
            return this;
        }

        public Builder setMaxBodyWidthWeight(Float maxBodyWidthWeight) {
            this.config.maxBodyWidthWeight = maxBodyWidthWeight;
            return this;
        }

        public Builder setMaxDialogHeightPx(Integer maxDialogHeightPx) {
            this.config.maxDialogHeightPx = maxDialogHeightPx;
            return this;
        }

        public Builder setMaxDialogWidthPx(Integer maxDialogWidthPx) {
            this.config.maxDialogWidthPx = maxDialogWidthPx;
            return this;
        }

        public Builder setViewWindowGravity(Integer viewWindowGravity) {
            this.config.viewWindowGravity = viewWindowGravity;
            return this;
        }

        public Builder setWindowFlag(Integer windowFlag) {
            this.config.windowFlag = windowFlag;
            return this;
        }

        public Builder setWindowWidth(Integer windowWidth) {
            this.config.windowWidth = windowWidth;
            return this;
        }

        public Builder setWindowHeight(Integer windowHeight) {
            this.config.windowHeight = windowHeight;
            return this;
        }

        public Builder setBackgroundEnabled(Boolean backgroundEnabled) {
            this.config.backgroundEnabled = backgroundEnabled;
            return this;
        }

        public Builder setAnimate(Boolean animate) {
            this.config.animate = animate;
            return this;
        }

        public Builder setAutoDismiss(Boolean autoDismiss) {
            this.config.autoDismiss = autoDismiss;
            return this;
        }

        public InAppMessageLayoutConfig build() {
            return this.config;
        }
    }
}

