/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging;

import android.app.Application;
import android.content.Context;
import androidx.annotation.Keep;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.abt.component.AbtComponent;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.events.Subscriber;
import com.google.firebase.inappmessaging.FirebaseInAppMessaging;
import com.google.firebase.inappmessaging.internal.AbtIntegrationHelper;
import com.google.firebase.inappmessaging.internal.ProgramaticContextualTriggers;
import com.google.firebase.inappmessaging.internal.injection.components.AppComponent;
import com.google.firebase.inappmessaging.internal.injection.components.DaggerAppComponent;
import com.google.firebase.inappmessaging.internal.injection.components.DaggerUniversalComponent;
import com.google.firebase.inappmessaging.internal.injection.components.UniversalComponent;
import com.google.firebase.inappmessaging.internal.injection.modules.AnalyticsEventsModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule;
import com.google.firebase.inappmessaging.internal.injection.modules.AppMeasurementModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ApplicationModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ExecutorsModule;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcClientModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ProgrammaticContextualTriggerFlowableModule;
import com.google.firebase.inject.Deferred;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;

@Keep
public class FirebaseInAppMessagingRegistrar
implements ComponentRegistrar {
    private static final String LIBRARY_NAME = "fire-fiam";
    private Qualified<Executor> backgroundExecutor = Qualified.qualified(Background.class, Executor.class);
    private Qualified<Executor> blockingExecutor = Qualified.qualified(Blocking.class, Executor.class);
    private Qualified<Executor> lightWeightExecutor = Qualified.qualified(Lightweight.class, Executor.class);

    @Keep
    public List<Component<?>> getComponents() {
        return Arrays.asList(Component.builder(FirebaseInAppMessaging.class).name(LIBRARY_NAME).add(Dependency.required(Context.class)).add(Dependency.required(FirebaseInstallationsApi.class)).add(Dependency.required(FirebaseApp.class)).add(Dependency.required(AbtComponent.class)).add(Dependency.deferred(AnalyticsConnector.class)).add(Dependency.required(TransportFactory.class)).add(Dependency.required(Subscriber.class)).add(Dependency.required(this.backgroundExecutor)).add(Dependency.required(this.blockingExecutor)).add(Dependency.required(this.lightWeightExecutor)).factory(this::providesFirebaseInAppMessaging).eagerInDefaultApp().build(), LibraryVersionComponent.create((String)LIBRARY_NAME, (String)"20.3.2"));
    }

    private FirebaseInAppMessaging providesFirebaseInAppMessaging(ComponentContainer container) {
        FirebaseApp firebaseApp = (FirebaseApp)container.get(FirebaseApp.class);
        FirebaseInstallationsApi firebaseInstallations = (FirebaseInstallationsApi)container.get(FirebaseInstallationsApi.class);
        Deferred analyticsConnector = container.getDeferred(AnalyticsConnector.class);
        Subscriber firebaseEventsSubscriber = (Subscriber)container.get(Subscriber.class);
        Application application = (Application)firebaseApp.getApplicationContext();
        UniversalComponent universalComponent = DaggerUniversalComponent.builder().applicationModule(new ApplicationModule(application)).appMeasurementModule(new AppMeasurementModule((Deferred<AnalyticsConnector>)analyticsConnector, firebaseEventsSubscriber)).analyticsEventsModule(new AnalyticsEventsModule()).programmaticContextualTriggerFlowableModule(new ProgrammaticContextualTriggerFlowableModule(new ProgramaticContextualTriggers())).executorsModule(new ExecutorsModule((Executor)container.get(this.lightWeightExecutor), (Executor)container.get(this.backgroundExecutor), (Executor)container.get(this.blockingExecutor))).build();
        AppComponent instance = DaggerAppComponent.builder().abtIntegrationHelper(new AbtIntegrationHelper(((AbtComponent)container.get(AbtComponent.class)).get("fiam"), (Executor)container.get(this.blockingExecutor))).apiClientModule(new ApiClientModule(firebaseApp, firebaseInstallations, universalComponent.clock())).grpcClientModule(new GrpcClientModule(firebaseApp)).universalComponent(universalComponent).transportFactory((TransportFactory)container.get(TransportFactory.class)).build();
        return instance.providesFirebaseInAppMessaging();
    }
}

