/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal.injection.components;

import android.app.Application;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.events.Subscriber;
import com.google.firebase.inappmessaging.FirebaseInAppMessaging;
import com.google.firebase.inappmessaging.FirebaseInAppMessaging_Factory;
import com.google.firebase.inappmessaging.dagger.internal.DoubleCheck;
import com.google.firebase.inappmessaging.dagger.internal.InstanceFactory;
import com.google.firebase.inappmessaging.dagger.internal.Preconditions;
import com.google.firebase.inappmessaging.internal.AbtIntegrationHelper;
import com.google.firebase.inappmessaging.internal.AnalyticsEventsManager;
import com.google.firebase.inappmessaging.internal.ApiClient;
import com.google.firebase.inappmessaging.internal.CampaignCacheClient;
import com.google.firebase.inappmessaging.internal.DataCollectionHelper;
import com.google.firebase.inappmessaging.internal.DeveloperListenerManager;
import com.google.firebase.inappmessaging.internal.DisplayCallbacksFactory;
import com.google.firebase.inappmessaging.internal.DisplayCallbacksFactory_Factory;
import com.google.firebase.inappmessaging.internal.GrpcClient;
import com.google.firebase.inappmessaging.internal.GrpcClient_Factory;
import com.google.firebase.inappmessaging.internal.ImpressionStorageClient;
import com.google.firebase.inappmessaging.internal.InAppMessageStreamManager;
import com.google.firebase.inappmessaging.internal.InAppMessageStreamManager_Factory;
import com.google.firebase.inappmessaging.internal.MetricsLoggerClient;
import com.google.firebase.inappmessaging.internal.ProgramaticContextualTriggers;
import com.google.firebase.inappmessaging.internal.ProviderInstaller;
import com.google.firebase.inappmessaging.internal.RateLimiterClient;
import com.google.firebase.inappmessaging.internal.Schedulers;
import com.google.firebase.inappmessaging.internal.SharedPreferencesUtils;
import com.google.firebase.inappmessaging.internal.TestDeviceHelper;
import com.google.firebase.inappmessaging.internal.injection.components.AppComponent;
import com.google.firebase.inappmessaging.internal.injection.components.UniversalComponent;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesApiClientFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesDataCollectionHelperFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesFirebaseAppFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesFirebaseInstallationsFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesSharedPreferencesUtilsFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.ApiClientModule_ProvidesTestDeviceHelperFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcClientModule;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcClientModule_ProvidesApiKeyHeadersFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.GrpcClientModule_ProvidesInAppMessagingSdkServingStubFactory;
import com.google.firebase.inappmessaging.internal.injection.modules.TransportClientModule_ProvidesMetricsLoggerClientFactory;
import com.google.firebase.inappmessaging.internal.time.Clock;
import com.google.firebase.inappmessaging.model.RateLimit;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.InAppMessagingSdkServingGrpc;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.reactivex.flowables.ConnectableFlowable;
import java.util.concurrent.Executor;
import javax.inject.Provider;

public final class DaggerAppComponent
implements AppComponent {
    private final UniversalComponent universalComponent;
    private final ApiClientModule apiClientModule;
    private Provider<ConnectableFlowable<String>> appForegroundEventFlowableProvider;
    private Provider<ConnectableFlowable<String>> programmaticContextualTriggerFlowableProvider;
    private Provider<CampaignCacheClient> campaignCacheClientProvider;
    private Provider<Clock> clockProvider;
    private Provider<Channel> gRPCChannelProvider;
    private Provider<Metadata> providesApiKeyHeadersProvider;
    private Provider<InAppMessagingSdkServingGrpc.InAppMessagingSdkServingBlockingStub> providesInAppMessagingSdkServingStubProvider;
    private Provider<GrpcClient> grpcClientProvider;
    private Provider<Application> applicationProvider;
    private Provider<ProviderInstaller> providerInstallerProvider;
    private Provider<ApiClient> providesApiClientProvider;
    private Provider<AnalyticsEventsManager> analyticsEventsManagerProvider;
    private Provider<Schedulers> schedulersProvider;
    private Provider<ImpressionStorageClient> impressionStorageClientProvider;
    private Provider<RateLimiterClient> rateLimiterClientProvider;
    private Provider<RateLimit> appForegroundRateLimitProvider;
    private Provider<SharedPreferencesUtils> providesSharedPreferencesUtilsProvider;
    private Provider<TestDeviceHelper> providesTestDeviceHelperProvider;
    private Provider<FirebaseInstallationsApi> providesFirebaseInstallationsProvider;
    private Provider<Subscriber> firebaseEventsSubscriberProvider;
    private Provider<DataCollectionHelper> providesDataCollectionHelperProvider;
    private Provider<AbtIntegrationHelper> abtIntegrationHelperProvider;
    private Provider<Executor> blockingExecutorProvider;
    private Provider<InAppMessageStreamManager> inAppMessageStreamManagerProvider;
    private Provider<ProgramaticContextualTriggers> programmaticContextualTriggersProvider;
    private Provider<FirebaseApp> providesFirebaseAppProvider;
    private Provider<TransportFactory> transportFactoryProvider;
    private Provider<AnalyticsConnector> analyticsConnectorProvider;
    private Provider<DeveloperListenerManager> developerListenerManagerProvider;
    private Provider<MetricsLoggerClient> providesMetricsLoggerClientProvider;
    private Provider<DisplayCallbacksFactory> displayCallbacksFactoryProvider;
    private Provider<Executor> lightWeightExecutorProvider;
    private Provider<FirebaseInAppMessaging> firebaseInAppMessagingProvider;

    private DaggerAppComponent(ApiClientModule apiClientModuleParam, GrpcClientModule grpcClientModuleParam, UniversalComponent universalComponentParam, AbtIntegrationHelper abtIntegrationHelperParam, TransportFactory transportFactoryParam) {
        this.universalComponent = universalComponentParam;
        this.apiClientModule = apiClientModuleParam;
        this.initialize(apiClientModuleParam, grpcClientModuleParam, universalComponentParam, abtIntegrationHelperParam, transportFactoryParam);
    }

    public static AppComponent.Builder builder() {
        return new Builder();
    }

    private DataCollectionHelper getDataCollectionHelper() {
        return ApiClientModule_ProvidesDataCollectionHelperFactory.providesDataCollectionHelper(this.apiClientModule, ApiClientModule_ProvidesSharedPreferencesUtilsFactory.providesSharedPreferencesUtils(this.apiClientModule), Preconditions.checkNotNull(this.universalComponent.firebaseEventsSubscriber(), "Cannot return null from a non-@Nullable component method"));
    }

    private void initialize(ApiClientModule apiClientModuleParam, GrpcClientModule grpcClientModuleParam, UniversalComponent universalComponentParam, AbtIntegrationHelper abtIntegrationHelperParam, TransportFactory transportFactoryParam) {
        this.appForegroundEventFlowableProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_appForegroundEventFlowable(universalComponentParam);
        this.programmaticContextualTriggerFlowableProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_programmaticContextualTriggerFlowable(universalComponentParam);
        this.campaignCacheClientProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_campaignCacheClient(universalComponentParam);
        this.clockProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_clock(universalComponentParam);
        this.gRPCChannelProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_gRPCChannel(universalComponentParam);
        this.providesApiKeyHeadersProvider = GrpcClientModule_ProvidesApiKeyHeadersFactory.create(grpcClientModuleParam);
        this.providesInAppMessagingSdkServingStubProvider = DoubleCheck.provider(GrpcClientModule_ProvidesInAppMessagingSdkServingStubFactory.create(grpcClientModuleParam, this.gRPCChannelProvider, this.providesApiKeyHeadersProvider));
        this.grpcClientProvider = DoubleCheck.provider(GrpcClient_Factory.create(this.providesInAppMessagingSdkServingStubProvider));
        this.applicationProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_application(universalComponentParam);
        this.providerInstallerProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_providerInstaller(universalComponentParam);
        this.providesApiClientProvider = DoubleCheck.provider(ApiClientModule_ProvidesApiClientFactory.create(apiClientModuleParam, this.grpcClientProvider, this.applicationProvider, this.providerInstallerProvider));
        this.analyticsEventsManagerProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_analyticsEventsManager(universalComponentParam);
        this.schedulersProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_schedulers(universalComponentParam);
        this.impressionStorageClientProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_impressionStorageClient(universalComponentParam);
        this.rateLimiterClientProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_rateLimiterClient(universalComponentParam);
        this.appForegroundRateLimitProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_appForegroundRateLimit(universalComponentParam);
        this.providesSharedPreferencesUtilsProvider = ApiClientModule_ProvidesSharedPreferencesUtilsFactory.create(apiClientModuleParam);
        this.providesTestDeviceHelperProvider = ApiClientModule_ProvidesTestDeviceHelperFactory.create(apiClientModuleParam, this.providesSharedPreferencesUtilsProvider);
        this.providesFirebaseInstallationsProvider = ApiClientModule_ProvidesFirebaseInstallationsFactory.create(apiClientModuleParam);
        this.firebaseEventsSubscriberProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_firebaseEventsSubscriber(universalComponentParam);
        this.providesDataCollectionHelperProvider = ApiClientModule_ProvidesDataCollectionHelperFactory.create(apiClientModuleParam, this.providesSharedPreferencesUtilsProvider, this.firebaseEventsSubscriberProvider);
        this.abtIntegrationHelperProvider = InstanceFactory.create(abtIntegrationHelperParam);
        this.blockingExecutorProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_blockingExecutor(universalComponentParam);
        this.inAppMessageStreamManagerProvider = DoubleCheck.provider(InAppMessageStreamManager_Factory.create(this.appForegroundEventFlowableProvider, this.programmaticContextualTriggerFlowableProvider, this.campaignCacheClientProvider, this.clockProvider, this.providesApiClientProvider, this.analyticsEventsManagerProvider, this.schedulersProvider, this.impressionStorageClientProvider, this.rateLimiterClientProvider, this.appForegroundRateLimitProvider, this.providesTestDeviceHelperProvider, this.providesFirebaseInstallationsProvider, this.providesDataCollectionHelperProvider, this.abtIntegrationHelperProvider, this.blockingExecutorProvider));
        this.programmaticContextualTriggersProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_programmaticContextualTriggers(universalComponentParam);
        this.providesFirebaseAppProvider = ApiClientModule_ProvidesFirebaseAppFactory.create(apiClientModuleParam);
        this.transportFactoryProvider = InstanceFactory.create(transportFactoryParam);
        this.analyticsConnectorProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_analyticsConnector(universalComponentParam);
        this.developerListenerManagerProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_developerListenerManager(universalComponentParam);
        this.providesMetricsLoggerClientProvider = DoubleCheck.provider(TransportClientModule_ProvidesMetricsLoggerClientFactory.create(this.providesFirebaseAppProvider, this.transportFactoryProvider, this.analyticsConnectorProvider, this.providesFirebaseInstallationsProvider, this.clockProvider, this.developerListenerManagerProvider, this.blockingExecutorProvider));
        this.displayCallbacksFactoryProvider = DisplayCallbacksFactory_Factory.create(this.impressionStorageClientProvider, this.clockProvider, this.schedulersProvider, this.rateLimiterClientProvider, this.campaignCacheClientProvider, this.appForegroundRateLimitProvider, this.providesMetricsLoggerClientProvider, this.providesDataCollectionHelperProvider);
        this.lightWeightExecutorProvider = new com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_lightWeightExecutor(universalComponentParam);
        this.firebaseInAppMessagingProvider = DoubleCheck.provider(FirebaseInAppMessaging_Factory.create(this.inAppMessageStreamManagerProvider, this.programmaticContextualTriggersProvider, this.providesDataCollectionHelperProvider, this.providesFirebaseInstallationsProvider, this.displayCallbacksFactoryProvider, this.developerListenerManagerProvider, this.lightWeightExecutorProvider));
    }

    @Override
    public FirebaseInAppMessaging providesFirebaseInAppMessaging() {
        return (FirebaseInAppMessaging)this.firebaseInAppMessagingProvider.get();
    }

    @Override
    public DisplayCallbacksFactory displayCallbacksFactory() {
        return new DisplayCallbacksFactory(Preconditions.checkNotNull(this.universalComponent.impressionStorageClient(), "Cannot return null from a non-@Nullable component method"), Preconditions.checkNotNull(this.universalComponent.clock(), "Cannot return null from a non-@Nullable component method"), Preconditions.checkNotNull(this.universalComponent.schedulers(), "Cannot return null from a non-@Nullable component method"), Preconditions.checkNotNull(this.universalComponent.rateLimiterClient(), "Cannot return null from a non-@Nullable component method"), Preconditions.checkNotNull(this.universalComponent.campaignCacheClient(), "Cannot return null from a non-@Nullable component method"), Preconditions.checkNotNull(this.universalComponent.appForegroundRateLimit(), "Cannot return null from a non-@Nullable component method"), (MetricsLoggerClient)this.providesMetricsLoggerClientProvider.get(), this.getDataCollectionHelper());
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_lightWeightExecutor
    implements Provider<Executor> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_lightWeightExecutor(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public Executor get() {
            return Preconditions.checkNotNull(this.universalComponent.lightWeightExecutor(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_developerListenerManager
    implements Provider<DeveloperListenerManager> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_developerListenerManager(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public DeveloperListenerManager get() {
            return Preconditions.checkNotNull(this.universalComponent.developerListenerManager(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_analyticsConnector
    implements Provider<AnalyticsConnector> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_analyticsConnector(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public AnalyticsConnector get() {
            return Preconditions.checkNotNull(this.universalComponent.analyticsConnector(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_programmaticContextualTriggers
    implements Provider<ProgramaticContextualTriggers> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_programmaticContextualTriggers(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public ProgramaticContextualTriggers get() {
            return Preconditions.checkNotNull(this.universalComponent.programmaticContextualTriggers(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_blockingExecutor
    implements Provider<Executor> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_blockingExecutor(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public Executor get() {
            return Preconditions.checkNotNull(this.universalComponent.blockingExecutor(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_firebaseEventsSubscriber
    implements Provider<Subscriber> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_firebaseEventsSubscriber(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public Subscriber get() {
            return Preconditions.checkNotNull(this.universalComponent.firebaseEventsSubscriber(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_appForegroundRateLimit
    implements Provider<RateLimit> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_appForegroundRateLimit(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public RateLimit get() {
            return Preconditions.checkNotNull(this.universalComponent.appForegroundRateLimit(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_rateLimiterClient
    implements Provider<RateLimiterClient> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_rateLimiterClient(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public RateLimiterClient get() {
            return Preconditions.checkNotNull(this.universalComponent.rateLimiterClient(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_impressionStorageClient
    implements Provider<ImpressionStorageClient> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_impressionStorageClient(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public ImpressionStorageClient get() {
            return Preconditions.checkNotNull(this.universalComponent.impressionStorageClient(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_schedulers
    implements Provider<Schedulers> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_schedulers(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public Schedulers get() {
            return Preconditions.checkNotNull(this.universalComponent.schedulers(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_analyticsEventsManager
    implements Provider<AnalyticsEventsManager> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_analyticsEventsManager(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public AnalyticsEventsManager get() {
            return Preconditions.checkNotNull(this.universalComponent.analyticsEventsManager(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_providerInstaller
    implements Provider<ProviderInstaller> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_providerInstaller(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public ProviderInstaller get() {
            return Preconditions.checkNotNull(this.universalComponent.providerInstaller(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_application
    implements Provider<Application> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_application(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public Application get() {
            return Preconditions.checkNotNull(this.universalComponent.application(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_gRPCChannel
    implements Provider<Channel> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_gRPCChannel(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public Channel get() {
            return Preconditions.checkNotNull(this.universalComponent.gRPCChannel(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_clock
    implements Provider<Clock> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_clock(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public Clock get() {
            return Preconditions.checkNotNull(this.universalComponent.clock(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_campaignCacheClient
    implements Provider<CampaignCacheClient> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_campaignCacheClient(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public CampaignCacheClient get() {
            return Preconditions.checkNotNull(this.universalComponent.campaignCacheClient(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_programmaticContextualTriggerFlowable
    implements Provider<ConnectableFlowable<String>> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_programmaticContextualTriggerFlowable(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public ConnectableFlowable<String> get() {
            return Preconditions.checkNotNull(this.universalComponent.programmaticContextualTriggerFlowable(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static class com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_appForegroundEventFlowable
    implements Provider<ConnectableFlowable<String>> {
        private final UniversalComponent universalComponent;

        com_google_firebase_inappmessaging_internal_injection_components_UniversalComponent_appForegroundEventFlowable(UniversalComponent universalComponent) {
            this.universalComponent = universalComponent;
        }

        public ConnectableFlowable<String> get() {
            return Preconditions.checkNotNull(this.universalComponent.appForegroundEventFlowable(), "Cannot return null from a non-@Nullable component method");
        }
    }

    private static final class Builder
    implements AppComponent.Builder {
        private AbtIntegrationHelper abtIntegrationHelper;
        private ApiClientModule apiClientModule;
        private GrpcClientModule grpcClientModule;
        private UniversalComponent universalComponent;
        private TransportFactory transportFactory;

        private Builder() {
        }

        @Override
        public Builder abtIntegrationHelper(AbtIntegrationHelper integrationHelper) {
            this.abtIntegrationHelper = Preconditions.checkNotNull(integrationHelper);
            return this;
        }

        @Override
        public Builder apiClientModule(ApiClientModule module) {
            this.apiClientModule = Preconditions.checkNotNull(module);
            return this;
        }

        @Override
        public Builder grpcClientModule(GrpcClientModule module) {
            this.grpcClientModule = Preconditions.checkNotNull(module);
            return this;
        }

        @Override
        public Builder universalComponent(UniversalComponent component) {
            this.universalComponent = Preconditions.checkNotNull(component);
            return this;
        }

        @Override
        public Builder transportFactory(TransportFactory transportFactory) {
            this.transportFactory = Preconditions.checkNotNull(transportFactory);
            return this;
        }

        @Override
        public AppComponent build() {
            Preconditions.checkBuilderRequirement(this.abtIntegrationHelper, AbtIntegrationHelper.class);
            Preconditions.checkBuilderRequirement(this.apiClientModule, ApiClientModule.class);
            Preconditions.checkBuilderRequirement(this.grpcClientModule, GrpcClientModule.class);
            Preconditions.checkBuilderRequirement(this.universalComponent, UniversalComponent.class);
            Preconditions.checkBuilderRequirement(this.transportFactory, TransportFactory.class);
            return new DaggerAppComponent(this.apiClientModule, this.grpcClientModule, this.universalComponent, this.abtIntegrationHelper, this.transportFactory);
        }
    }
}

