/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.annotations.DeferredApi;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface AnalyticsConnector {
    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String var1);

    @Nullable
    @DeferredApi
    @KeepForSdk
    public AnalyticsConnectorHandle registerAnalyticsConnectorListener(@NonNull String var1, @NonNull AnalyticsConnectorListener var2);

    @WorkerThread
    @KeepForSdk
    @NonNull
    public List<ConditionalUserProperty> getConditionalUserProperties(@NonNull String var1, @Nullable @Size(min=1L, max=23L) String var2);

    @WorkerThread
    @KeepForSdk
    @NonNull
    public Map<String, Object> getUserProperties(boolean var1);

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String var1, @Nullable String var2, @Nullable Bundle var3);

    @KeepForSdk
    public void logEvent(@NonNull String var1, @NonNull String var2, @Nullable Bundle var3);

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty var1);

    @KeepForSdk
    public void setUserProperty(@NonNull String var1, @NonNull String var2, @NonNull Object var3);

    @KeepForSdk
    public static class ConditionalUserProperty {
        @KeepForSdk
        @NonNull
        public String origin;
        @KeepForSdk
        @NonNull
        public String name;
        @Nullable
        @KeepForSdk
        public Object value;
        @Nullable
        @KeepForSdk
        public String triggerEventName;
        @KeepForSdk
        public long triggerTimeout;
        @Nullable
        @KeepForSdk
        public String timedOutEventName;
        @Nullable
        @KeepForSdk
        public Bundle timedOutEventParams;
        @Nullable
        @KeepForSdk
        public String triggeredEventName;
        @Nullable
        @KeepForSdk
        public Bundle triggeredEventParams;
        @KeepForSdk
        public long timeToLive;
        @Nullable
        @KeepForSdk
        public String expiredEventName;
        @Nullable
        @KeepForSdk
        public Bundle expiredEventParams;
        @KeepForSdk
        public long creationTimestamp;
        @KeepForSdk
        public boolean active;
        @KeepForSdk
        public long triggeredTimestamp;
    }

    @KeepForSdk
    public static interface AnalyticsConnectorHandle {
        @KeepForSdk
        public void registerEventNames(@NonNull Set<String> var1);

        @KeepForSdk
        public void unregister();

        @KeepForSdk
        public void unregisterEventNames();
    }

    @KeepForSdk
    public static interface AnalyticsConnectorListener {
        @KeepForSdk
        public void onMessageTriggered(int var1, @Nullable Bundle var2);
    }
}

