/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.firebase.iid.zzb;
import com.google.firebase.iid.zzk;
import com.google.firebase.iid.zzz;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zzd;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;

public class FirebaseMessagingService
extends zzb {
    private static final Queue<String> zzb = new ArrayDeque<String>(10);

    public FirebaseMessagingService() {
    }

    @WorkerThread
    public void onMessageReceived(RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(String string2) {
    }

    @WorkerThread
    public void onSendError(String string2, Exception exception) {
    }

    @Hide
    protected final Intent zza(Intent intent) {
        return zzz.zza().zzb();
    }

    @Hide
    public final boolean zzb(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            Intent intent2 = intent;
            FirebaseMessagingService firebaseMessagingService = this;
            PendingIntent pendingIntent = (PendingIntent)intent2.getParcelableExtra("pending_intent");
            if (pendingIntent != null) {
                try {
                    pendingIntent.send();
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
                }
            }
            if (FirebaseMessagingService.zzb(intent2.getExtras())) {
                zzd.zzb((Context)firebaseMessagingService, intent2);
            }
            return true;
        }
        return false;
    }

    @Hide
    public final void zzc(Intent intent) {
        String string2 = intent.getAction();
        if (string2 == null) {
            string2 = "";
        }
        switch (string2) {
            case "com.google.android.c2dm.intent.RECEIVE": {
                String string3;
                Object object;
                boolean bl;
                Intent intent2 = intent;
                FirebaseMessagingService firebaseMessagingService = this;
                String string4 = intent2.getStringExtra("google.message_id");
                Object object2 = string4;
                if (TextUtils.isEmpty((CharSequence)string4)) {
                    bl = false;
                } else if (zzb.contains(object2)) {
                    if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                        String string5 = String.valueOf(object2);
                        Log.d((String)"FirebaseMessaging", (String)(string5.length() != 0 ? "Received duplicate message: ".concat(string5) : new String("Received duplicate message: ")));
                    }
                    bl = true;
                } else {
                    if (zzb.size() >= 10) {
                        zzb.remove();
                    }
                    zzb.add((String)object2);
                    bl = false;
                }
                if (!bl) {
                    object = intent2;
                    object2 = firebaseMessagingService;
                    string3 = object.getStringExtra("message_type");
                    if (string3 == null) {
                        string3 = "gcm";
                    }
                    switch (string3) {
                        case "gcm": {
                            if (FirebaseMessagingService.zzb(object.getExtras())) {
                                zzd.zza((Context)object2, object);
                            }
                            Object object3 = object;
                            Object object4 = object2;
                            Bundle bundle = object3.getExtras();
                            if (bundle == null) {
                                bundle = new Bundle();
                            }
                            bundle.remove("android.support.content.wakelockid");
                            if (zza.zza(bundle)) {
                                if (zza.zza((Context)object4).zzc(bundle)) break;
                                if (FirebaseMessagingService.zzb(bundle)) {
                                    zzd.zzd((Context)object4, object3);
                                }
                            }
                            ((FirebaseMessagingService)((Object)object4)).onMessageReceived(new RemoteMessage(bundle));
                            break;
                        }
                        case "deleted_messages": {
                            ((FirebaseMessagingService)((Object)object2)).onDeletedMessages();
                            break;
                        }
                        case "send_event": {
                            ((FirebaseMessagingService)((Object)object2)).onMessageSent(object.getStringExtra("google.message_id"));
                            break;
                        }
                        case "send_error": {
                            Object object5 = object;
                            String string6 = object5.getStringExtra("google.message_id");
                            if (string6 == null) {
                                string6 = object5.getStringExtra("message_id");
                            }
                            ((FirebaseMessagingService)((Object)object2)).onSendError(string6, new SendException(object.getStringExtra("error")));
                            break;
                        }
                        default: {
                            String string7 = String.valueOf(string3);
                            Log.w((String)"FirebaseMessaging", (String)(string7.length() != 0 ? "Received message with unknown type: ".concat(string7) : new String("Received message with unknown type: ")));
                        }
                    }
                }
                object = string4;
                object2 = firebaseMessagingService;
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    string3 = new Bundle();
                    string3.putString("google.message_id", (String)object);
                    zzk.zza((Context)object2).zza(2, (Bundle)string3);
                }
                return;
            }
            case "com.google.firebase.messaging.NOTIFICATION_DISMISS": {
                if (!FirebaseMessagingService.zzb(intent.getExtras())) break;
                zzd.zzc((Context)this, intent);
                return;
            }
            default: {
                String string8 = String.valueOf(intent.getAction());
                Log.d((String)"FirebaseMessaging", (String)(string8.length() != 0 ? "Unknown intent action: ".concat(string8) : new String("Unknown intent action: ")));
            }
        }
    }

    static void zza(Bundle bundle) {
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null || !string2.startsWith("google.c.")) continue;
            iterator.remove();
        }
    }

    static boolean zzb(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return "1".equals(bundle.getString("google.c.a.e"));
    }
}

