/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.GuardedBy;
import com.google.firebase.iid.zzao;
import com.google.firebase.messaging.zzd;
import com.google.firebase.messaging.zzu;
import com.google.firebase.messaging.zzw;
import java.io.IOException;

final class zzx
implements Runnable {
    private final Context zza;
    private final zzao zzb;
    private final PowerManager.WakeLock zzc;
    private final zzu zzd;
    private final long zze;
    private static final Object zzf = new Object();
    @GuardedBy(value="TOPIC_SYNC_TASK_LOCK")
    private static Boolean zzg = null;
    @GuardedBy(value="TOPIC_SYNC_TASK_LOCK")
    private static Boolean zzh = null;

    zzx(zzu zzu2, Context context, zzao zzao2, long l) {
        this.zzd = zzu2;
        this.zza = context;
        this.zze = l;
        this.zzb = zzao2;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.zzc = powerManager.newWakeLock(1, "wake:com.google.firebase.messaging");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressLint(value={"Wakelock"})
    public final void run() {
        block21: {
            block20: {
                block19: {
                    if (zzx.zza(this.zza)) {
                        this.zzc.acquire(com.google.firebase.messaging.zzd.zza);
                    }
                    this.zzd.zza(true);
                    if (this.zzb.zza()) break block19;
                    this.zzd.zza(false);
                    if (!zzx.zza(this.zza)) return;
                    try {
                        this.zzc.release();
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
                    }
                    return;
                }
                if (!zzx.zzb(this.zza) || this.zzb()) break block20;
                zzw zzw2 = new zzw(this, this);
                if (Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                    Log.d((String)"FirebaseMessaging", (String)"Connectivity change received registered");
                }
                zzw2.zza.zza.registerReceiver((BroadcastReceiver)zzw2, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                if (!zzx.zza(this.zza)) return;
                try {
                    this.zzc.release();
                    return;
                }
                catch (RuntimeException runtimeException) {
                    Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
                }
                return;
            }
            if (this.zzd.zzb()) {
                this.zzd.zza(false);
                break block21;
            }
            this.zzd.zza(this.zze);
        }
        if (!zzx.zza(this.zza)) return;
        try {
            this.zzc.release();
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
            return;
        }
        catch (IOException iOException) {
            try {
                String string = String.valueOf(iOException.getMessage());
                Log.e((String)"FirebaseMessaging", (String)(string.length() != 0 ? "Failed to sync topics. Won't retry sync. ".concat(string) : new String("Failed to sync topics. Won't retry sync. ")));
                this.zzd.zza(false);
            }
            catch (Throwable throwable) {
                if (!zzx.zza(this.zza)) throw throwable;
                try {
                    this.zzc.release();
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
                }
                throw throwable;
            }
            if (!zzx.zza(this.zza)) return;
            try {
                this.zzc.release();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.i((String)"FirebaseMessaging", (String)"TopicsSyncTask's wakelock was already released due to timeout.");
                return;
            }
        }
    }

    private final synchronized boolean zzb() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zza.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        return networkInfo != null && networkInfo.isConnected();
    }

    private static boolean zzc() {
        return Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zza(Context context) {
        Object object = zzf;
        synchronized (object) {
            zzg = zzg == null ? zzx.zza(context, "android.permission.WAKE_LOCK", zzg) : zzg;
            return zzg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean zzb(Context context) {
        Object object = zzf;
        synchronized (object) {
            zzh = zzh == null ? zzx.zza(context, "android.permission.ACCESS_NETWORK_STATE", zzh) : zzh;
            return zzh;
        }
    }

    private static boolean zza(Context context, String string, Boolean bl) {
        if (bl != null) {
            return bl;
        }
        boolean bl2 = context.checkCallingOrSelfPermission(string) == 0;
        if (!bl2 && Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            String string2 = string;
            Log.d((String)"FirebaseMessaging", (String)new StringBuilder(142 + String.valueOf(string2).length()).append("Missing Permission: ").append(string2).append(". This permission should normally be included by the manifest merger, but may needed to be manually added to your manifest").toString());
        }
        return bl2;
    }

    static /* synthetic */ boolean zza(zzx zzx2) {
        return zzx2.zzb();
    }

    static /* synthetic */ boolean zza() {
        return zzx.zzc();
    }

    static /* synthetic */ zzu zzb(zzx zzx2) {
        return zzx2.zzd;
    }
}

