/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Transport;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.MessengerIpcClient;
import com.google.firebase.iid.ServiceStarter;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.zzc;
import com.google.firebase.messaging.zzf;
import com.google.firebase.messaging.zzo;
import com.google.firebase.messaging.zzr;
import com.google.firebase.messaging.zzs;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FirebaseMessagingService
extends zzf {
    private static final Queue<String> zza = new ArrayDeque<String>(10);

    @WorkerThread
    public void onMessageReceived(@NonNull RemoteMessage remoteMessage) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @WorkerThread
    public void onMessageSent(@NonNull String string) {
    }

    @WorkerThread
    public void onSendError(@NonNull String string, @NonNull Exception exception) {
    }

    @WorkerThread
    public void onNewToken(@NonNull String string) {
    }

    @Override
    protected final Intent zza(Intent intent) {
        return ServiceStarter.getInstance().getMessagingEvent();
    }

    @Override
    public final boolean zzb(Intent intent) {
        if ("com.google.firebase.messaging.NOTIFICATION_OPEN".equals(intent.getAction())) {
            Intent intent2 = intent;
            PendingIntent pendingIntent = (PendingIntent)intent2.getParcelableExtra("pending_intent");
            if (pendingIntent != null) {
                try {
                    pendingIntent.send();
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.e((String)"FirebaseMessaging", (String)"Notification pending intent canceled");
                }
            }
            if (zzs.zzd(intent2)) {
                zzs.zza(intent2);
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final void zzc(Intent var1_1) {
        block38: {
            block39: {
                var2_2 = var1_1.getAction();
                if (!"com.google.android.c2dm.intent.RECEIVE".equals(var2_2) && !"com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(var2_2)) break block38;
                var4_3 = var1_1;
                var3_4 = this;
                var10_6 = var5_5 = var4_3.getStringExtra("google.message_id");
                var9_7 = var3_4;
                if (TextUtils.isEmpty((CharSequence)var10_6)) {
                    v0 = Tasks.forResult(null);
                } else {
                    var11_8 /* !! */  = new Bundle();
                    var11_8 /* !! */ .putString("google.message_id", var10_6);
                    v0 = MessengerIpcClient.getInstance((Context)var9_7).sendOneWayRequest(2, var11_8 /* !! */ );
                }
                var6_9 = v0;
                var9_7 = var5_5;
                if (TextUtils.isEmpty((CharSequence)var9_7)) {
                    v1 = false;
                } else if (FirebaseMessagingService.zza.contains(var9_7)) {
                    if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                        v2 = String.valueOf(var9_7);
                        Log.d((String)"FirebaseMessaging", (String)(v2.length() != 0 ? "Received duplicate message: ".concat(v2) : new String("Received duplicate message: ")));
                    }
                    v1 = true;
                } else {
                    if (FirebaseMessagingService.zza.size() >= 10) {
                        FirebaseMessagingService.zza.remove();
                    }
                    FirebaseMessagingService.zza.add((String)var9_7);
                    v1 = false;
                }
                if (v1) break block39;
                var10_6 = var4_3;
                var9_7 = var3_4;
                var11_8 /* !! */  = var10_6.getStringExtra("message_type");
                if (var11_8 /* !! */  == null) {
                    var11_8 /* !! */  = "gcm";
                }
                var12_10 = var11_8 /* !! */ ;
                var13_11 = -1;
                switch (var12_10.hashCode()) {
                    case 102161: {
                        if (!var12_10.equals("gcm")) break;
                        var13_11 = 0;
                        break;
                    }
                    case -2062414158: {
                        if (!var12_10.equals("deleted_messages")) break;
                        var13_11 = 1;
                        break;
                    }
                    case 814800675: {
                        if (!var12_10.equals("send_event")) break;
                        var13_11 = 2;
                        break;
                    }
                    case 814694033: {
                        if (!var12_10.equals("send_error")) break;
                        var13_11 = 3;
                    }
                }
                switch (var13_11) {
                    case 0: {
                        if (zzs.zzd((Intent)var10_6)) {
                            zzs.zza((Intent)var10_6, null);
                        }
                        if (zzs.zze((Intent)var10_6)) {
                            var14_12 = FirebaseMessaging.zza;
                            if (var14_12 != null) {
                                var15_13 = var14_12.getTransport("FCM_CLIENT_EVENT_LOGGING", String.class, Encoding.of((String)"json"), zzo.zza);
                                zzs.zza((Intent)var10_6, (Transport<String>)var15_13);
                            } else {
                                Log.e((String)"FirebaseMessaging", (String)"TransportFactory is null. Skip exporting message delivery metrics to Big Query");
                            }
                        }
                        var19_14 = var10_6;
                        var18_15 = var9_7;
                        var20_16 = var19_14.getExtras();
                        if (var20_16 == null) {
                            var20_16 = new Bundle();
                        }
                        var20_16.remove("androidx.content.wakelockid");
                        if (!zzr.zza(var20_16)) ** GOTO lbl86
                        var21_17 = new zzr(var20_16);
                        var22_18 = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("Firebase-Messaging-Network-Io"));
                        var23_19 = new zzc((Context)var18_15, var21_17, var22_18);
                        try {
                            if (var23_19.zza()) {
                                break;
                            }
                        }
                        finally {
                            var22_18.shutdown();
                        }
                        if (zzs.zzd((Intent)var19_14)) {
                            zzs.zzc((Intent)var19_14);
                        }
lbl86:
                        // 4 sources

                        var18_15.onMessageReceived(new RemoteMessage(var20_16));
                        break;
                    }
                    case 1: {
                        var9_7.onDeletedMessages();
                        break;
                    }
                    case 2: {
                        var9_7.onMessageSent(var10_6.getStringExtra("google.message_id"));
                        break;
                    }
                    case 3: {
                        var16_21 = var10_6;
                        var17_22 = var16_21.getStringExtra("google.message_id");
                        if (var17_22 == null) {
                            var17_22 = var16_21.getStringExtra("message_id");
                        }
                        var9_7.onSendError(var17_22, new SendException(var10_6.getStringExtra("error")));
                        break;
                    }
                    default: {
                        v3 = String.valueOf(var11_8 /* !! */ );
                        Log.w((String)"FirebaseMessaging", (String)(v3.length() != 0 ? "Received message with unknown type: ".concat(v3) : new String("Received message with unknown type: ")));
                    }
                }
            }
            try {
                Tasks.await((Task)var6_9, (long)TimeUnit.SECONDS.toMillis(1L), (TimeUnit)TimeUnit.MILLISECONDS);
                return;
            }
            catch (InterruptedException | ExecutionException | TimeoutException var7_23) {
                var8_24 = String.valueOf(var7_23);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(20 + String.valueOf(var8_24).length()).append("Message ack failed: ").append(var8_24).toString());
                return;
            }
        }
        if ("com.google.firebase.messaging.NOTIFICATION_DISMISS".equals(var2_2)) {
            if (zzs.zzd(var1_1)) {
                zzs.zzb(var1_1);
                return;
            }
        } else {
            if ("com.google.firebase.messaging.NEW_TOKEN".equals(var2_2)) {
                this.onNewToken(var1_1.getStringExtra("token"));
                return;
            }
            v4 = String.valueOf(var1_1.getAction());
            Log.d((String)"FirebaseMessaging", (String)(v4.length() != 0 ? "Unknown intent action: ".concat(v4) : new String("Unknown intent action: ")));
        }
    }
}

