/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.GmsRpc;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.Metadata;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.zzaa;
import com.google.firebase.messaging.zzab;
import com.google.firebase.messaging.zzw;
import com.google.firebase.messaging.zzz;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class zzy {
    private static final long zza = TimeUnit.HOURS.toSeconds(8L);
    private final FirebaseInstanceId zzb;
    private final Context zzc;
    private final Metadata zzd;
    private final GmsRpc zze;
    @GuardedBy(value="pendingOperations")
    private final Map<String, ArrayDeque<TaskCompletionSource<Void>>> zzf = new ArrayMap();
    private final ScheduledExecutorService zzg;
    @GuardedBy(value="this")
    private boolean zzh = false;
    private final zzz zzi;

    static Task<zzy> zza(FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, Metadata metadata, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi, Context context, @NonNull ScheduledExecutorService scheduledExecutorService) {
        ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService;
        Context context2 = context;
        GmsRpc gmsRpc = new GmsRpc(firebaseApp, metadata, userAgentPublisher, heartBeatInfo, firebaseInstallationsApi);
        Metadata metadata2 = metadata;
        FirebaseInstanceId firebaseInstanceId2 = firebaseInstanceId;
        return Tasks.call((Executor)scheduledExecutorService2, (Callable)new zzab(context2, scheduledExecutorService2, firebaseInstanceId2, metadata2, gmsRpc));
    }

    private zzy(FirebaseInstanceId firebaseInstanceId, Metadata metadata, zzz zzz2, GmsRpc gmsRpc, Context context, @NonNull ScheduledExecutorService scheduledExecutorService) {
        this.zzb = firebaseInstanceId;
        this.zzd = metadata;
        this.zzi = zzz2;
        this.zze = gmsRpc;
        this.zzc = context;
        this.zzg = scheduledExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    final Task<Void> zza(zzw zzw2) {
        TaskCompletionSource taskCompletionSource;
        this.zzi.zza(zzw2);
        TaskCompletionSource taskCompletionSource2 = taskCompletionSource = new TaskCompletionSource();
        zzw zzw3 = zzw2;
        zzy zzy2 = this;
        Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = zzy2.zzf;
        synchronized (map) {
            ArrayDeque<Object> arrayDeque;
            String string = zzw3.zzc();
            if (zzy2.zzf.containsKey(string)) {
                arrayDeque = zzy2.zzf.get(string);
            } else {
                arrayDeque = new ArrayDeque();
                zzy2.zzf.put(string, arrayDeque);
            }
            arrayDeque.add(taskCompletionSource2);
        }
        return taskCompletionSource.getTask();
    }

    final void zza() {
        zzy zzy2;
        if (this.zzi.zza() != null && !(zzy2 = this).zzc()) {
            zzy2.zza(0L);
        }
    }

    final void zza(long l) {
        long l2 = Math.min(Math.max(30L, l << 1), zza);
        zzaa zzaa2 = new zzaa(this, this.zzc, this.zzd, l2);
        this.zza(zzaa2, l);
        this.zza(true);
    }

    final void zza(Runnable runnable, long l) {
        this.zzg.schedule(runnable, l, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    final boolean zzb() throws IOException {
        while (true) {
            zzw zzw2;
            zzy zzy2 = this;
            synchronized (zzy2) {
                zzw2 = this.zzi.zza();
                if (zzw2 == null) {
                    if (zzy.zzd()) {
                        Log.d((String)"FirebaseMessaging", (String)"topic sync succeeded");
                    }
                    return true;
                }
            }
            if (!this.zzb(zzw2)) {
                return false;
            }
            this.zzi.zzb(zzw2);
            zzw zzw3 = zzw2;
            zzy zzy3 = this;
            Map<String, ArrayDeque<TaskCompletionSource<Void>>> map = zzy3.zzf;
            synchronized (map) {
                String string = zzw3.zzc();
                if (!zzy3.zzf.containsKey(string)) {
                    continue;
                }
                ArrayDeque<TaskCompletionSource<Void>> arrayDeque = zzy3.zzf.get(string);
                TaskCompletionSource<Void> taskCompletionSource = arrayDeque.poll();
                if (taskCompletionSource != null) {
                    taskCompletionSource.setResult(null);
                }
                if (arrayDeque.isEmpty()) {
                    zzy3.zzf.remove(string);
                }
            }
        }
    }

    @WorkerThread
    private final boolean zzb(zzw zzw2) throws IOException {
        try {
            switch (zzw2.zzb()) {
                case "S": {
                    String string = zzw2.zza();
                    zzy zzy2 = this;
                    InstanceIdResult instanceIdResult = (InstanceIdResult)zzy.zza(zzy2.zzb.getInstanceId());
                    zzy.zza(zzy2.zze.subscribeToTopic(instanceIdResult.getId(), instanceIdResult.getToken(), string));
                    if (zzy.zzd()) {
                        String string2 = zzw2.zza();
                        Log.d((String)"FirebaseMessaging", (String)new StringBuilder(31 + String.valueOf(string2).length()).append("Subscribe to topic: ").append(string2).append(" succeeded.").toString());
                    }
                    break;
                }
                case "U": {
                    String string = zzw2.zza();
                    zzy zzy3 = this;
                    InstanceIdResult instanceIdResult = (InstanceIdResult)zzy.zza(zzy3.zzb.getInstanceId());
                    zzy.zza(zzy3.zze.unsubscribeFromTopic(instanceIdResult.getId(), instanceIdResult.getToken(), string));
                    if (zzy.zzd()) {
                        String string3 = zzw2.zza();
                        Log.d((String)"FirebaseMessaging", (String)new StringBuilder(35 + String.valueOf(string3).length()).append("Unsubscribe from topic: ").append(string3).append(" succeeded.").toString());
                    }
                    break;
                }
                default: {
                    if (zzy.zzd()) {
                        String string = String.valueOf(zzw2);
                        Log.d((String)"FirebaseMessaging", (String)new StringBuilder(24 + String.valueOf(string).length()).append("Unknown topic operation").append(string).append(".").toString());
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            if ("SERVICE_NOT_AVAILABLE".equals(iOException.getMessage()) || "INTERNAL_SERVER_ERROR".equals(iOException.getMessage())) {
                String string = iOException.getMessage();
                Log.e((String)"FirebaseMessaging", (String)new StringBuilder(53 + String.valueOf(string).length()).append("Topic operation failed: ").append(string).append(". Will retry Topic operation.").toString());
                return false;
            }
            if (iOException.getMessage() == null) {
                Log.e((String)"FirebaseMessaging", (String)"Topic operation failed without exception message. Will retry Topic operation.");
                return false;
            }
            throw iOException;
        }
        return true;
    }

    @WorkerThread
    private static <T> T zza(Task<T> task) throws IOException {
        try {
            return (T)Tasks.await(task, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IOException(executionException2);
        }
        catch (InterruptedException | TimeoutException exception) {
            throw new IOException("SERVICE_NOT_AVAILABLE", exception);
        }
    }

    private final synchronized boolean zzc() {
        return this.zzh;
    }

    final synchronized void zza(boolean bl) {
        this.zzh = bl;
    }

    private static boolean zzd() {
        return Log.isLoggable((String)"FirebaseMessaging", (int)3) || Build.VERSION.SDK_INT == 23 && Log.isLoggable((String)"FirebaseMessaging", (int)3);
    }

    static final /* synthetic */ zzy zza(Context context, ScheduledExecutorService scheduledExecutorService, FirebaseInstanceId firebaseInstanceId, Metadata metadata, GmsRpc gmsRpc) throws Exception {
        zzz zzz2 = zzz.zza(context, scheduledExecutorService);
        return new zzy(firebaseInstanceId, metadata, zzz2, gmsRpc, context, scheduledExecutorService);
    }
}

