/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.Metadata;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$0;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$1;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$2;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$3;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$4;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.TopicsSubscriber;
import com.google.firebase.platforminfo.UserAgentPublisher;

public class FirebaseMessaging {
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private final Context context;
    private final FirebaseApp firebaseApp;
    private final FirebaseInstanceId iid;
    private final Task<TopicsSubscriber> topicsSubscriberTask;
    @Nullable
    @SuppressLint(value={"FirebaseUnknownNullness"})
    @VisibleForTesting
    static TransportFactory transportFactory;

    @NonNull
    public static synchronized FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    static synchronized FirebaseMessaging getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseMessaging firebaseMessaging = (FirebaseMessaging)firebaseApp.get(FirebaseMessaging.class);
        Preconditions.checkNotNull((Object)firebaseMessaging, (Object)"Firebase Messaging component is not present");
        return firebaseMessaging;
    }

    FirebaseMessaging(FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, UserAgentPublisher userAgentPublisher, HeartBeatInfo heartBeatInfo, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory) {
        FirebaseMessaging.transportFactory = transportFactory;
        this.firebaseApp = firebaseApp;
        this.iid = firebaseInstanceId;
        this.context = firebaseApp.getApplicationContext();
        this.topicsSubscriberTask = TopicsSubscriber.createInstance(firebaseApp, firebaseInstanceId, new Metadata(this.context), userAgentPublisher, heartBeatInfo, firebaseInstallationsApi, this.context, FcmExecutors.newTopicsSyncExecutor());
        this.topicsSubscriberTask.addOnSuccessListener(FcmExecutors.newTopicsSyncTriggerExecutor(), (OnSuccessListener)new FirebaseMessaging$$Lambda$0(this));
    }

    public boolean isAutoInitEnabled() {
        return this.iid.isFcmAutoInitEnabled();
    }

    public void setAutoInitEnabled(boolean bl) {
        this.iid.setFcmAutoInitEnabled(bl);
    }

    @NonNull
    public boolean deliveryMetricsExportToBigQueryEnabled() {
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    public void setDeliveryMetricsExportToBigQuery(boolean bl) {
        MessagingAnalytics.setDeliveryMetricsExportToBigQuery(bl);
    }

    @NonNull
    public Task<String> getToken() {
        return this.iid.getInstanceId().continueWith(FirebaseMessaging$$Lambda$1.$instance);
    }

    @NonNull
    public Task<Void> deleteToken() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FcmExecutors.newNetworkIOExecutor().execute(new FirebaseMessaging$$Lambda$2(this, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Void> subscribeToTopic(@NonNull String string) {
        return this.topicsSubscriberTask.onSuccessTask((SuccessContinuation)new FirebaseMessaging$$Lambda$3(string));
    }

    @NonNull
    public Task<Void> unsubscribeFromTopic(@NonNull String string) {
        return this.topicsSubscriberTask.onSuccessTask((SuccessContinuation)new FirebaseMessaging$$Lambda$4(string));
    }

    public void send(@NonNull RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent2, (int)0));
        intent.setPackage("com.google.android.gms");
        remoteMessage.populateSendMessageIntent(intent);
        this.context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    @Nullable
    public static TransportFactory getTransportFactory() {
        return transportFactory;
    }

    static final /* synthetic */ Task lambda$unsubscribeFromTopic$4$FirebaseMessaging(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.unsubscribeFromTopic(string);
    }

    static final /* synthetic */ Task lambda$subscribeToTopic$3$FirebaseMessaging(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.subscribeToTopic(string);
    }

    final /* synthetic */ void lambda$deleteToken$2$FirebaseMessaging(TaskCompletionSource taskCompletionSource) {
        try {
            this.iid.deleteToken(Metadata.getDefaultSenderId((FirebaseApp)this.firebaseApp), INSTANCE_ID_SCOPE);
            taskCompletionSource.setResult(null);
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            return;
        }
    }

    static final /* synthetic */ String lambda$getToken$1$FirebaseMessaging(Task task) throws Exception {
        return ((InstanceIdResult)task.getResult()).getToken();
    }

    final /* synthetic */ void lambda$new$0$FirebaseMessaging(TopicsSubscriber topicsSubscriber) {
        if (this.isAutoInitEnabled()) {
            topicsSubscriber.startTopicsSyncIfNecessary();
        }
    }
}

