/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_messaging.zzh;
import com.google.android.gms.internal.firebase_messaging.zzi;
import com.google.android.gms.internal.firebase_messaging.zzk;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.ImageDownload$$Lambda$0;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class ImageDownload
implements Closeable {
    private final URL url;
    @Nullable
    private Task<Bitmap> task;
    @Nullable
    private volatile InputStream connectionInputStream;

    @Nullable
    public static ImageDownload create(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return new ImageDownload(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = String.valueOf(string);
            Log.w((String)"FirebaseMessaging", (String)(string2.length() != 0 ? "Not downloading image, bad URL: ".concat(string2) : new String("Not downloading image, bad URL: ")));
            return null;
        }
    }

    private ImageDownload(URL uRL) {
        this.url = uRL;
    }

    public void start(Executor executor) {
        this.task = Tasks.call((Executor)executor, (Callable)new ImageDownload$$Lambda$0(this));
    }

    public Task<Bitmap> getTask() {
        return (Task)Preconditions.checkNotNull(this.task);
    }

    public Bitmap blockingDownload() throws IOException {
        Object object = String.valueOf(this.url);
        Log.i((String)"FirebaseMessaging", (String)new StringBuilder(22 + String.valueOf(object).length()).append("Starting download of: ").append((String)object).toString());
        byte[] byArray = this.blockingDownloadBytes();
        object = byArray;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)((Object)object).length);
        if (bitmap == null) {
            String string = String.valueOf(this.url);
            throw new IOException(new StringBuilder(24 + String.valueOf(string).length()).append("Failed to decode image: ").append(string).toString());
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            String string = String.valueOf(this.url);
            Log.d((String)"FirebaseMessaging", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Successfully downloaded image: ").append(string).toString());
        }
        return bitmap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] blockingDownloadBytes() throws IOException {
        byte[] byArray;
        block6: {
            URLConnection uRLConnection = this.url.openConnection();
            if (uRLConnection.getContentLength() > 0x100000) {
                throw new IOException("Content-Length exceeds max size of 1048576");
            }
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                this.connectionInputStream = inputStream;
                byArray = zzh.zza(zzh.zza(inputStream, 0x100001L));
                if (inputStream == null) break block6;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    zzk.zza(throwable, throwable2);
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)2)) {
            int n = byArray.length;
            String string = String.valueOf(this.url);
            Log.v((String)"FirebaseMessaging", (String)new StringBuilder(34 + String.valueOf(string).length()).append("Downloaded ").append(n).append(" bytes from ").append(string).toString());
        }
        if (byArray.length <= 0x100000) return byArray;
        throw new IOException("Image exceeds max size of 1048576");
    }

    @Override
    public void close() {
        try {
            zzi.zza(this.connectionInputStream);
            return;
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)"FirebaseMessaging", (String)"Failed to close the image download stream.", (Throwable)nullPointerException);
            return;
        }
    }
}

