/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.iid.WakeLockHolder;
import com.google.firebase.iid.WithinAppServiceBinder;
import com.google.firebase.messaging.EnhancedIntentService$$Lambda$0;
import com.google.firebase.messaging.EnhancedIntentService$$Lambda$1;
import com.google.firebase.messaging.EnhancedIntentService$$Lambda$2;
import com.google.firebase.messaging.FcmExecutors;
import java.util.concurrent.ExecutorService;

@SuppressLint(value={"UnwrappedWakefulBroadcastReceiver"})
public abstract class EnhancedIntentService
extends Service {
    @VisibleForTesting
    final ExecutorService executor = FcmExecutors.newIntentHandleExecutor();
    private Binder binder;
    private final Object lock = new Object();
    private int lastStartId;
    private int runningTasks = 0;

    public final synchronized IBinder onBind(Intent intent) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"Service received bind request");
        }
        if (this.binder == null) {
            this.binder = new WithinAppServiceBinder(new WithinAppServiceBinder.IntentHandler(){

                @KeepForSdk
                public Task<Void> handle(Intent intent) {
                    return EnhancedIntentService.this.processIntent(intent);
                }
            });
        }
        return this.binder;
    }

    @MainThread
    private Task<Void> processIntent(Intent intent) {
        if (this.handleIntentOnMainThread(intent)) {
            return Tasks.forResult(null);
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.executor.execute(new EnhancedIntentService$$Lambda$0(this, intent, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int onStartCommand(Intent intent, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.lastStartId = n2;
            ++this.runningTasks;
        }
        object = this.getStartCommandIntent(intent);
        if (object == null) {
            this.finishTask(intent);
            return 2;
        }
        Task<Void> task = this.processIntent((Intent)object);
        if (task.isComplete()) {
            this.finishTask(intent);
            return 2;
        }
        task.addOnCompleteListener(EnhancedIntentService$$Lambda$1.$instance, (OnCompleteListener)new EnhancedIntentService$$Lambda$2(this, intent));
        return 3;
    }

    @CallSuper
    public void onDestroy() {
        this.executor.shutdown();
        super.onDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTask(Intent intent) {
        if (intent != null) {
            WakeLockHolder.completeWakefulIntent((Intent)intent);
        }
        Object object = this.lock;
        synchronized (object) {
            --this.runningTasks;
            if (this.runningTasks == 0) {
                this.stopSelfResultHook(this.lastStartId);
            }
            return;
        }
    }

    boolean stopSelfResultHook(int n) {
        return this.stopSelfResult(n);
    }

    protected Intent getStartCommandIntent(Intent intent) {
        return intent;
    }

    public boolean handleIntentOnMainThread(Intent intent) {
        return false;
    }

    public abstract void handleIntent(Intent var1);

    final /* synthetic */ void lambda$onStartCommand$1$EnhancedIntentService(Intent intent, Task task) {
        this.finishTask(intent);
    }

    final /* synthetic */ void lambda$processIntent$0$EnhancedIntentService(Intent intent, TaskCompletionSource taskCompletionSource) {
        try {
            this.handleIntent(intent);
            return;
        }
        finally {
            taskCompletionSource.setResult(null);
        }
    }
}

