/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import androidx.annotation.Keep;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transformer;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.TransportFactory;
import com.google.android.datatransport.TransportScheduleCallback;
import com.google.android.datatransport.cct.CCTDestination;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.FirebaseApp;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.FirebaseMessagingRegistrar$$Lambda$0;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.util.Arrays;
import java.util.List;

@KeepForSdk
@Keep
public class FirebaseMessagingRegistrar
implements ComponentRegistrar {
    @Keep
    public List<Component<?>> getComponents() {
        return Arrays.asList(Component.builder(FirebaseMessaging.class).add(Dependency.required(FirebaseApp.class)).add(Dependency.required(FirebaseInstanceId.class)).add(Dependency.optionalProvider(UserAgentPublisher.class)).add(Dependency.optionalProvider(HeartBeatInfo.class)).add(Dependency.optional(TransportFactory.class)).add(Dependency.required(FirebaseInstallationsApi.class)).add(Dependency.required(Subscriber.class)).factory(FirebaseMessagingRegistrar$$Lambda$0.$instance).alwaysEager().build(), LibraryVersionComponent.create((String)"fire-fcm", (String)"20.1.7_1p"));
    }

    @VisibleForTesting
    static TransportFactory determineFactory(TransportFactory transportFactory) {
        if (transportFactory == null || !CCTDestination.LEGACY_INSTANCE.getSupportedEncodings().contains(Encoding.of((String)"json"))) {
            return new DevNullTransportFactory();
        }
        return transportFactory;
    }

    static final /* synthetic */ FirebaseMessaging lambda$getComponents$0$FirebaseMessagingRegistrar(ComponentContainer componentContainer) {
        return new FirebaseMessaging((FirebaseApp)componentContainer.get(FirebaseApp.class), (FirebaseInstanceId)componentContainer.get(FirebaseInstanceId.class), (Provider<UserAgentPublisher>)componentContainer.getProvider(UserAgentPublisher.class), (Provider<HeartBeatInfo>)componentContainer.getProvider(HeartBeatInfo.class), (FirebaseInstallationsApi)componentContainer.get(FirebaseInstallationsApi.class), FirebaseMessagingRegistrar.determineFactory((TransportFactory)componentContainer.get(TransportFactory.class)), (Subscriber)componentContainer.get(Subscriber.class));
    }

    private static class DevNullTransport<T>
    implements Transport<T> {
        private DevNullTransport() {
        }

        public void send(Event<T> event) {
        }

        public void schedule(Event<T> event, TransportScheduleCallback transportScheduleCallback) {
            transportScheduleCallback.onSchedule(null);
        }
    }

    @VisibleForTesting
    public static class DevNullTransportFactory
    implements TransportFactory {
        public <T> Transport<T> getTransport(String string, Class<T> clazz, Transformer<T, byte[]> transformer) {
            return new DevNullTransport();
        }

        public <T> Transport<T> getTransport(String string, Class<T> clazz, Encoding encoding, Transformer<T, byte[]> transformer) {
            return new DevNullTransport();
        }
    }
}

