/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.util.Log;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.messaging.ProxyNotificationPreferences;
import java.util.concurrent.Executor;

final class ProxyNotificationInitializer {
    private static final String MANIFEST_METADATA_NOTIFICATION_DELEGATION_ENABLED = "firebase_messaging_notification_delegation_enabled";

    private ProxyNotificationInitializer() {
    }

    @TargetApi(value=29)
    static Task<Void> setEnableProxyNotification(Executor executor, Context context, boolean enabled) {
        if (!PlatformVersion.isAtLeastQ()) {
            return Tasks.forResult(null);
        }
        TaskCompletionSource completionSource = new TaskCompletionSource();
        executor.execute(() -> {
            try {
                if (!ProxyNotificationInitializer.allowedToUse(context)) {
                    Log.e((String)"FirebaseMessaging", (String)("error configuring notification delegate for package " + context.getPackageName()));
                    return;
                }
                ProxyNotificationPreferences.setProxyNotificationsInitialized(context, true);
                NotificationManager nm = (NotificationManager)context.getSystemService(NotificationManager.class);
                if (enabled) {
                    nm.setNotificationDelegate("com.google.android.gms");
                } else if ("com.google.android.gms".equals(nm.getNotificationDelegate())) {
                    nm.setNotificationDelegate(null);
                }
            }
            finally {
                completionSource.trySetResult(null);
            }
        });
        return completionSource.getTask();
    }

    static boolean isProxyNotificationEnabled(Context context) {
        if (!PlatformVersion.isAtLeastQ()) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"Platform doesn't support proxying.");
            }
            return false;
        }
        if (!ProxyNotificationInitializer.allowedToUse(context)) {
            Log.e((String)"FirebaseMessaging", (String)("error retrieving notification delegate for package " + context.getPackageName()));
            return false;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
        String delegatePkg = notificationManager.getNotificationDelegate();
        if ("com.google.android.gms".equals(delegatePkg)) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"GMS core is set for proxying");
            }
            return true;
        }
        return false;
    }

    private static boolean shouldEnableProxyNotification(Context context) {
        try {
            ApplicationInfo applicationInfo;
            Context applicationContext = context.getApplicationContext();
            PackageManager packageManager = applicationContext.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(applicationContext.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(MANIFEST_METADATA_NOTIFICATION_DELEGATION_ENABLED)) {
                return applicationInfo.metaData.getBoolean(MANIFEST_METADATA_NOTIFICATION_DELEGATION_ENABLED);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return true;
    }

    @WorkerThread
    static void initialize(Context context) {
        if (ProxyNotificationPreferences.isProxyNotificationInitialized(context)) {
            return;
        }
        ProxyNotificationInitializer.setEnableProxyNotification(Runnable::run, context, ProxyNotificationInitializer.shouldEnableProxyNotification(context));
    }

    private static boolean allowedToUse(Context context) {
        return Binder.getCallingUid() == context.getApplicationInfo().uid;
    }
}

