/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

class Store {
    private static final String STORE_KEY_TOKEN = "|T|";
    private static final String SCOPE_ALL = "*";
    static final String PREFERENCES = "com.google.android.gms.appid";
    static final String NO_BACKUP_FILE = "com.google.android.gms.appid-no-backup";
    final SharedPreferences store;

    public Store(Context context) {
        this.store = context.getSharedPreferences(PREFERENCES, 0);
        this.checkForRestore(context, NO_BACKUP_FILE);
    }

    private void checkForRestore(Context context, String fileName) {
        block4: {
            File dir = ContextCompat.getNoBackupFilesDir((Context)context);
            File file = new File(dir, fileName);
            if (file.exists()) {
                return;
            }
            try {
                if (file.createNewFile() && !this.isEmpty()) {
                    Log.i((String)"FirebaseMessaging", (String)"App restored, clearing state");
                    this.deleteAll();
                }
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)"FirebaseMessaging", (int)3)) break block4;
                Log.d((String)"FirebaseMessaging", (String)("Error creating file in no backup dir: " + e.getMessage()));
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.store.getAll().isEmpty();
    }

    private String createTokenKey(String subtype, String audience) {
        return subtype + STORE_KEY_TOKEN + audience + "|" + SCOPE_ALL;
    }

    public synchronized void deleteAll() {
        this.store.edit().clear().commit();
    }

    public synchronized Token getToken(String subtype, String audience) {
        return Token.parse(this.store.getString(this.createTokenKey(subtype, audience), null));
    }

    public synchronized void saveToken(String subtype, String audience, String token, String appVersion) {
        String encodedToken = Token.encode(token, appVersion, System.currentTimeMillis());
        if (encodedToken == null) {
            return;
        }
        SharedPreferences.Editor edit = this.store.edit();
        edit.putString(this.createTokenKey(subtype, audience), encodedToken);
        edit.commit();
    }

    public synchronized void deleteToken(String subtype, String audience) {
        String key = this.createTokenKey(subtype, audience);
        SharedPreferences.Editor edit = this.store.edit();
        edit.remove(key);
        edit.commit();
    }

    static class Token {
        private static final String KEY_TOKEN = "token";
        private static final String KEY_APP_VERSION = "appVersion";
        private static final String KEY_TIMESTAMP = "timestamp";
        private static final long REFRESH_PERIOD_MILLIS = TimeUnit.DAYS.toMillis(7L);
        final String token;
        final String appVersion;
        final long timestamp;

        private Token(String token, String appVersion, long timestamp) {
            this.token = token;
            this.appVersion = appVersion;
            this.timestamp = timestamp;
        }

        static Token parse(String s) {
            if (TextUtils.isEmpty((CharSequence)s)) {
                return null;
            }
            if (s.startsWith("{")) {
                try {
                    JSONObject json = new JSONObject(s);
                    return new Token(json.getString(KEY_TOKEN), json.getString(KEY_APP_VERSION), json.getLong(KEY_TIMESTAMP));
                }
                catch (JSONException e) {
                    Log.w((String)"FirebaseMessaging", (String)("Failed to parse token: " + (Object)((Object)e)));
                    return null;
                }
            }
            return new Token(s, null, 0L);
        }

        static String encode(String token, String appVersion, long timestamp) {
            try {
                JSONObject json = new JSONObject();
                json.put(KEY_TOKEN, (Object)token);
                json.put(KEY_APP_VERSION, (Object)appVersion);
                json.put(KEY_TIMESTAMP, timestamp);
                return json.toString();
            }
            catch (JSONException e) {
                Log.w((String)"FirebaseMessaging", (String)("Failed to encode token: " + (Object)((Object)e)));
                return null;
            }
        }

        boolean needsRefresh(String appVersion) {
            return System.currentTimeMillis() > this.timestamp + REFRESH_PERIOD_MILLIS || !appVersion.equals(this.appVersion);
        }
    }
}

