/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import com.google.android.gms.internal.firebase_ml.zzgt;
import com.google.android.gms.internal.firebase_ml.zzgu;
import com.google.android.gms.internal.firebase_ml.zzgv;
import com.google.android.gms.internal.firebase_ml.zzhd;
import com.google.android.gms.internal.firebase_ml.zzhf;
import com.google.android.gms.internal.firebase_ml.zzio;
import com.google.android.gms.internal.firebase_ml.zzje;
import com.google.android.gms.internal.firebase_ml.zzjl;
import com.google.android.gms.internal.firebase_ml.zzmf;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public final class zzgz {
    private InputStream zzaan;
    private final String zzaao;
    private final String zzaap;
    private final zzgv zzzb;
    private zzhf zzaaq;
    private final int statusCode;
    private final String zzaam;
    private final zzgu zzaar;
    private int zzzs;
    private boolean zzzt;
    private boolean zzaas;

    zzgz(zzgu zzgu2, zzhf zzhf2) throws IOException {
        String string;
        String string2;
        this.zzaar = zzgu2;
        this.zzzs = zzgu2.zzfu();
        this.zzzt = zzgu2.zzfv();
        this.zzaaq = zzhf2;
        this.zzaao = zzhf2.getContentEncoding();
        int n = zzhf2.getStatusCode();
        this.statusCode = n < 0 ? 0 : n;
        this.zzaam = string2 = zzhf2.getReasonPhrase();
        Logger logger = zzhd.zzaav;
        boolean bl = this.zzzt && logger.isLoggable(Level.CONFIG);
        StringBuilder stringBuilder = null;
        if (bl) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("-------------- RESPONSE --------------").append(zzjl.zzafu);
            string = zzhf2.zzgi();
            if (string != null) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append(this.statusCode);
                if (string2 != null) {
                    stringBuilder.append(' ').append(string2);
                }
            }
            stringBuilder.append(zzjl.zzafu);
        }
        zzgu2.zzfx().zza(zzhf2, bl ? stringBuilder : null);
        string = zzhf2.getContentType();
        if (string == null) {
            string = zzgu2.zzfx().getContentType();
        }
        this.zzaap = string;
        zzgv zzgv2 = this.zzzb = string == null ? null : new zzgv(string);
        if (bl) {
            logger.logp(Level.CONFIG, "com.google.api.client.http.HttpResponse", "<init>", stringBuilder.toString());
        }
    }

    public final String getContentType() {
        return this.zzaap;
    }

    public final zzgt zzfw() {
        return this.zzaar.zzfx();
    }

    public final boolean zzgd() {
        int n = this.statusCode;
        return n >= 200 && n < 300;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getStatusMessage() {
        return this.zzaam;
    }

    public final InputStream getContent() throws IOException {
        if (!this.zzaas) {
            InputStream inputStream = this.zzaaq.getContent();
            if (inputStream != null) {
                try {
                    String string = this.zzaao;
                    if (string != null && string.contains("gzip")) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    Logger logger = zzhd.zzaav;
                    if (this.zzzt && logger.isLoggable(Level.CONFIG)) {
                        inputStream = new zzje(inputStream, logger, Level.CONFIG, this.zzzs);
                    }
                    this.zzaan = inputStream;
                }
                catch (EOFException eOFException) {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    inputStream.close();
                    throw throwable;
                }
            }
            this.zzaas = true;
        }
        return this.zzaan;
    }

    public final void ignore() throws IOException {
        InputStream inputStream = this.getContent();
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public final void disconnect() throws IOException {
        this.ignore();
        this.zzaaq.disconnect();
    }

    public final <T> T zza(Class<T> clazz) throws IOException {
        boolean bl;
        zzgz zzgz2 = this;
        int n = zzgz2.statusCode;
        if (zzgz2.zzaar.getRequestMethod().equals("HEAD") || n / 100 == 1 || n == 204 || n == 304) {
            zzgz2.ignore();
            bl = false;
        } else {
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return this.zzaar.zzfz().zza(this.getContent(), this.zzgf(), clazz);
    }

    public final String zzge() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream = this.getContent();
        if (inputStream == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
        InputStream inputStream2 = inputStream;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream4 = byteArrayOutputStream3;
            InputStream inputStream3 = inputStream2;
            zzmf.checkNotNull(inputStream3);
            zzmf.checkNotNull(byteArrayOutputStream4);
            byte[] byArray = new byte[4096];
            while ((n = inputStream3.read(byArray)) != -1) {
                ((OutputStream)byteArrayOutputStream4).write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            inputStream2.close();
            throw throwable;
        }
        inputStream2.close();
        return byteArrayOutputStream.toString(this.zzgf().name());
    }

    private final Charset zzgf() {
        if (this.zzzb == null || this.zzzb.zzgc() == null) {
            return zzio.ISO_8859_1;
        }
        return this.zzzb.zzgc();
    }
}

