/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzqb;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentContainer;
import com.google.firebase.components.Dependency;
import com.google.firebase.ml.common.internal.modeldownload.zzaa;
import com.google.firebase.ml.common.internal.modeldownload.zzn;
import com.google.firebase.ml.common.modeldownload.FirebaseRemoteModel;
import java.util.UUID;

public class zzqc {
    private static final GmsLogger zzbbo = new GmsLogger("SharedPrefManager", "");
    private final Context zzbdd;
    private final String zzbdn;
    public static final Component<?> zzbcb = Component.builder(zzqc.class).add(Dependency.required(zzpn.class)).add(Dependency.required(Context.class)).factory(zzqb.zzbbm).build();

    private zzqc(@NonNull zzpn zzpn2, @NonNull Context context) {
        this.zzbdd = context;
        this.zzbdn = zzpn2.getPersistenceKey();
    }

    public static zzqc zzb(@NonNull zzpn zzpn2) {
        return zzpn2.get(zzqc.class);
    }

    public final synchronized boolean zzny() {
        return this.getSharedPreferences().getBoolean(String.format("logging_%s_%s", "vision", this.zzbdn), true);
    }

    public final synchronized void zzar(boolean bl) {
        this.getSharedPreferences().edit().putBoolean(String.format("logging_%s_%s", "vision", this.zzbdn), bl).apply();
    }

    public final synchronized boolean zznz() {
        return this.getSharedPreferences().getBoolean(String.format("logging_%s_%s", "model", this.zzbdn), true);
    }

    public final synchronized void zzas(boolean bl) {
        this.getSharedPreferences().edit().putBoolean(String.format("logging_%s_%s", "model", this.zzbdn), bl).apply();
    }

    @Nullable
    public final synchronized Long zza(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        long l = this.getSharedPreferences().getLong(String.format("downloading_model_id_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), -1L);
        if (l < 0L) {
            return null;
        }
        return l;
    }

    public final synchronized zzn zzbv(@NonNull String string) {
        return zzqc.zzbw(this.getSharedPreferences().getString(String.format("downloading_model_type_%s", string), ""));
    }

    @Nullable
    public final synchronized String zzb(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        return this.getSharedPreferences().getString(String.format("downloading_model_hash_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), null);
    }

    @Nullable
    public final synchronized String zzc(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        return this.getSharedPreferences().getString(String.format("current_model_hash_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), null);
    }

    public final synchronized zzn zzd(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        return zzqc.zzbw(this.getSharedPreferences().getString(String.format("current_model_type_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), zzn.zzbef.name()));
    }

    @Nullable
    public final synchronized String zze(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        return this.getSharedPreferences().getString(String.format("bad_hash_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), null);
    }

    @Nullable
    public final synchronized String zzoa() {
        return this.getSharedPreferences().getString("app_version", null);
    }

    public final synchronized long zzf(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        return this.getSharedPreferences().getLong(String.format("downloading_begin_time_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), 0L);
    }

    public final synchronized long zzg(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        return this.getSharedPreferences().getLong(String.format("model_first_use_time_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), 0L);
    }

    public final synchronized void zza(@NonNull FirebaseRemoteModel firebaseRemoteModel, long l) {
        this.getSharedPreferences().edit().putLong(String.format("model_first_use_time_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), l).apply();
    }

    public final synchronized void zzh(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        String string = this.zzb(firebaseRemoteModel);
        this.getSharedPreferences().edit().remove(String.format("downloading_model_id_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist())).remove(String.format("downloading_model_hash_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist())).remove(String.format("downloading_model_type_%s", string)).remove(String.format("downloading_begin_time_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist())).remove(String.format("model_first_use_time_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist())).apply();
    }

    @WorkerThread
    public final synchronized void zzi(@NonNull FirebaseRemoteModel firebaseRemoteModel) {
        this.getSharedPreferences().edit().remove(String.format("current_model_hash_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist())).remove(String.format("current_model_type_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist())).commit();
    }

    public final synchronized void zza(@NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull String string, @NonNull zzn zzn2) {
        this.getSharedPreferences().edit().putString(String.format("current_model_hash_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), string).putString(String.format("current_model_type_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), zzn2.name()).apply();
    }

    public final synchronized void zza(long l, @NonNull zzaa zzaa2) {
        String string = zzaa2.zzou();
        String string2 = zzaa2.getModelHash();
        zzn zzn2 = zzaa2.zzov();
        this.getSharedPreferences().edit().putString(String.format("downloading_model_hash_%s_%s", this.zzbdn, string), string2).putLong(String.format("downloading_model_id_%s_%s", this.zzbdn, string), l).putString(String.format("downloading_model_type_%s", string2), zzn2.name()).putLong(String.format("downloading_begin_time_%s_%s", this.zzbdn, string), SystemClock.elapsedRealtime()).apply();
    }

    public final synchronized void zza(@NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull String string, @NonNull String string2) {
        this.getSharedPreferences().edit().putString(String.format("bad_hash_%s_%s", this.zzbdn, firebaseRemoteModel.getUniqueModelNameForPersist()), string).putString("app_version", string2).apply();
    }

    public final synchronized String zzob() {
        String string = this.getSharedPreferences().getString("ml_sdk_instance_id", null);
        if (string != null) {
            return string;
        }
        zzqc zzqc2 = this;
        String string2 = UUID.randomUUID().toString();
        zzqc2.getSharedPreferences().edit().putString("ml_sdk_instance_id", string2).apply();
        return string2;
    }

    private final SharedPreferences getSharedPreferences() {
        return this.zzbdd.getSharedPreferences("com.google.firebase.ml.internal", 0);
    }

    private static zzn zzbw(String string) {
        if (string == null) {
            return zzn.zzbef;
        }
        try {
            return zzn.zzbx(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = String.valueOf(string);
            zzbbo.e("SharedPrefManager", string2.length() != 0 ? "Invalid model type ".concat(string2) : new String("Invalid model type "));
            return zzn.zzbef;
        }
    }

    static final /* synthetic */ zzqc zze(ComponentContainer componentContainer) {
        return new zzqc((zzpn)componentContainer.get(zzpn.class), (Context)componentContainer.get(Context.class));
    }
}

