/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import com.google.android.gms.internal.firebase_ml.zzuk;
import com.google.android.gms.internal.firebase_ml.zzvy;
import com.google.android.gms.internal.firebase_ml.zzwh;
import com.google.android.gms.internal.firebase_ml.zzxs;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzuo
extends zzuk<Boolean>
implements zzwh<Boolean>,
zzxs,
RandomAccess {
    private static final zzuo zzbzc = new zzuo(new boolean[0], 0);
    private boolean[] zzbzd;
    private int size;

    zzuo() {
        this(new boolean[10], 0);
    }

    private zzuo(boolean[] blArray, int n) {
        this.zzbzd = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzsq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbzd, n2, this.zzbzd, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzuo)) {
            return super.equals(object);
        }
        zzuo zzuo2 = (zzuo)object;
        if (this.size != zzuo2.size) {
            return false;
        }
        boolean[] blArray = zzuo2.zzbzd;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzbzd[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzvy.zzaz(this.zzbzd[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzsq();
        if (this.size == this.zzbzd.length) {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbzd, 0, blArray, 0, this.size);
            this.zzbzd = blArray;
        }
        this.zzbzd[this.size++] = bl;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzsq();
        zzvy.checkNotNull(collection);
        if (!(collection instanceof zzuo)) {
            return super.addAll(collection);
        }
        zzuo zzuo2 = (zzuo)collection;
        if (zzuo2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzuo2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzuo2.size;
        if (n > this.zzbzd.length) {
            this.zzbzd = Arrays.copyOf(this.zzbzd, n);
        }
        System.arraycopy(zzuo2.zzbzd, 0, this.zzbzd, this.size, zzuo2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzsq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbzd[i])) continue;
            System.arraycopy(this.zzbzd, i + 1, this.zzbzd, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzcp(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzcq(n));
        }
    }

    private final String zzcq(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzuo zzuo2 = this;
        zzuo2.zzsq();
        zzuo2.zzcp(n);
        boolean bl3 = zzuo2.zzbzd[n];
        zzuo2.zzbzd[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzuo zzuo2 = this;
        zzuo2.zzsq();
        zzuo2.zzcp(n);
        boolean bl = zzuo2.zzbzd[n];
        if (n < zzuo2.size - 1) {
            System.arraycopy(zzuo2.zzbzd, n + 1, zzuo2.zzbzd, n, zzuo2.size - n - 1);
        }
        --zzuo2.size;
        ++zzuo2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzuo zzuo2 = this;
        zzuo2.zzsq();
        if (n < 0 || n > zzuo2.size) {
            throw new IndexOutOfBoundsException(zzuo2.zzcq(n));
        }
        if (zzuo2.size < zzuo2.zzbzd.length) {
            System.arraycopy(zzuo2.zzbzd, n, zzuo2.zzbzd, n + 1, zzuo2.size - n);
        } else {
            boolean[] blArray = new boolean[zzuo2.size * 3 / 2 + 1];
            System.arraycopy(zzuo2.zzbzd, 0, blArray, 0, n);
            System.arraycopy(zzuo2.zzbzd, n, blArray, n + 1, zzuo2.size - n);
            zzuo2.zzbzd = blArray;
        }
        zzuo2.zzbzd[n] = bl2;
        ++zzuo2.size;
        ++zzuo2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Boolean bl = (Boolean)object;
        this.addBoolean(bl);
        return true;
    }

    @Override
    public final /* synthetic */ zzwh zzcr(int n) {
        int n2 = n;
        zzuo zzuo2 = this;
        if (n2 < zzuo2.size) {
            throw new IllegalArgumentException();
        }
        return new zzuo(Arrays.copyOf(zzuo2.zzbzd, n2), zzuo2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzuo zzuo2 = this;
        zzuo2.zzcp(n);
        return zzuo2.zzbzd[n];
    }

    static {
        zzbzc.zzsp();
    }
}

