/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_ml;

import com.google.android.gms.internal.firebase_ml.zzuk;
import com.google.android.gms.internal.firebase_ml.zzvy;
import com.google.android.gms.internal.firebase_ml.zzwf;
import com.google.android.gms.internal.firebase_ml.zzwh;
import com.google.android.gms.internal.firebase_ml.zzxs;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzvz
extends zzuk<Integer>
implements zzwf,
zzxs,
RandomAccess {
    private static final zzvz zzceb = new zzvz(new int[0], 0);
    private int[] zzcec;
    private int size;

    public static zzvz zzuh() {
        return zzceb;
    }

    zzvz() {
        this(new int[10], 0);
    }

    private zzvz(int[] nArray, int n) {
        this.zzcec = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzsq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzcec, n2, this.zzcec, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzvz)) {
            return super.equals(object);
        }
        zzvz zzvz2 = (zzvz)object;
        if (this.size != zzvz2.size) {
            return false;
        }
        int[] nArray = zzvz2.zzcec;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzcec[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzcec[i];
        }
        return n;
    }

    @Override
    public final zzwf zzdn(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzvz(Arrays.copyOf(this.zzcec, n), this.size);
    }

    public final int getInt(int n) {
        this.zzcp(n);
        return this.zzcec[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzdo(int n) {
        this.zzsq();
        if (this.size == this.zzcec.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzcec, 0, nArray, 0, this.size);
            this.zzcec = nArray;
        }
        this.zzcec[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzsq();
        zzvy.checkNotNull(collection);
        if (!(collection instanceof zzvz)) {
            return super.addAll(collection);
        }
        zzvz zzvz2 = (zzvz)collection;
        if (zzvz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzvz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzvz2.size;
        if (n > this.zzcec.length) {
            this.zzcec = Arrays.copyOf(this.zzcec, n);
        }
        System.arraycopy(zzvz2.zzcec, 0, this.zzcec, this.size, zzvz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzsq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzcec[i])) continue;
            System.arraycopy(this.zzcec, i + 1, this.zzcec, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzcp(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzcq(n));
        }
    }

    private final String zzcq(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzvz zzvz2 = this;
        zzvz2.zzsq();
        zzvz2.zzcp(n);
        int n4 = zzvz2.zzcec[n];
        zzvz2.zzcec[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzvz zzvz2 = this;
        zzvz2.zzsq();
        zzvz2.zzcp(n);
        int n2 = zzvz2.zzcec[n];
        if (n < zzvz2.size - 1) {
            System.arraycopy(zzvz2.zzcec, n + 1, zzvz2.zzcec, n, zzvz2.size - n - 1);
        }
        --zzvz2.size;
        ++zzvz2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzvz zzvz2 = this;
        zzvz2.zzsq();
        if (n < 0 || n > zzvz2.size) {
            throw new IndexOutOfBoundsException(zzvz2.zzcq(n));
        }
        if (zzvz2.size < zzvz2.zzcec.length) {
            System.arraycopy(zzvz2.zzcec, n, zzvz2.zzcec, n + 1, zzvz2.size - n);
        } else {
            int[] nArray = new int[zzvz2.size * 3 / 2 + 1];
            System.arraycopy(zzvz2.zzcec, 0, nArray, 0, n);
            System.arraycopy(zzvz2.zzcec, n, nArray, n + 1, zzvz2.size - n);
            zzvz2.zzcec = nArray;
        }
        zzvz2.zzcec[n] = n3;
        ++zzvz2.size;
        ++zzvz2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Integer n = (Integer)object;
        this.zzdo(n);
        return true;
    }

    @Override
    public final /* synthetic */ zzwh zzcr(int n) {
        return this.zzdn(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzceb.zzsp();
    }
}

