/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.internal.modeldownload;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzmz;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.modeldownload.FirebaseLocalModel;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class zzf {
    private MappedByteBuffer zzbdt;
    private final Context zzbdu;
    private final FirebaseLocalModel zzbdv;

    public zzf(@NonNull Context context, @NonNull FirebaseLocalModel firebaseLocalModel) {
        this.zzbdu = context;
        this.zzbdv = firebaseLocalModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    @NonNull
    public MappedByteBuffer load() throws FirebaseMLException {
        Preconditions.checkNotNull((Object)this.zzbdu, (Object)"Context can not be null");
        Preconditions.checkNotNull((Object)this.zzbdv, (Object)"Model source can not be null");
        if (this.zzbdt != null) {
            return this.zzbdt;
        }
        if (this.zzbdv.getFilePath() != null) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.zzbdv.getFilePath(), "r");
                try {
                    FileChannel fileChannel = randomAccessFile.getChannel();
                    this.zzbdt = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                }
                catch (Throwable throwable) {
                    try {
                        randomAccessFile.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        zzmz.zza(throwable, throwable2);
                    }
                    throw throwable;
                }
                randomAccessFile.close();
                return this.zzbdt;
            }
            catch (IOException iOException) {
                String string = String.valueOf(this.zzbdv.getFilePath());
                throw new FirebaseMLException(string.length() != 0 ? "Can not open the local file: ".concat(string) : new String("Can not open the local file: "), 14, iOException);
            }
        }
        if (this.zzbdv.getAssetFilePath() == null) throw new FirebaseMLException("Can not load the model. Either filePath or assetFilePath must be set for the model.", 14);
        String string = this.zzbdv.getAssetFilePath();
        try {
            AssetFileDescriptor assetFileDescriptor = this.zzbdu.getAssets().openFd(string);
            try {
                FileChannel fileChannel = new FileInputStream(assetFileDescriptor.getFileDescriptor()).getChannel();
                long l = assetFileDescriptor.getStartOffset();
                long l2 = assetFileDescriptor.getDeclaredLength();
                this.zzbdt = fileChannel.map(FileChannel.MapMode.READ_ONLY, l, l2);
                if (assetFileDescriptor == null) return this.zzbdt;
            }
            catch (Throwable throwable) {
                if (assetFileDescriptor == null) throw throwable;
                try {
                    assetFileDescriptor.close();
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    zzmz.zza(throwable, throwable3);
                }
                throw throwable;
            }
            assetFileDescriptor.close();
            return this.zzbdt;
        }
        catch (IOException iOException) {
            throw new FirebaseMLException(new StringBuilder(186 + String.valueOf(string).length()).append("Can not load the file from asset: ").append(string).append(". Please double check your asset file name and ensure it's not compressed. See documentation for details how to use aaptOptions to skip file compression").toString(), 14, iOException);
        }
    }

    public final FirebaseLocalModel zzoc() {
        return this.zzbdv;
    }
}

