/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.internal.modeldownload;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.database.Cursor;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.LongSparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzmz;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zzpb;
import com.google.android.gms.internal.firebase_ml.zzpf;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzqc;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.internal.modeldownload.zzaa;
import com.google.firebase.ml.common.internal.modeldownload.zzad;
import com.google.firebase.ml.common.internal.modeldownload.zzg;
import com.google.firebase.ml.common.internal.modeldownload.zzn;
import com.google.firebase.ml.common.internal.modeldownload.zzw;
import com.google.firebase.ml.common.internal.modeldownload.zzx;
import com.google.firebase.ml.common.modeldownload.FirebaseModelDownloadConditions;
import com.google.firebase.ml.common.modeldownload.FirebaseRemoteModel;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

public final class zzv {
    private static final GmsLogger zzbbo = new GmsLogger("ModelDownloadManager", "");
    @GuardedBy(value="RemoteModelDownloadManager.class")
    private static final Map<String, zzv> zzbew = new HashMap<String, zzv>();
    @GuardedBy(value="this")
    private final LongSparseArray<zzx> zzbex = new LongSparseArray();
    @GuardedBy(value="this")
    private final LongSparseArray<TaskCompletionSource<Void>> zzbey = new LongSparseArray();
    private final zzpn zzbdc;
    private final DownloadManager zzbez;
    private final FirebaseRemoteModel zzbfa;
    private final zzw zzbfb;
    private final zzqc zzbcm;
    private final zzg zzbfc;
    private FirebaseModelDownloadConditions zzbfd;

    public static synchronized zzv zza(@NonNull zzpn zzpn2, @NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull zzg zzg2, @NonNull zzw zzw2) {
        String string = firebaseRemoteModel.getUniqueModelNameForPersist();
        if (!zzbew.containsKey(string)) {
            zzv zzv2 = new zzv(zzpn2, firebaseRemoteModel, zzg2, zzw2);
            zzbew.put(string, zzv2);
        }
        return zzbew.get(string);
    }

    public final void zza(@NonNull FirebaseModelDownloadConditions firebaseModelDownloadConditions) {
        Preconditions.checkNotNull((Object)firebaseModelDownloadConditions, (Object)"DownloadConditions can not be null");
        this.zzbfd = firebaseModelDownloadConditions;
    }

    private zzv(@NonNull zzpn zzpn2, @NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull zzg zzg2, @NonNull zzw zzw2) {
        this.zzbdc = zzpn2;
        this.zzbfa = firebaseRemoteModel;
        this.zzbez = (DownloadManager)zzpn2.getApplicationContext().getSystemService("download");
        if (this.zzbez == null) {
            zzbbo.d("ModelDownloadManager", "Download manager service is not available in the service.");
        }
        this.zzbfc = zzg2;
        this.zzbfb = zzw2;
        this.zzbcm = zzqc.zzb(zzpn2);
    }

    @Nullable
    final synchronized Long zzoi() {
        return this.zzbcm.zza(this.zzbfa);
    }

    @Nullable
    final synchronized String zzoj() {
        return this.zzbcm.zzb(this.zzbfa);
    }

    final synchronized void zzok() throws FirebaseMLException {
        Long l = this.zzoi();
        if (this.zzbez == null || l == null) {
            return;
        }
        String string = String.valueOf(l);
        zzbbo.d("ModelDownloadManager", new StringBuilder(44 + String.valueOf(string).length()).append("Cancel or remove existing downloading task: ").append(string).toString());
        if (this.zzbez.remove(new long[]{l}) > 0 || this.zzol() == null) {
            this.zzbfc.zza(this.zzbfa.getUniqueModelNameForPersist(), this.zzor());
            this.zzbcm.zzh(this.zzbfa);
        }
    }

    private final synchronized Long zza(@NonNull DownloadManager.Request request, @NonNull zzaa zzaa2) {
        if (this.zzbez == null) {
            return null;
        }
        long l = this.zzbez.enqueue(request);
        zzbbo.d("ModelDownloadManager", new StringBuilder(53).append("Schedule a new downloading task: ").append(l).toString());
        this.zzbcm.zza(l, zzaa2);
        this.zzbfb.zza(zznq.zzamr, false, zzaa2.zzov(), zzng.zzag.zzb.zzaus);
        return l;
    }

    @Nullable
    final synchronized Integer zzol() {
        Integer n;
        block11: {
            Cursor cursor;
            Integer n2;
            block9: {
                block10: {
                    Long l = this.zzoi();
                    if (this.zzbez == null || l == null) {
                        return null;
                    }
                    n2 = null;
                    cursor = this.zzbez.query(new DownloadManager.Query().setFilterById(new long[]{l}));
                    try {
                        if (cursor != null && cursor.moveToFirst()) {
                            n2 = cursor.getInt(cursor.getColumnIndex("status"));
                        }
                        if (n2 != null) break block9;
                        if (cursor == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (cursor != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable2) {
                                zzmz.zza(throwable, throwable2);
                            }
                        }
                        throw throwable;
                    }
                    cursor.close();
                }
                return null;
            }
            if (n2 != 2 && n2 != 4 && n2 != 1 && n2 != 8 && n2 != 16) {
                n2 = null;
            }
            n = n2;
            if (cursor == null) break block11;
            cursor.close();
        }
        return n;
    }

    @Nullable
    final synchronized ParcelFileDescriptor zzom() {
        Long l = this.zzoi();
        if (this.zzbez == null || l == null) {
            return null;
        }
        ParcelFileDescriptor parcelFileDescriptor = null;
        try {
            parcelFileDescriptor = this.zzbez.openDownloadedFile(l.longValue());
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbbo.e("ModelDownloadManager", "Downloaded file is not found");
        }
        return parcelFileDescriptor;
    }

    final synchronized void zze(@NonNull String string, @NonNull zzn zzn2) throws FirebaseMLException {
        this.zzbcm.zza(this.zzbfa, string, zzn2);
        this.zzok();
    }

    @Nullable
    @WorkerThread
    private final synchronized zzaa zzon() throws FirebaseMLException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        zzaa zzaa2;
        boolean bl4 = this.zzoq();
        if (bl4) {
            this.zzbfb.zza(zznq.zzamr, false, this.zzbcm.zzd(this.zzbfa), zzng.zzag.zzb.zzauw);
        }
        if ((zzaa2 = zzad.zza(this.zzbdc, this.zzbfa, this.zzbfb)) == null) {
            return null;
        }
        String string = zzaa.zzb(zzaa2);
        FirebaseRemoteModel firebaseRemoteModel = this.zzbfa;
        zzpn zzpn2 = this.zzbdc;
        zzqc zzqc2 = zzqc.zzb(zzpn2);
        if (string.equals(zzqc2.zze(firebaseRemoteModel)) && zzpb.zza(zzpn2.getApplicationContext()).equals(zzqc2.zzoa())) {
            zzbbo.e("ModelDownloadManager", "The model is incompatible with TFLite and the app is not upgraded, do not download");
            bl3 = false;
        } else {
            bl3 = bl2 = true;
        }
        if (!bl4) {
            this.zzbcm.zzi(this.zzbfa);
        }
        string = zzaa.zzb(zzaa2);
        firebaseRemoteModel = this.zzbfa;
        zzpn2 = this.zzbdc;
        boolean bl5 = bl = !string.equals(zzqc.zzb(zzpn2).zzc(firebaseRemoteModel));
        if (bl2 && (!bl4 || bl)) {
            return zzaa2;
        }
        if (bl4 && bl ^ bl2) {
            return null;
        }
        String string2 = this.zzbfa.getModelName();
        throw new FirebaseMLException(new StringBuilder(46 + String.valueOf(string2).length()).append("The model ").append(string2).append(" is incompatible with TFLite runtime").toString(), 100);
    }

    @Nullable
    @WorkerThread
    private final synchronized Long zza(@NonNull zzaa zzaa2, @NonNull FirebaseModelDownloadConditions firebaseModelDownloadConditions) throws FirebaseMLException {
        Preconditions.checkNotNull((Object)firebaseModelDownloadConditions, (Object)"DownloadConditions can not be null");
        String string = this.zzbcm.zzb(this.zzbfa);
        Integer n = this.zzol();
        if (string != null && string.equals(zzaa.zzb(zzaa2)) && n != null) {
            if (!zzv.zzb(this.zzol())) {
                this.zzbfb.zza(zznq.zzamr, false, this.zzor(), zzng.zzag.zzb.zzaut);
            }
            zzbbo.d("ModelDownloadManager", "New model is already in downloading, do nothing.");
            return null;
        }
        zzbbo.d("ModelDownloadManager", "Need to download a new model.");
        this.zzok();
        DownloadManager.Request request = new DownloadManager.Request(zzaa.zzc(zzaa2));
        request.setDestinationUri(null);
        if (this.zzbfc.zza(zzaa2)) {
            zzbbo.d("ModelDownloadManager", "Model update is enabled and have a previous downloaded model, use download condition");
            this.zzbfb.zza(zznq.zzamr, false, zzaa2.zzov(), zzng.zzag.zzb.zzaux);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            request.setRequiresCharging(firebaseModelDownloadConditions.isChargingRequired());
            request.setRequiresDeviceIdle(firebaseModelDownloadConditions.isDeviceIdleRequired());
        }
        if (firebaseModelDownloadConditions.isWifiRequired()) {
            request.setAllowedNetworkTypes(2);
        }
        return this.zza(request, zzaa2);
    }

    @WorkerThread
    public final boolean zzoo() throws FirebaseMLException {
        try {
            return this.zzoq() || Objects.equal((Object)this.zzol(), (Object)8);
        }
        catch (FirebaseMLException firebaseMLException) {
            throw new FirebaseMLException("Failed to check if the model is downloaded.", 13, (Throwable)((Object)firebaseMLException));
        }
    }

    @WorkerThread
    public final Task<Void> zzop() {
        this.zzbfb.zza(zznq.zzamr, false, zzn.zzbef, zzng.zzag.zzb.zzauo);
        Throwable throwable = null;
        zzaa zzaa2 = null;
        try {
            zzaa2 = this.zzon();
        }
        catch (FirebaseMLException firebaseMLException) {
            // empty catch block
        }
        try {
            Integer n = this.zzol();
            Long l = this.zzoi();
            if (this.zzoq() || zzv.zzb(n)) {
                Object object;
                if (zzaa2 != null) {
                    object = this.zza(zzaa2, this.zzbfd);
                    if (object != null) {
                        return this.zzt((long)object);
                    }
                    zzbbo.i("ModelDownloadManager", "Didn't schedule download for the updated model");
                }
                if (n != null && n == 16) {
                    object = this.zzb(l);
                    this.zzok();
                    return Tasks.forException((Exception)object);
                }
                return Tasks.forResult(null);
            }
            Integer n2 = n;
            if (n2 != null && (n2 == 4 || n2 == 2 || n2 == 1) && l != null && this.zzoj() != null) {
                this.zzbfb.zza(zznq.zzamr, false, this.zzor(), zzng.zzag.zzb.zzaut);
                return this.zzt(l);
            }
            Long l2 = zzaa2 == null ? null : this.zza(zzaa2, this.zzbfd);
            if (l2 == null) {
                return Tasks.forException((Exception)((Object)new FirebaseMLException("Failed to schedule the download task", 13, throwable)));
            }
            return this.zzt(l2);
        }
        catch (FirebaseMLException firebaseMLException) {
            return Tasks.forException((Exception)((Object)new FirebaseMLException("Failed to ensure the model is downloaded.", 13, (Throwable)((Object)firebaseMLException))));
        }
    }

    final int zza(Long l) {
        int n;
        int n2 = 0;
        Cursor cursor = this.zzbez == null || l == null ? null : this.zzbez.query(new DownloadManager.Query().setFilterById(new long[]{l}));
        if (cursor != null && cursor.moveToFirst() && (n = cursor.getColumnIndex("reason")) != -1) {
            n2 = cursor.getInt(n);
        }
        return n2;
    }

    private final boolean zzoq() throws FirebaseMLException {
        return this.zzbfc.zzb(this.zzbfa.getUniqueModelNameForPersist(), this.zzbcm.zzd(this.zzbfa));
    }

    private final zzn zzor() {
        String string = this.zzbcm.zzb(this.zzbfa);
        if (string == null) {
            return zzn.zzbef;
        }
        return this.zzbcm.zzbv(string);
    }

    private final synchronized zzx zzr(long l) {
        zzx zzx2 = (zzx)((Object)this.zzbex.get(l));
        if (zzx2 == null) {
            zzx2 = new zzx(this, l, this.zzs(l), null);
            this.zzbex.put(l, (Object)zzx2);
        }
        return zzx2;
    }

    private final synchronized TaskCompletionSource<Void> zzs(long l) {
        TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zzbey.get(l);
        if (taskCompletionSource == null) {
            taskCompletionSource = new TaskCompletionSource();
            this.zzbey.put(l, (Object)taskCompletionSource);
        }
        return taskCompletionSource;
    }

    private final FirebaseMLException zzb(Long l) {
        int n = 13;
        String string = "Model downloading failed";
        Cursor cursor = this.zzbez == null || l == null ? null : this.zzbez.query(new DownloadManager.Query().setFilterById(new long[]{l}));
        if (cursor != null && cursor.moveToFirst()) {
            int n2 = cursor.getInt(cursor.getColumnIndex("reason"));
            if (n2 == 1006) {
                string = "Model downloading failed due to insufficient space on the device.";
                n = 101;
            } else {
                string = new StringBuilder(84).append("Model downloading failed due to error code: ").append(n2).append(" from Android DownloadManager").toString();
            }
        }
        return new FirebaseMLException(string, n);
    }

    private static boolean zzb(Integer n) {
        return n != null && (n == 8 || n == 16);
    }

    private final Task<Void> zzt(long l) {
        zzx zzx2 = this.zzr(l);
        this.zzbdc.getApplicationContext().registerReceiver((BroadcastReceiver)zzx2, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"), null, zzpf.zzno().getHandler());
        return this.zzs(l).getTask();
    }

    static /* synthetic */ zzpn zza(zzv zzv2) {
        return zzv2.zzbdc;
    }

    static /* synthetic */ GmsLogger zzos() {
        return zzbbo;
    }

    static /* synthetic */ LongSparseArray zzb(zzv zzv2) {
        return zzv2.zzbex;
    }

    static /* synthetic */ LongSparseArray zzc(zzv zzv2) {
        return zzv2.zzbey;
    }

    static /* synthetic */ zzn zzd(zzv zzv2) {
        return zzv2.zzor();
    }

    static /* synthetic */ zzw zze(zzv zzv2) {
        return zzv2.zzbfb;
    }

    static /* synthetic */ FirebaseMLException zza(zzv zzv2, Long l) {
        return zzv2.zzb(l);
    }
}

