/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.internal.modeldownload;

import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.internal.firebase_ml.zzmz;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zznq;
import com.google.android.gms.internal.firebase_ml.zzpb;
import com.google.android.gms.internal.firebase_ml.zzpn;
import com.google.android.gms.internal.firebase_ml.zzqc;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.common.internal.modeldownload.zza;
import com.google.firebase.ml.common.internal.modeldownload.zzab;
import com.google.firebase.ml.common.internal.modeldownload.zzae;
import com.google.firebase.ml.common.internal.modeldownload.zzah;
import com.google.firebase.ml.common.internal.modeldownload.zzi;
import com.google.firebase.ml.common.internal.modeldownload.zzk;
import com.google.firebase.ml.common.internal.modeldownload.zzn;
import com.google.firebase.ml.common.internal.modeldownload.zzp;
import com.google.firebase.ml.common.internal.modeldownload.zzr;
import com.google.firebase.ml.common.internal.modeldownload.zzs;
import com.google.firebase.ml.common.internal.modeldownload.zzw;
import com.google.firebase.ml.common.modeldownload.FirebaseRemoteModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class zzz {
    private static final GmsLogger zzbbo = new GmsLogger("RemoteModelFileManager", "");
    private final zzpn zzbdc;
    private final String zzbdo;
    private final FirebaseRemoteModel zzbfa;
    private final zzn zzbfi;
    private final zzah zzbfj;
    private final zzk zzbfk;
    private final zzqc zzbcm;
    private final zzi zzbdp;

    public zzz(@NonNull zzpn zzpn2, @NonNull FirebaseRemoteModel firebaseRemoteModel, @NonNull zzp zzp2, @NonNull zzn zzn2, @NonNull zzi zzi2) {
        this.zzbdc = zzpn2;
        this.zzbfa = firebaseRemoteModel;
        this.zzbdo = zzn2 == zzn.zzbej ? firebaseRemoteModel.getModelNameForBackend() : firebaseRemoteModel.getUniqueModelNameForPersist();
        this.zzbfi = zzn2;
        this.zzbfj = new zzah(zzp2);
        this.zzbcm = zzqc.zzb(zzpn2);
        this.zzbdp = zzi2;
        switch (zzn2) {
            case zzbeh: {
                this.zzbfk = new zza(zzpn2, this.zzbdo);
                return;
            }
            case zzbej: {
                this.zzbfk = new zzae(zzpn2, this.zzbdo);
                return;
            }
            case zzbeg: 
            case zzbei: {
                this.zzbfk = new zzab(zzpn2, this.zzbdo);
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected model type");
    }

    @Nullable
    @WorkerThread
    public final synchronized File zza(@NonNull ParcelFileDescriptor parcelFileDescriptor, @NonNull String string, @NonNull zzw zzw2) throws FirebaseMLException {
        Object object;
        zzn zzn2 = this.zzbcm.zzbv(string);
        if (this.zzbfi != zzn2) {
            zzw2.zza(zznq.zzanp, false, zzn2, zzng.zzag.zzb.zzauy);
            String string2 = zzn2.name();
            String string3 = this.zzbfi.name();
            throw new FirebaseMLException(new StringBuilder(93 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("You are trying to use a ").append(string2).append(" model as a ").append(string3).append(" model. Please make sure you specified the correct model.").toString(), 3);
        }
        File file = this.zzbdp.zzd(this.zzbdo, this.zzbfi);
        File file2 = new File(file, "to_be_validated_model.tmp");
        try {
            ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(parcelFileDescriptor);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    int n;
                    object = new byte[4096];
                    while ((n = autoCloseInputStream.read((byte[])object)) != -1) {
                        fileOutputStream.write((byte[])object, 0, n);
                    }
                    fileOutputStream.getFD().sync();
                }
                catch (Throwable throwable) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        zzmz.zza(throwable, throwable2);
                    }
                    throw throwable;
                }
                fileOutputStream.close();
            }
            catch (Throwable throwable) {
                try {
                    autoCloseInputStream.close();
                }
                catch (Throwable throwable3) {
                    zzmz.zza(throwable, throwable3);
                }
                throw throwable;
            }
            autoCloseInputStream.close();
        }
        catch (IOException iOException) {
            String string4 = String.valueOf(iOException);
            zzbbo.e("RemoteModelFileManager", new StringBuilder(56 + String.valueOf(string4).length()).append("Failed to copy downloaded model file to private folder: ").append(string4).toString());
            return null;
        }
        boolean bl = zzah.zza(file2, string);
        boolean bl2 = false;
        if (bl) {
            zzs zzs2 = this.zzbfj.zzb(file2, zzw2);
            object = zzs2;
            bl2 = zzs2.isValid();
            if (object.zzoh().equals((Object)zzr.zzbeq)) {
                String string5 = zzpb.zza(this.zzbdc.getApplicationContext());
                this.zzbcm.zza(this.zzbfa, string, string5);
                String string6 = String.valueOf(string);
                zzbbo.d("RemoteModelFileManager", string6.length() != 0 ? "Model is not compatible. Model hash: ".concat(string6) : new String("Model is not compatible. Model hash: "));
                String string7 = String.valueOf(string5);
                zzbbo.d("RemoteModelFileManager", string7.length() != 0 ? "The current app version is: ".concat(string7) : new String("The current app version is: "));
            }
        }
        if (!bl || !bl2) {
            if (!bl) {
                String string8 = String.valueOf(string);
                zzbbo.d("RemoteModelFileManager", string8.length() != 0 ? "Hash does not match with expected: ".concat(string8) : new String("Hash does not match with expected: "));
                zzw2.zza(zznq.zzanq, true, this.zzbfi, zzng.zzag.zzb.zzauu);
                object = (Object)new FirebaseMLException("Hash does not match with expected", 102);
            } else {
                object = (Object)new FirebaseMLException("Model is not compatible with TFLite run time", 100);
            }
            if (!file2.delete()) {
                String string9 = String.valueOf(file2.getAbsolutePath());
                zzbbo.d("RemoteModelFileManager", string9.length() != 0 ? "Failed to delete the temp file: ".concat(string9) : new String("Failed to delete the temp file: "));
            }
            throw object;
        }
        return this.zzbfk.zza(file2);
    }

    @WorkerThread
    public final synchronized boolean zzd(@NonNull File file) throws FirebaseMLException {
        File file2 = this.zzbdp.zzc(this.zzbdo, this.zzbfi);
        if (!file2.exists()) {
            return false;
        }
        File[] fileArray = file2.listFiles();
        boolean bl = true;
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file3 = fileArray2[i];
            if (file3.equals(file) || this.zzbdp.zzc(file3)) continue;
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    public final synchronized void zze(@NonNull File file) {
        zzz zzz2 = this;
        File file2 = zzz2.zzbdp.zzb(zzz2.zzbdo, zzz2.zzbfi, false);
        if (!file2.exists()) {
            return;
        }
        File[] fileArray = file2.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].equals(file)) continue;
            this.zzbdp.zzc(file);
            return;
        }
    }

    @WorkerThread
    public final synchronized File zzf(@NonNull File file) throws FirebaseMLException {
        String string = String.valueOf(this.zzbdp.zzc(this.zzbdo, this.zzbfi).getAbsolutePath()).concat("/0");
        File file2 = new File(string);
        if (file2.exists()) {
            return file;
        }
        if (file.renameTo(file2)) {
            return file2;
        }
        return file;
    }

    @Nullable
    @WorkerThread
    public final synchronized String zzot() throws FirebaseMLException {
        File file = this.zzbdp.zzc(this.zzbdo, this.zzbfi);
        int n = zzi.zzb(file);
        if (n < 0) {
            return null;
        }
        String string = file.getAbsolutePath();
        return new StringBuilder(12 + String.valueOf(string).length()).append(string).append("/").append(n).toString();
    }

    static /* synthetic */ GmsLogger zznw() {
        return zzbbo;
    }
}

