/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.ml.common.modeldownload;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase_ml.zzng;
import com.google.android.gms.internal.firebase_ml.zzvx;
import com.google.firebase.ml.common.internal.modeldownload.zzn;

public class FirebaseLocalModel {
    private final String zzbdo;
    private final String zzbfw;
    private final String zzbfx;

    @Nullable
    @KeepForSdk
    public String getFilePath() {
        return this.zzbfw;
    }

    @Nullable
    @KeepForSdk
    public String getAssetFilePath() {
        return this.zzbfx;
    }

    @KeepForSdk
    protected FirebaseLocalModel(@NonNull String string, @Nullable String string2, @Nullable String string3) {
        this.zzbdo = string;
        this.zzbfw = string2;
        this.zzbfx = string3;
    }

    public boolean equals(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof FirebaseLocalModel)) {
            return false;
        }
        FirebaseLocalModel firebaseLocalModel = (FirebaseLocalModel)object;
        return Objects.equal((Object)this.zzbdo, (Object)firebaseLocalModel.zzbdo) && Objects.equal((Object)this.zzbfw, (Object)firebaseLocalModel.zzbfw) && Objects.equal((Object)this.zzbfx, (Object)firebaseLocalModel.zzbfx);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzbdo, this.zzbfw, this.zzbfx});
    }

    public final zzng.zzai zza(zzn zzn2) {
        FirebaseLocalModel firebaseLocalModel = this;
        return (zzng.zzai)((zzvx)zzng.zzai.zzma().zza(zzng.zzah.zzly().zzd(zzn2.zzof()).zzbf(this.zzbfw == null ? this.zzbfx : this.zzbfw).zzb(firebaseLocalModel.zzbfw != null ? zzng.zzah.zzc.zzavn : (firebaseLocalModel.zzbfx != null ? zzng.zzah.zzc.zzavm : zzng.zzah.zzc.zzavl))).zztx());
    }

    public static class Builder {
        private final String zzbdo;
        private String zzbfw = null;
        private String zzbfx = null;

        public Builder(@NonNull String string) {
            Preconditions.checkNotEmpty((String)string, (Object)"Model name can not be empty");
            this.zzbdo = string;
        }

        @NonNull
        public Builder setFilePath(@NonNull String string) {
            Preconditions.checkNotEmpty((String)string, (Object)"Model Source file path can not be empty");
            Preconditions.checkArgument((this.zzbfx == null ? 1 : 0) != 0, (Object)"A local model source is either from local file or for asset, you can not set both.");
            this.zzbfw = string;
            return this;
        }

        @NonNull
        public Builder setAssetFilePath(@NonNull String string) {
            Preconditions.checkNotEmpty((String)string, (Object)"Model Source file path can not be empty");
            Preconditions.checkArgument((this.zzbfw == null ? 1 : 0) != 0, (Object)"A local model source is either from local file or for asset, you can not set both.");
            this.zzbfx = string;
            return this;
        }

        @NonNull
        public FirebaseLocalModel build() {
            Preconditions.checkArgument((this.zzbfw != null && this.zzbfx == null || this.zzbfw == null && this.zzbfx != null ? 1 : 0) != 0, (Object)"Set either filePath or assetFilePath.");
            return new FirebaseLocalModel(this.zzbdo, this.zzbfw, this.zzbfx);
        }
    }
}

