/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.inject.Provider;
import com.google.firebase.perf.internal.RemoteConfigManager$$Lambda$1;
import com.google.firebase.perf.internal.RemoteConfigManager$$Lambda$2;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.util.Optional;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.RemoteConfigComponent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Keep
public class RemoteConfigManager {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final String FIREPERF_FRC_NAMESPACE_NAME = "fireperf";
    private static final RemoteConfigManager sharedInstance = new RemoteConfigManager();
    private static final long TIME_AFTER_WHICH_A_FETCH_IS_CONSIDERED_STALE_MS = TimeUnit.HOURS.toMillis(12L);
    private static final long FETCH_NEVER_HAPPENED_TIMESTAMP_MS = 0L;
    private long firebaseRemoteConfigLastFetchTimestampMs = 0L;
    @Nullable
    private Provider<RemoteConfigComponent> firebaseRemoteConfigProvider;
    @Nullable
    private FirebaseRemoteConfig firebaseRemoteConfig;
    private final Executor executor;
    private final ConcurrentHashMap<String, FirebaseRemoteConfigValue> allRcConfigMap;

    private RemoteConfigManager() {
        this(new ThreadPoolExecutor(0, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()), null);
    }

    @VisibleForTesting
    RemoteConfigManager(Executor executor, FirebaseRemoteConfig firebaseRemoteConfig) {
        this.executor = executor;
        this.firebaseRemoteConfig = firebaseRemoteConfig;
        this.allRcConfigMap = firebaseRemoteConfig == null ? new ConcurrentHashMap() : new ConcurrentHashMap(firebaseRemoteConfig.getAll());
    }

    public static RemoteConfigManager getInstance() {
        return sharedInstance;
    }

    public void setFirebaseRemoteConfigProvider(@Nullable Provider<RemoteConfigComponent> firebaseRemoteConfigProvider) {
        this.firebaseRemoteConfigProvider = firebaseRemoteConfigProvider;
    }

    public Optional<Float> getFloat(String key) {
        block4: {
            if (key == null) {
                logger.debug("The key to get Remote Config float value is null.", new Object[0]);
                return Optional.empty();
            }
            FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
            if (rcValue != null) {
                try {
                    return Optional.of(Float.valueOf(Double.valueOf(rcValue.asDouble()).floatValue()));
                }
                catch (IllegalArgumentException e) {
                    if (rcValue.asString().isEmpty()) break block4;
                    logger.debug(String.format("Could not parse value: '%s' for key: '%s'.", rcValue.asString(), key), new Object[0]);
                }
            }
        }
        return Optional.empty();
    }

    public Optional<Long> getLong(String key) {
        block4: {
            if (key == null) {
                logger.debug("The key to get Remote Config long value is null.", new Object[0]);
                return Optional.empty();
            }
            FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
            if (rcValue != null) {
                try {
                    return Optional.of(rcValue.asLong());
                }
                catch (IllegalArgumentException e) {
                    if (rcValue.asString().isEmpty()) break block4;
                    logger.debug(String.format("Could not parse value: '%s' for key: '%s'.", rcValue.asString(), key), new Object[0]);
                }
            }
        }
        return Optional.empty();
    }

    public Optional<Boolean> getBoolean(String key) {
        block4: {
            if (key == null) {
                logger.debug("The key to get Remote Config boolean value is null.", new Object[0]);
                return Optional.empty();
            }
            FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
            if (rcValue != null) {
                try {
                    return Optional.of(rcValue.asBoolean());
                }
                catch (IllegalArgumentException e) {
                    if (rcValue.asString().isEmpty()) break block4;
                    logger.debug(String.format("Could not parse value: '%s' for key: '%s'.", rcValue.asString(), key), new Object[0]);
                }
            }
        }
        return Optional.empty();
    }

    public Optional<String> getString(String key) {
        if (key == null) {
            logger.debug("The key to get Remote Config String value is null.", new Object[0]);
            return Optional.empty();
        }
        FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
        if (rcValue != null) {
            return Optional.of(rcValue.asString());
        }
        return Optional.empty();
    }

    public <T> T getRemoteConfigValueOrDefault(String key, T defaultValue) {
        Object valueToReturn;
        block11: {
            valueToReturn = defaultValue;
            FirebaseRemoteConfigValue rcValue = this.getRemoteConfigValue(key);
            if (rcValue != null) {
                try {
                    if (defaultValue instanceof Boolean) {
                        valueToReturn = rcValue.asBoolean();
                    } else if (defaultValue instanceof Float) {
                        valueToReturn = Float.valueOf(Double.valueOf(rcValue.asDouble()).floatValue());
                    } else if (defaultValue instanceof Long || defaultValue instanceof Integer) {
                        valueToReturn = rcValue.asLong();
                    } else if (defaultValue instanceof String) {
                        valueToReturn = rcValue.asString();
                    } else {
                        valueToReturn = rcValue.asString();
                        logger.debug(String.format("No matching type found for the defaultValue: '%s', using String.", defaultValue), new Object[0]);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (rcValue.asString().isEmpty()) break block11;
                    logger.debug(String.format("Could not parse value: '%s' for key: '%s'.", rcValue.asString(), key), new Object[0]);
                }
            }
        }
        return valueToReturn;
    }

    private FirebaseRemoteConfigValue getRemoteConfigValue(String key) {
        FirebaseRemoteConfigValue rcValue;
        this.triggerRemoteConfigFetchIfNecessary();
        if (this.isFirebaseRemoteConfigAvailable() && this.allRcConfigMap.containsKey(key) && (rcValue = this.allRcConfigMap.get(key)).getSource() == 2) {
            logger.debug(String.format("Fetched value: '%s' for key: '%s' from Firebase Remote Config.", rcValue.asString(), key), new Object[0]);
            return rcValue;
        }
        return null;
    }

    public boolean isLastFetchFailed() {
        return this.firebaseRemoteConfig == null || this.firebaseRemoteConfig.getInfo().getLastFetchStatus() == 1;
    }

    private void triggerRemoteConfigFetchIfNecessary() {
        if (!this.isFirebaseRemoteConfigAvailable()) {
            return;
        }
        if (this.allRcConfigMap.isEmpty()) {
            this.syncConfigValues(this.firebaseRemoteConfig.getAll());
        }
        if (this.shouldFetchAndActivateRemoteConfigValues()) {
            this.triggerFirebaseRemoteConfigFetchAndActivateOnSuccessfulFetch();
        }
    }

    private void triggerFirebaseRemoteConfigFetchAndActivateOnSuccessfulFetch() {
        this.firebaseRemoteConfigLastFetchTimestampMs = this.getCurrentSystemTimeMillis();
        this.firebaseRemoteConfig.fetchAndActivate().addOnSuccessListener(this.executor, RemoteConfigManager$$Lambda$1.lambdaFactory$(this)).addOnFailureListener(this.executor, RemoteConfigManager$$Lambda$2.lambdaFactory$(this));
    }

    @VisibleForTesting
    protected void syncConfigValues(Map<String, FirebaseRemoteConfigValue> newlyFetchedMap) {
        this.allRcConfigMap.putAll(newlyFetchedMap);
        for (String existingKey : this.allRcConfigMap.keySet()) {
            if (newlyFetchedMap.containsKey(existingKey)) continue;
            this.allRcConfigMap.remove(existingKey);
        }
    }

    @VisibleForTesting
    protected long getCurrentSystemTimeMillis() {
        return System.currentTimeMillis();
    }

    public boolean isFirebaseRemoteConfigAvailable() {
        RemoteConfigComponent rcComponent;
        if (this.firebaseRemoteConfig == null && this.firebaseRemoteConfigProvider != null && (rcComponent = (RemoteConfigComponent)this.firebaseRemoteConfigProvider.get()) != null) {
            this.firebaseRemoteConfig = rcComponent.get(FIREPERF_FRC_NAMESPACE_NAME);
        }
        return this.firebaseRemoteConfig != null;
    }

    public boolean isFirebaseRemoteConfigMapEmpty() {
        return this.allRcConfigMap.isEmpty();
    }

    private boolean shouldFetchAndActivateRemoteConfigValues() {
        return this.getCurrentSystemTimeMillis() - this.firebaseRemoteConfigLastFetchTimestampMs > TIME_AFTER_WHICH_A_FETCH_IS_CONSIDERED_STALE_MS;
    }

    @VisibleForTesting
    public static int getVersionCode(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return 0;
        }
    }

    static /* synthetic */ void lambda$triggerFirebaseRemoteConfigFetchAndActivateOnSuccessfulFetch$1(RemoteConfigManager this_, Exception task) {
        this_.firebaseRemoteConfigLastFetchTimestampMs = 0L;
    }

    static /* synthetic */ void lambda$triggerFirebaseRemoteConfigFetchAndActivateOnSuccessfulFetch$0(RemoteConfigManager this_, Boolean result) {
        this_.syncConfigValues(this_.firebaseRemoteConfig.getAll());
    }
}

