/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.internal;

import android.annotation.SuppressLint;
import androidx.annotation.Keep;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.internal.AppStateMonitor;
import com.google.firebase.perf.internal.AppStateUpdateHandler;
import com.google.firebase.perf.internal.GaugeManager;
import com.google.firebase.perf.internal.PerfSession;
import com.google.firebase.perf.internal.SessionAwareObject;
import com.google.firebase.perf.v1.ApplicationProcessState;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@Keep
public class SessionManager
extends AppStateUpdateHandler {
    @SuppressLint(value={"StaticFieldLeak"})
    private static final SessionManager ourInstance = new SessionManager();
    private final GaugeManager gaugeManager;
    private final AppStateMonitor appStateMonitor;
    private final Set<WeakReference<SessionAwareObject>> clients = new HashSet<WeakReference<SessionAwareObject>>();
    private PerfSession perfSession;

    public static SessionManager getInstance() {
        return ourInstance;
    }

    public final PerfSession perfSession() {
        return this.perfSession;
    }

    private SessionManager() {
        this(GaugeManager.getInstance(), PerfSession.create(), AppStateMonitor.getInstance());
    }

    @VisibleForTesting
    public SessionManager(GaugeManager gaugeManager, PerfSession perfSession, AppStateMonitor appStateMonitor) {
        this.gaugeManager = gaugeManager;
        this.perfSession = perfSession;
        this.appStateMonitor = appStateMonitor;
        this.registerForAppState();
    }

    @Override
    public void onUpdateAppState(ApplicationProcessState newAppState) {
        super.onUpdateAppState(newAppState);
        if (this.appStateMonitor.isColdStart()) {
            return;
        }
        if (newAppState == ApplicationProcessState.FOREGROUND) {
            this.updatePerfSession(newAppState);
        } else if (!this.updatePerfSessionIfExpired()) {
            this.startOrStopCollectingGauges(newAppState);
        }
    }

    public boolean updatePerfSessionIfExpired() {
        if (this.perfSession.isExpired()) {
            this.updatePerfSession(this.appStateMonitor.getAppState());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePerfSession(ApplicationProcessState currentAppState) {
        Set<WeakReference<SessionAwareObject>> set = this.clients;
        synchronized (set) {
            this.perfSession = PerfSession.create();
            Iterator<WeakReference<SessionAwareObject>> i = this.clients.iterator();
            while (i.hasNext()) {
                SessionAwareObject callback = (SessionAwareObject)i.next().get();
                if (callback != null) {
                    callback.updateSession(this.perfSession);
                    continue;
                }
                i.remove();
            }
        }
        this.logGaugeMetadataIfCollectionEnabled(currentAppState);
        this.startOrStopCollectingGauges(currentAppState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForSessionUpdates(WeakReference<SessionAwareObject> client) {
        Set<WeakReference<SessionAwareObject>> set = this.clients;
        synchronized (set) {
            this.clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForSessionUpdates(WeakReference<SessionAwareObject> client) {
        Set<WeakReference<SessionAwareObject>> set = this.clients;
        synchronized (set) {
            this.clients.remove(client);
        }
    }

    private void logGaugeMetadataIfCollectionEnabled(ApplicationProcessState appState) {
        if (this.perfSession.isGaugeAndEventCollectionEnabled()) {
            this.gaugeManager.logGaugeMetadata(this.perfSession.sessionId(), appState);
        }
    }

    private void startOrStopCollectingGauges(ApplicationProcessState appState) {
        if (this.perfSession.isGaugeAndEventCollectionEnabled()) {
            this.gaugeManager.startCollectingGauges(this.perfSession, appState);
        } else {
            this.gaugeManager.stopCollectingGauges();
        }
    }

    @VisibleForTesting
    public void setPerfSession(PerfSession perfSession) {
        this.perfSession = perfSession;
    }
}

