/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.provider.FirebasePerfProvider;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Constants;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.v1.ApplicationProcessState;
import com.google.firebase.perf.v1.TraceMetric;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class AppStartTrace
implements Application.ActivityLifecycleCallbacks {
    private static final long MAX_LATENCY_BEFORE_UI_INIT = TimeUnit.MINUTES.toMicros(1L);
    private static volatile AppStartTrace sInstance;
    private boolean mRegistered = false;
    private final TransportManager transportManager;
    private final Clock mClock;
    private Context mAppContext;
    private WeakReference<Activity> mLaunchActivity;
    private WeakReference<Activity> mAppStartActivity;
    private boolean mTooLateToInitUI = false;
    private Timer mOnCreateTime = null;
    private Timer mOnStartTime = null;
    private Timer mOnResumeTime = null;
    private boolean mIsStartFromBackground = false;

    @Keep
    public static void setLauncherActivityOnCreateTime(String activity) {
    }

    @Keep
    public static void setLauncherActivityOnStartTime(String activity) {
    }

    @Keep
    public static void setLauncherActivityOnResumeTime(String activity) {
    }

    public static AppStartTrace getInstance() {
        return sInstance != null ? sInstance : AppStartTrace.getInstance(TransportManager.getInstance(), new Clock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AppStartTrace getInstance(TransportManager transportManager, Clock clock) {
        if (sInstance != null) return sInstance;
        Class<AppStartTrace> clazz = AppStartTrace.class;
        synchronized (AppStartTrace.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AppStartTrace(transportManager, clock);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    AppStartTrace(@NonNull TransportManager transportManager, @NonNull Clock clock) {
        this.transportManager = transportManager;
        this.mClock = clock;
    }

    public synchronized void registerActivityLifecycleCallbacks(@NonNull Context context) {
        if (this.mRegistered) {
            return;
        }
        Context appContext = context.getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.mRegistered = true;
            this.mAppContext = appContext;
        }
    }

    public synchronized void unregisterActivityLifecycleCallbacks() {
        if (!this.mRegistered) {
            return;
        }
        ((Application)this.mAppContext).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.mRegistered = false;
    }

    public synchronized void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (this.mIsStartFromBackground || this.mOnCreateTime != null) {
            return;
        }
        this.mLaunchActivity = new WeakReference<Activity>(activity);
        this.mOnCreateTime = this.mClock.getTime();
        if (FirebasePerfProvider.getAppStartTime().getDurationMicros(this.mOnCreateTime) > MAX_LATENCY_BEFORE_UI_INIT) {
            this.mTooLateToInitUI = true;
        }
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.mIsStartFromBackground || this.mOnStartTime != null || this.mTooLateToInitUI) {
            return;
        }
        this.mOnStartTime = this.mClock.getTime();
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.mIsStartFromBackground || this.mOnResumeTime != null || this.mTooLateToInitUI) {
            return;
        }
        this.mAppStartActivity = new WeakReference<Activity>(activity);
        this.mOnResumeTime = this.mClock.getTime();
        Timer startTime = FirebasePerfProvider.getAppStartTime();
        AndroidLogger.getInstance().debug("onResume(): " + activity.getClass().getName() + ": " + startTime.getDurationMicros(this.mOnResumeTime) + " microseconds", new Object[0]);
        TraceMetric.Builder metric = TraceMetric.newBuilder().setName(Constants.TraceNames.APP_START_TRACE_NAME.toString()).setClientStartTimeUs(startTime.getMicros()).setDurationUs(startTime.getDurationMicros(this.mOnResumeTime));
        ArrayList<TraceMetric> subtraces = new ArrayList<TraceMetric>(3);
        TraceMetric.Builder temp = TraceMetric.newBuilder().setName(Constants.TraceNames.ON_CREATE_TRACE_NAME.toString()).setClientStartTimeUs(startTime.getMicros()).setDurationUs(startTime.getDurationMicros(this.mOnCreateTime));
        subtraces.add((TraceMetric)temp.build());
        temp = TraceMetric.newBuilder();
        temp.setName(Constants.TraceNames.ON_START_TRACE_NAME.toString()).setClientStartTimeUs(this.mOnCreateTime.getMicros()).setDurationUs(this.mOnCreateTime.getDurationMicros(this.mOnStartTime));
        subtraces.add((TraceMetric)temp.build());
        temp = TraceMetric.newBuilder();
        temp.setName(Constants.TraceNames.ON_RESUME_TRACE_NAME.toString()).setClientStartTimeUs(this.mOnStartTime.getMicros()).setDurationUs(this.mOnStartTime.getDurationMicros(this.mOnResumeTime));
        subtraces.add((TraceMetric)temp.build());
        metric.addAllSubtraces(subtraces).addPerfSessions(SessionManager.getInstance().perfSession().build());
        this.transportManager.log((TraceMetric)metric.build(), ApplicationProcessState.FOREGROUND_BACKGROUND);
        if (this.mRegistered) {
            this.unregisterActivityLifecycleCallbacks();
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public synchronized void onActivityStopped(Activity activity) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    @VisibleForTesting
    @Nullable
    Activity getLaunchActivity() {
        return (Activity)this.mLaunchActivity.get();
    }

    @VisibleForTesting
    @Nullable
    Activity getAppStartActivity() {
        return (Activity)this.mAppStartActivity.get();
    }

    @VisibleForTesting
    Timer getOnCreateTime() {
        return this.mOnCreateTime;
    }

    @VisibleForTesting
    Timer getOnStartTime() {
        return this.mOnStartTime;
    }

    @VisibleForTesting
    Timer getOnResumeTime() {
        return this.mOnResumeTime;
    }

    @VisibleForTesting
    void setIsStartFromBackground() {
        this.mIsStartFromBackground = true;
    }

    public static class StartFromBackgroundRunnable
    implements Runnable {
        private final AppStartTrace mTrace;

        public StartFromBackgroundRunnable(AppStartTrace trace) {
            this.mTrace = trace;
        }

        @Override
        public void run() {
            if (this.mTrace.mOnCreateTime == null) {
                this.mTrace.mIsStartFromBackground = true;
            }
        }
    }
}

