/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.FirebasePerformanceAttributable;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.internal.AppStateMonitor;
import com.google.firebase.perf.internal.AppStateUpdateHandler;
import com.google.firebase.perf.internal.GaugeManager;
import com.google.firebase.perf.internal.PerfMetricValidator;
import com.google.firebase.perf.internal.PerfSession;
import com.google.firebase.perf.internal.SessionAwareObject;
import com.google.firebase.perf.internal.SessionManager;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.Counter;
import com.google.firebase.perf.metrics.TraceMetricBuilder;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Timer;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Trace
extends AppStateUpdateHandler
implements Parcelable,
FirebasePerformanceAttributable,
SessionAwareObject {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final Map<String, Trace> sTraces = new ConcurrentHashMap<String, Trace>();
    private final Trace parent;
    private final GaugeManager gaugeManager;
    private final String name;
    private final List<PerfSession> sessions;
    private final List<Trace> subtraces;
    private final Map<String, Counter> counters;
    private final Clock clock;
    private final TransportManager transportManager;
    private final Map<String, String> attributes;
    private Timer startTime;
    private Timer endTime;
    private final WeakReference<SessionAwareObject> weakReference = new WeakReference<Trace>(this);
    @Keep
    public static final Parcelable.Creator<Trace> CREATOR = new Parcelable.Creator<Trace>(){

        public Trace createFromParcel(@NonNull Parcel in) {
            return new Trace(in, false);
        }

        public Trace[] newArray(int size) {
            return new Trace[size];
        }
    };
    @VisibleForTesting
    static final Parcelable.Creator<Trace> CREATOR_DATAONLY = new Parcelable.Creator<Trace>(){

        public Trace createFromParcel(Parcel in) {
            return new Trace(in, true);
        }

        public Trace[] newArray(int size) {
            return new Trace[size];
        }
    };

    @Override
    public void updateSession(PerfSession session) {
        if (session == null) {
            logger.info("Unable to add new SessionId to the Trace. Continuing without it.", new Object[0]);
            return;
        }
        if (this.hasStarted() && !this.isStopped()) {
            this.sessions.add(session);
        }
    }

    @NonNull
    public static Trace create(@NonNull String name) {
        return new Trace(name);
    }

    private Trace(@NonNull String name) {
        this(name, TransportManager.getInstance(), new Clock(), AppStateMonitor.getInstance(), GaugeManager.getInstance());
    }

    private Trace(@NonNull Trace parent, @NonNull String name, Timer startTime, Timer endTime, @Nullable List<Trace> subtraces, @Nullable Map<String, Counter> counters, @Nullable Map<String, String> attributes) {
        this.parent = parent;
        this.name = name.trim();
        this.startTime = startTime;
        this.endTime = endTime;
        this.subtraces = subtraces != null ? subtraces : new ArrayList();
        this.counters = counters != null ? counters : new ConcurrentHashMap();
        this.attributes = attributes != null ? attributes : new ConcurrentHashMap();
        this.clock = parent.clock;
        this.transportManager = parent.transportManager;
        this.sessions = Collections.synchronizedList(new ArrayList());
        this.gaugeManager = this.parent.gaugeManager;
    }

    public Trace(@NonNull String name, @NonNull TransportManager transportManager, @NonNull Clock clock, @NonNull AppStateMonitor appStateMonitor) {
        this(name, transportManager, clock, appStateMonitor, GaugeManager.getInstance());
    }

    public Trace(@NonNull String name, @NonNull TransportManager transportManager, @NonNull Clock clock, @NonNull AppStateMonitor appStateMonitor, @NonNull GaugeManager gaugeManager) {
        super(appStateMonitor);
        this.parent = null;
        this.name = name.trim();
        this.subtraces = new ArrayList<Trace>();
        this.counters = new ConcurrentHashMap<String, Counter>();
        this.attributes = new ConcurrentHashMap<String, String>();
        this.clock = clock;
        this.transportManager = transportManager;
        this.sessions = Collections.synchronizedList(new ArrayList());
        this.gaugeManager = gaugeManager;
    }

    private Trace(@NonNull Parcel in, boolean isDataOnly) {
        super(isDataOnly ? null : AppStateMonitor.getInstance());
        this.parent = (Trace)in.readParcelable(Trace.class.getClassLoader());
        this.name = in.readString();
        this.subtraces = new ArrayList<Trace>();
        in.readList(this.subtraces, Trace.class.getClassLoader());
        this.counters = new ConcurrentHashMap<String, Counter>();
        this.attributes = new ConcurrentHashMap<String, String>();
        in.readMap(this.counters, Counter.class.getClassLoader());
        this.startTime = (Timer)in.readParcelable(Timer.class.getClassLoader());
        this.endTime = (Timer)in.readParcelable(Timer.class.getClassLoader());
        this.sessions = Collections.synchronizedList(new ArrayList());
        in.readList(this.sessions, PerfSession.class.getClassLoader());
        if (isDataOnly) {
            this.transportManager = null;
            this.clock = null;
            this.gaugeManager = null;
        } else {
            this.transportManager = TransportManager.getInstance();
            this.clock = new Clock();
            this.gaugeManager = GaugeManager.getInstance();
        }
    }

    @Keep
    public void start() {
        if (!ConfigResolver.getInstance().isPerformanceMonitoringEnabled()) {
            logger.info("Trace feature is disabled.", new Object[0]);
            return;
        }
        String err = PerfMetricValidator.validateTraceName(this.name);
        if (err != null) {
            logger.error(String.format(Locale.ENGLISH, "Cannot start trace '%s'. Trace name is invalid.(%s)", this.name, err), new Object[0]);
            return;
        }
        if (this.startTime != null) {
            logger.error(String.format(Locale.ENGLISH, "Trace '%s' has already started, should not start again!", this.name), new Object[0]);
            return;
        }
        this.startTime = this.clock.getTime();
        this.registerForAppState();
        SessionManager sessionManager = SessionManager.getInstance();
        PerfSession perfSession = sessionManager.perfSession();
        SessionManager.getInstance().registerForSessionUpdates(this.weakReference);
        this.updateSession(perfSession);
        if (perfSession.isGaugeAndEventCollectionEnabled()) {
            this.gaugeManager.collectGaugeMetricOnce(perfSession.getTimer());
        }
    }

    @Keep
    public void stop() {
        if (!this.hasStarted()) {
            logger.error(String.format(Locale.ENGLISH, "Trace '%s' has not been started so unable to stop!", this.name), new Object[0]);
            return;
        }
        if (this.isStopped()) {
            logger.error(String.format(Locale.ENGLISH, "Trace '%s' has already stopped, should not stop again!", this.name), new Object[0]);
            return;
        }
        SessionManager.getInstance().unregisterForSessionUpdates(this.weakReference);
        this.unregisterForAppState();
        this.endTime = this.clock.getTime();
        if (this.parent == null) {
            this.setEndTimeOfLastStage(this.endTime);
            if (!this.name.isEmpty()) {
                this.transportManager.log(new TraceMetricBuilder(this).build(), this.getAppState());
                if (SessionManager.getInstance().perfSession().isGaugeAndEventCollectionEnabled()) {
                    this.gaugeManager.collectGaugeMetricOnce(SessionManager.getInstance().perfSession().getTimer());
                }
            } else {
                logger.error("Trace name is empty, no log is sent to server", new Object[0]);
            }
        }
    }

    private void setEndTimeOfLastStage(Timer endTime) {
        if (this.subtraces.isEmpty()) {
            return;
        }
        int lastLocation = this.subtraces.size() - 1;
        Trace lastStage = this.subtraces.get(lastLocation);
        if (lastStage.endTime == null) {
            lastStage.endTime = endTime;
        }
    }

    void startStage(@NonNull String name) {
        Timer currentTime = this.clock.getTime();
        this.setEndTimeOfLastStage(currentTime);
        this.subtraces.add(new Trace(this, name, currentTime, null, null, null, null));
    }

    void stopStage() {
        this.setEndTimeOfLastStage(this.clock.getTime());
    }

    @NonNull
    private Counter obtainOrCreateCounterByName(@NonNull String counterName) {
        Counter counter = this.counters.get(counterName);
        if (counter == null) {
            counter = new Counter(counterName);
            this.counters.put(counterName, counter);
        }
        return counter;
    }

    @Keep
    public void incrementMetric(@NonNull String metricName, long incrementBy) {
        String err = PerfMetricValidator.validateMetricName(metricName);
        if (err != null) {
            logger.error(String.format(Locale.ENGLISH, "Cannot increment metric '%s'. Metric name is invalid.(%s)", metricName, err), new Object[0]);
            return;
        }
        if (!this.hasStarted()) {
            logger.warn(String.format(Locale.ENGLISH, "Cannot increment metric '%s' for trace '%s' because it's not started", metricName, this.name), new Object[0]);
            return;
        }
        if (this.isStopped()) {
            logger.warn(String.format(Locale.ENGLISH, "Cannot increment metric '%s' for trace '%s' because it's been stopped", metricName, this.name), new Object[0]);
            return;
        }
        Counter counter = this.obtainOrCreateCounterByName(metricName.trim());
        counter.increment(incrementBy);
        logger.debug(String.format(Locale.ENGLISH, "Incrementing metric '%s' to %d on trace '%s'", metricName, counter.getCount(), this.name), new Object[0]);
    }

    @Keep
    public long getLongMetric(@NonNull String metricName) {
        Counter counter = null;
        if (metricName != null) {
            counter = this.counters.get(metricName.trim());
        }
        if (counter == null) {
            return 0L;
        }
        return counter.getCount();
    }

    @Keep
    public void putMetric(@NonNull String metricName, long value) {
        String err = PerfMetricValidator.validateMetricName(metricName);
        if (err != null) {
            logger.error(String.format(Locale.ENGLISH, "Cannot set value for metric '%s'. Metric name is invalid.(%s)", metricName, err), new Object[0]);
            return;
        }
        if (!this.hasStarted()) {
            logger.warn(String.format(Locale.ENGLISH, "Cannot set value for metric '%s' for trace '%s' because it's not started", metricName, this.name), new Object[0]);
            return;
        }
        if (this.isStopped()) {
            logger.warn(String.format(Locale.ENGLISH, "Cannot set value for metric '%s' for trace '%s' because it's been stopped", metricName, this.name), new Object[0]);
            return;
        }
        Counter counter = this.obtainOrCreateCounterByName(metricName.trim());
        counter.setCount(value);
        logger.debug(String.format(Locale.ENGLISH, "Setting metric '%s' to '%s' on trace '%s'", metricName, value, this.name), new Object[0]);
    }

    @NonNull
    static synchronized Trace getTrace(@NonNull String traceName) {
        Trace trace = sTraces.get(traceName);
        if (trace == null) {
            trace = new Trace(traceName);
            sTraces.put(traceName, trace);
        }
        return trace;
    }

    @VisibleForTesting
    @NonNull
    static synchronized Trace getTrace(@NonNull String traceName, @NonNull TransportManager transportManager, @NonNull Clock clock, @NonNull AppStateMonitor appStateMonitor) {
        Trace trace = sTraces.get(traceName);
        if (trace == null) {
            trace = new Trace(traceName, transportManager, clock, appStateMonitor, GaugeManager.getInstance());
            sTraces.put(traceName, trace);
        }
        return trace;
    }

    @Nullable
    static Trace startTrace(@NonNull String traceName) {
        Trace trace = sTraces.get(traceName);
        if (trace != null) {
            trace.start();
        }
        return trace;
    }

    @Nullable
    static Trace stopTrace(@NonNull String traceName) {
        Trace trace = sTraces.get(traceName);
        if (trace != null) {
            trace.stop();
            sTraces.remove(traceName);
        }
        return trace;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isActive()) {
                logger.warn(String.format(Locale.ENGLISH, "Trace '%s' is started but not stopped when it is destructed!", this.name), new Object[0]);
                this.incrementTsnsCount(1);
            }
        }
        finally {
            super.finalize();
        }
    }

    @VisibleForTesting
    @NonNull
    String getName() {
        return this.name;
    }

    @VisibleForTesting
    @NonNull
    Map<String, Counter> getCounters() {
        return this.counters;
    }

    @VisibleForTesting
    Timer getStartTime() {
        return this.startTime;
    }

    @VisibleForTesting
    Timer getEndTime() {
        return this.endTime;
    }

    @VisibleForTesting
    @NonNull
    List<Trace> getSubtraces() {
        return this.subtraces;
    }

    @VisibleForTesting
    boolean isStopped() {
        return this.endTime != null;
    }

    @VisibleForTesting
    boolean hasStarted() {
        return this.startTime != null;
    }

    @VisibleForTesting
    boolean isActive() {
        return this.hasStarted() && !this.isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.parent, 0);
        out.writeString(this.name);
        out.writeList(this.subtraces);
        out.writeMap(this.counters);
        out.writeParcelable((Parcelable)this.startTime, 0);
        out.writeParcelable((Parcelable)this.endTime, 0);
        List<PerfSession> list = this.sessions;
        synchronized (list) {
            out.writeList(this.sessions);
        }
    }

    @Override
    @Keep
    public void putAttribute(@NonNull String attribute, @NonNull String value) {
        boolean noError = true;
        try {
            attribute = attribute.trim();
            value = value.trim();
            this.checkAttribute(attribute, value);
            logger.debug(String.format(Locale.ENGLISH, "Setting attribute '%s' to '%s' on trace '%s'", attribute, value, this.name), new Object[0]);
        }
        catch (Exception e) {
            logger.error(String.format(Locale.ENGLISH, "Can not set attribute '%s' with value '%s' (%s)", attribute, value, e.getMessage()), new Object[0]);
            noError = false;
        }
        if (noError) {
            this.attributes.put(attribute, value);
        }
    }

    private void checkAttribute(@NonNull String key, @NonNull String value) {
        if (this.isStopped()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Trace '%s' has been stopped", this.name));
        }
        if (!this.attributes.containsKey(key) && this.attributes.size() >= 5) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Exceeds max limit of number of attributes - %d", 5));
        }
        String err = PerfMetricValidator.validateAttribute(new AbstractMap.SimpleEntry<String, String>(key, value));
        if (err != null) {
            throw new IllegalArgumentException(err);
        }
    }

    @Override
    @Keep
    public void removeAttribute(@NonNull String attribute) {
        if (this.isStopped()) {
            logger.error("Can't remove a attribute from a Trace that's stopped.", new Object[0]);
            return;
        }
        this.attributes.remove(attribute);
    }

    @Override
    @Nullable
    @Keep
    public String getAttribute(@NonNull String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    @NonNull
    @Keep
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.attributes);
    }

    @Keep
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<PerfSession> getSessions() {
        List<PerfSession> list = this.sessions;
        synchronized (list) {
            ArrayList<PerfSession> sessionsListCopy = new ArrayList<PerfSession>();
            for (PerfSession session : this.sessions) {
                if (session == null) continue;
                sessionsListCopy.add(session);
            }
            return Collections.unmodifiableList(sessionsListCopy);
        }
    }
}

