/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import com.google.firebase.perf.impl.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import java.io.InputStream;

public final class InstrHttpInputStream
extends InputStream {
    private final InputStream mInputStream;
    private final NetworkRequestMetricBuilder mBuilder;
    private final Timer mTimer;
    private long mBytesRead = -1L;
    private long mTimeToResponseInitiated;
    private long mTimeToResponseLastRead = -1L;

    public InstrHttpInputStream(InputStream inputStream, NetworkRequestMetricBuilder builder, Timer timer) {
        this.mTimer = timer;
        this.mInputStream = inputStream;
        this.mBuilder = builder;
        this.mTimeToResponseInitiated = this.mBuilder.getTimeToResponseInitiatedMicros();
    }

    @Override
    public int available() throws IOException {
        try {
            return this.mInputStream.available();
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        long tempTime = this.mTimer.getDurationMicros();
        if (this.mTimeToResponseLastRead == -1L) {
            this.mTimeToResponseLastRead = tempTime;
        }
        try {
            this.mInputStream.close();
            if (this.mBytesRead != -1L) {
                this.mBuilder.setResponsePayloadBytes(this.mBytesRead);
            }
            if (this.mTimeToResponseInitiated != -1L) {
                this.mBuilder.setTimeToResponseInitiatedMicros(this.mTimeToResponseInitiated);
            }
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimeToResponseLastRead);
            this.mBuilder.build();
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public void mark(int readlimit) {
        this.mInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.mInputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            int bytesRead = this.mInputStream.read();
            long tempTime = this.mTimer.getDurationMicros();
            if (this.mTimeToResponseInitiated == -1L) {
                this.mTimeToResponseInitiated = tempTime;
            }
            if (bytesRead == -1 && this.mTimeToResponseLastRead == -1L) {
                this.mTimeToResponseLastRead = tempTime;
                this.mBuilder.setTimeToResponseCompletedMicros(this.mTimeToResponseLastRead);
                this.mBuilder.build();
            } else {
                ++this.mBytesRead;
                this.mBuilder.setResponsePayloadBytes(this.mBytesRead);
            }
            return bytesRead;
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        try {
            int bytesRead = this.mInputStream.read(buffer, byteOffset, byteCount);
            long tempTime = this.mTimer.getDurationMicros();
            if (this.mTimeToResponseInitiated == -1L) {
                this.mTimeToResponseInitiated = tempTime;
            }
            if (bytesRead == -1 && this.mTimeToResponseLastRead == -1L) {
                this.mTimeToResponseLastRead = tempTime;
                this.mBuilder.setTimeToResponseCompletedMicros(this.mTimeToResponseLastRead);
                this.mBuilder.build();
            } else {
                this.mBytesRead += (long)bytesRead;
                this.mBuilder.setResponsePayloadBytes(this.mBytesRead);
            }
            return bytesRead;
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        try {
            int bytesRead = this.mInputStream.read(buffer);
            long tempTime = this.mTimer.getDurationMicros();
            if (this.mTimeToResponseInitiated == -1L) {
                this.mTimeToResponseInitiated = tempTime;
            }
            if (bytesRead == -1 && this.mTimeToResponseLastRead == -1L) {
                this.mTimeToResponseLastRead = tempTime;
                this.mBuilder.setTimeToResponseCompletedMicros(this.mTimeToResponseLastRead);
                this.mBuilder.build();
            } else {
                this.mBytesRead += (long)bytesRead;
                this.mBuilder.setResponsePayloadBytes(this.mBytesRead);
            }
            return bytesRead;
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.mInputStream.reset();
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public long skip(long byteCount) throws IOException {
        try {
            long skipped = this.mInputStream.skip(byteCount);
            long tempTime = this.mTimer.getDurationMicros();
            if (this.mTimeToResponseInitiated == -1L) {
                this.mTimeToResponseInitiated = tempTime;
            }
            if (skipped == -1L && this.mTimeToResponseLastRead == -1L) {
                this.mTimeToResponseLastRead = tempTime;
                this.mBuilder.setTimeToResponseCompletedMicros(this.mTimeToResponseLastRead);
            } else {
                this.mBytesRead += skipped;
                this.mBuilder.setResponsePayloadBytes(this.mBytesRead);
            }
            return skipped;
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }
}

