/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import com.google.firebase.perf.impl.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import java.io.OutputStream;

public final class InstrHttpOutputStream
extends OutputStream {
    private OutputStream mOutputStream;
    long mBytesWritten = -1L;
    NetworkRequestMetricBuilder mBuilder;
    private final Timer mTimer;

    public InstrHttpOutputStream(OutputStream outputStream, NetworkRequestMetricBuilder builder, Timer timer) {
        this.mOutputStream = outputStream;
        this.mBuilder = builder;
        this.mTimer = timer;
    }

    @Override
    public void close() throws IOException {
        if (this.mBytesWritten != -1L) {
            this.mBuilder.setRequestPayloadBytes(this.mBytesWritten);
        }
        this.mBuilder.setTimeToRequestCompletedMicros(this.mTimer.getDurationMicros());
        try {
            this.mOutputStream.close();
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.mOutputStream.flush();
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.mOutputStream.write(b);
            ++this.mBytesWritten;
            this.mBuilder.setRequestPayloadBytes(this.mBytesWritten);
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.mOutputStream.write(b);
            this.mBytesWritten += (long)b.length;
            this.mBuilder.setRequestPayloadBytes(this.mBytesWritten);
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.mOutputStream.write(b, off, len);
            this.mBytesWritten += (long)len;
            this.mBuilder.setRequestPayloadBytes(this.mBytesWritten);
        }
        catch (IOException e) {
            this.mBuilder.setTimeToResponseCompletedMicros(this.mTimer.getDurationMicros());
            NetworkRequestMetricBuilderUtil.logError(this.mBuilder);
            throw e;
        }
    }
}

