/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.transport;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.clearcut.ClearcutLogger;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.v1.PerfMetric;

final class CctTransport {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private final Context context;
    private final String logSourceName;
    private ClearcutLogger cctLogger;

    CctTransport(Context context, String logSourceName) {
        this(context, logSourceName, null);
    }

    CctTransport(Context context, String logSourceName, ClearcutLogger cctLogger) {
        this.context = context;
        this.logSourceName = logSourceName;
        this.cctLogger = cctLogger;
    }

    @WorkerThread
    public void log(@NonNull PerfMetric perfMetric) {
        if (!this.initializeCctTransportClient()) {
            logger.warn("Unable to dispatch event because Cct Logger is not available", new Object[0]);
            return;
        }
        try {
            this.cctLogger.newEvent(perfMetric.toByteArray()).log();
            logger.info("Event is dispatched via Cct Transport", new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Dispatch with Cct Logger failed with exception: %s", e.getMessage());
        }
    }

    private boolean initializeCctTransportClient() {
        if (this.cctLogger == null) {
            try {
                this.cctLogger = ClearcutLogger.anonymousLogger((Context)this.context, (String)this.logSourceName);
            }
            catch (Exception e) {
                logger.warn("Init Cct Logger failed with exception: %s", e.getMessage());
            }
        }
        return this.cctLogger != null;
    }
}

