/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.TimeUnit;

public class Timer
implements Parcelable {
    private long mTime;
    private long mHighResTime;
    public static final Parcelable.Creator<Timer> CREATOR = new Parcelable.Creator<Timer>(){

        public Timer createFromParcel(Parcel in) {
            return new Timer(in);
        }

        public Timer[] newArray(int size) {
            return new Timer[size];
        }
    };

    public Timer() {
        this.mTime = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        this.mHighResTime = System.nanoTime();
    }

    @VisibleForTesting
    public Timer(long time) {
        this.mTime = time;
        this.mHighResTime = TimeUnit.MICROSECONDS.toNanos(time);
    }

    @VisibleForTesting
    public Timer(long time, long highResTime) {
        this.mTime = time;
        this.mHighResTime = highResTime;
    }

    private Timer(Parcel in) {
        this.mTime = in.readLong();
        this.mHighResTime = in.readLong();
    }

    public void reset() {
        this.mTime = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        this.mHighResTime = System.nanoTime();
    }

    public long getMicros() {
        return this.mTime;
    }

    public long getDurationMicros() {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - this.mHighResTime);
    }

    public long getDurationMicros(@NonNull Timer end) {
        return TimeUnit.NANOSECONDS.toMicros(end.mHighResTime - this.mHighResTime);
    }

    public long getCurrentTimestampMicros() {
        return this.mTime + this.getDurationMicros();
    }

    @VisibleForTesting
    public long getHighResTime() {
        return TimeUnit.NANOSECONDS.toMicros(this.mHighResTime);
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mTime);
        out.writeLong(this.mHighResTime);
    }

    public int describeContents() {
        return 0;
    }
}

