/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.util;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.NonNull;
import com.google.firebase.perf.logging.AndroidLogger;
import java.net.URI;

public class URLWhitelist {
    private static String[] whitelistedDomains;

    public static boolean isURLWhitelisted(@NonNull URI uri, @NonNull Context context) {
        String host;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("firebase_performance_whitelisted_domains", "array", context.getPackageName());
        if (resourceId == 0) {
            return true;
        }
        AndroidLogger.getInstance().info("Detected domain whitelist, only whitelisted domains will be measured.", new Object[0]);
        if (whitelistedDomains == null) {
            whitelistedDomains = resources.getStringArray(resourceId);
        }
        if ((host = uri.getHost()) == null) {
            return true;
        }
        for (String whitelistedDomain : whitelistedDomains) {
            if (!host.contains(whitelistedDomain)) continue;
            return true;
        }
        return false;
    }
}

