/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.v1;

import com.google.firebase.perf.v1.NetworkRequestMetricOrBuilder;
import com.google.firebase.perf.v1.PerfSession;
import com.google.firebase.perf.v1.PerfSessionOrBuilder;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntryLite;
import com.google.protobuf.MapFieldLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class NetworkRequestMetric
extends GeneratedMessageLite<NetworkRequestMetric, Builder>
implements NetworkRequestMetricOrBuilder {
    private int bitField0_;
    public static final int URL_FIELD_NUMBER = 1;
    private String url_ = "";
    public static final int HTTP_METHOD_FIELD_NUMBER = 2;
    private int httpMethod_;
    public static final int REQUEST_PAYLOAD_BYTES_FIELD_NUMBER = 3;
    private long requestPayloadBytes_;
    public static final int RESPONSE_PAYLOAD_BYTES_FIELD_NUMBER = 4;
    private long responsePayloadBytes_;
    public static final int NETWORK_CLIENT_ERROR_REASON_FIELD_NUMBER = 11;
    private int networkClientErrorReason_;
    public static final int HTTP_RESPONSE_CODE_FIELD_NUMBER = 5;
    private int httpResponseCode_;
    public static final int RESPONSE_CONTENT_TYPE_FIELD_NUMBER = 6;
    private String responseContentType_ = "";
    public static final int CLIENT_START_TIME_US_FIELD_NUMBER = 7;
    private long clientStartTimeUs_;
    public static final int TIME_TO_REQUEST_COMPLETED_US_FIELD_NUMBER = 8;
    private long timeToRequestCompletedUs_;
    public static final int TIME_TO_RESPONSE_INITIATED_US_FIELD_NUMBER = 9;
    private long timeToResponseInitiatedUs_;
    public static final int TIME_TO_RESPONSE_COMPLETED_US_FIELD_NUMBER = 10;
    private long timeToResponseCompletedUs_;
    public static final int CUSTOM_ATTRIBUTES_FIELD_NUMBER = 12;
    private MapFieldLite<String, String> customAttributes_ = MapFieldLite.emptyMapField();
    public static final int PERF_SESSIONS_FIELD_NUMBER = 13;
    private Internal.ProtobufList<PerfSession> perfSessions_ = NetworkRequestMetric.emptyProtobufList();
    private static final NetworkRequestMetric DEFAULT_INSTANCE;
    private static volatile Parser<NetworkRequestMetric> PARSER;

    private NetworkRequestMetric() {
    }

    @Override
    public boolean hasUrl() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getUrl() {
        return this.url_;
    }

    @Override
    public ByteString getUrlBytes() {
        return ByteString.copyFromUtf8((String)this.url_);
    }

    private void setUrl(String value) {
        value.getClass();
        this.bitField0_ |= 1;
        this.url_ = value;
    }

    private void clearUrl() {
        this.bitField0_ &= 0xFFFFFFFE;
        this.url_ = NetworkRequestMetric.getDefaultInstance().getUrl();
    }

    private void setUrlBytes(ByteString value) {
        this.url_ = value.toStringUtf8();
        this.bitField0_ |= 1;
    }

    @Override
    public boolean hasHttpMethod() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public HttpMethod getHttpMethod() {
        HttpMethod result = HttpMethod.forNumber(this.httpMethod_);
        return result == null ? HttpMethod.HTTP_METHOD_UNKNOWN : result;
    }

    private void setHttpMethod(HttpMethod value) {
        this.httpMethod_ = value.getNumber();
        this.bitField0_ |= 2;
    }

    private void clearHttpMethod() {
        this.bitField0_ &= 0xFFFFFFFD;
        this.httpMethod_ = 0;
    }

    @Override
    public boolean hasRequestPayloadBytes() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public long getRequestPayloadBytes() {
        return this.requestPayloadBytes_;
    }

    private void setRequestPayloadBytes(long value) {
        this.bitField0_ |= 4;
        this.requestPayloadBytes_ = value;
    }

    private void clearRequestPayloadBytes() {
        this.bitField0_ &= 0xFFFFFFFB;
        this.requestPayloadBytes_ = 0L;
    }

    @Override
    public boolean hasResponsePayloadBytes() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public long getResponsePayloadBytes() {
        return this.responsePayloadBytes_;
    }

    private void setResponsePayloadBytes(long value) {
        this.bitField0_ |= 8;
        this.responsePayloadBytes_ = value;
    }

    private void clearResponsePayloadBytes() {
        this.bitField0_ &= 0xFFFFFFF7;
        this.responsePayloadBytes_ = 0L;
    }

    @Override
    public boolean hasNetworkClientErrorReason() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public NetworkClientErrorReason getNetworkClientErrorReason() {
        NetworkClientErrorReason result = NetworkClientErrorReason.forNumber(this.networkClientErrorReason_);
        return result == null ? NetworkClientErrorReason.NETWORK_CLIENT_ERROR_REASON_UNKNOWN : result;
    }

    private void setNetworkClientErrorReason(NetworkClientErrorReason value) {
        this.networkClientErrorReason_ = value.getNumber();
        this.bitField0_ |= 0x10;
    }

    private void clearNetworkClientErrorReason() {
        this.bitField0_ &= 0xFFFFFFEF;
        this.networkClientErrorReason_ = 0;
    }

    @Override
    public boolean hasHttpResponseCode() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public int getHttpResponseCode() {
        return this.httpResponseCode_;
    }

    private void setHttpResponseCode(int value) {
        this.bitField0_ |= 0x20;
        this.httpResponseCode_ = value;
    }

    private void clearHttpResponseCode() {
        this.bitField0_ &= 0xFFFFFFDF;
        this.httpResponseCode_ = 0;
    }

    @Override
    public boolean hasResponseContentType() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public String getResponseContentType() {
        return this.responseContentType_;
    }

    @Override
    public ByteString getResponseContentTypeBytes() {
        return ByteString.copyFromUtf8((String)this.responseContentType_);
    }

    private void setResponseContentType(String value) {
        value.getClass();
        this.bitField0_ |= 0x40;
        this.responseContentType_ = value;
    }

    private void clearResponseContentType() {
        this.bitField0_ &= 0xFFFFFFBF;
        this.responseContentType_ = NetworkRequestMetric.getDefaultInstance().getResponseContentType();
    }

    private void setResponseContentTypeBytes(ByteString value) {
        this.responseContentType_ = value.toStringUtf8();
        this.bitField0_ |= 0x40;
    }

    @Override
    public boolean hasClientStartTimeUs() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public long getClientStartTimeUs() {
        return this.clientStartTimeUs_;
    }

    private void setClientStartTimeUs(long value) {
        this.bitField0_ |= 0x80;
        this.clientStartTimeUs_ = value;
    }

    private void clearClientStartTimeUs() {
        this.bitField0_ &= 0xFFFFFF7F;
        this.clientStartTimeUs_ = 0L;
    }

    @Override
    public boolean hasTimeToRequestCompletedUs() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public long getTimeToRequestCompletedUs() {
        return this.timeToRequestCompletedUs_;
    }

    private void setTimeToRequestCompletedUs(long value) {
        this.bitField0_ |= 0x100;
        this.timeToRequestCompletedUs_ = value;
    }

    private void clearTimeToRequestCompletedUs() {
        this.bitField0_ &= 0xFFFFFEFF;
        this.timeToRequestCompletedUs_ = 0L;
    }

    @Override
    public boolean hasTimeToResponseInitiatedUs() {
        return (this.bitField0_ & 0x200) != 0;
    }

    @Override
    public long getTimeToResponseInitiatedUs() {
        return this.timeToResponseInitiatedUs_;
    }

    private void setTimeToResponseInitiatedUs(long value) {
        this.bitField0_ |= 0x200;
        this.timeToResponseInitiatedUs_ = value;
    }

    private void clearTimeToResponseInitiatedUs() {
        this.bitField0_ &= 0xFFFFFDFF;
        this.timeToResponseInitiatedUs_ = 0L;
    }

    @Override
    public boolean hasTimeToResponseCompletedUs() {
        return (this.bitField0_ & 0x400) != 0;
    }

    @Override
    public long getTimeToResponseCompletedUs() {
        return this.timeToResponseCompletedUs_;
    }

    private void setTimeToResponseCompletedUs(long value) {
        this.bitField0_ |= 0x400;
        this.timeToResponseCompletedUs_ = value;
    }

    private void clearTimeToResponseCompletedUs() {
        this.bitField0_ &= 0xFFFFFBFF;
        this.timeToResponseCompletedUs_ = 0L;
    }

    private MapFieldLite<String, String> internalGetCustomAttributes() {
        return this.customAttributes_;
    }

    private MapFieldLite<String, String> internalGetMutableCustomAttributes() {
        if (!this.customAttributes_.isMutable()) {
            this.customAttributes_ = this.customAttributes_.mutableCopy();
        }
        return this.customAttributes_;
    }

    @Override
    public int getCustomAttributesCount() {
        return this.internalGetCustomAttributes().size();
    }

    @Override
    public boolean containsCustomAttributes(String key) {
        key.getClass();
        return this.internalGetCustomAttributes().containsKey((Object)key);
    }

    @Override
    @Deprecated
    public Map<String, String> getCustomAttributes() {
        return this.getCustomAttributesMap();
    }

    @Override
    public Map<String, String> getCustomAttributesMap() {
        return Collections.unmodifiableMap(this.internalGetCustomAttributes());
    }

    @Override
    public String getCustomAttributesOrDefault(String key, String defaultValue) {
        key.getClass();
        MapFieldLite<String, String> map = this.internalGetCustomAttributes();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getCustomAttributesOrThrow(String key) {
        key.getClass();
        MapFieldLite<String, String> map = this.internalGetCustomAttributes();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    private Map<String, String> getMutableCustomAttributesMap() {
        return this.internalGetMutableCustomAttributes();
    }

    @Override
    public List<PerfSession> getPerfSessionsList() {
        return this.perfSessions_;
    }

    public List<? extends PerfSessionOrBuilder> getPerfSessionsOrBuilderList() {
        return this.perfSessions_;
    }

    @Override
    public int getPerfSessionsCount() {
        return this.perfSessions_.size();
    }

    @Override
    public PerfSession getPerfSessions(int index) {
        return (PerfSession)this.perfSessions_.get(index);
    }

    public PerfSessionOrBuilder getPerfSessionsOrBuilder(int index) {
        return (PerfSessionOrBuilder)this.perfSessions_.get(index);
    }

    private void ensurePerfSessionsIsMutable() {
        if (!this.perfSessions_.isModifiable()) {
            this.perfSessions_ = GeneratedMessageLite.mutableCopy(this.perfSessions_);
        }
    }

    private void setPerfSessions(int index, PerfSession value) {
        value.getClass();
        this.ensurePerfSessionsIsMutable();
        this.perfSessions_.set(index, (Object)value);
    }

    private void addPerfSessions(PerfSession value) {
        value.getClass();
        this.ensurePerfSessionsIsMutable();
        this.perfSessions_.add((Object)value);
    }

    private void addPerfSessions(int index, PerfSession value) {
        value.getClass();
        this.ensurePerfSessionsIsMutable();
        this.perfSessions_.add(index, (Object)value);
    }

    private void addAllPerfSessions(Iterable<? extends PerfSession> values) {
        this.ensurePerfSessionsIsMutable();
        AbstractMessageLite.addAll(values, this.perfSessions_);
    }

    private void clearPerfSessions() {
        this.perfSessions_ = NetworkRequestMetric.emptyProtobufList();
    }

    private void removePerfSessions(int index) {
        this.ensurePerfSessionsIsMutable();
        this.perfSessions_.remove(index);
    }

    public static NetworkRequestMetric parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data);
    }

    public static NetworkRequestMetric parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteBuffer)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkRequestMetric parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data);
    }

    public static NetworkRequestMetric parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkRequestMetric parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data);
    }

    public static NetworkRequestMetric parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkRequestMetric parseFrom(InputStream input) throws IOException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static NetworkRequestMetric parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkRequestMetric parseDelimitedFrom(InputStream input) throws IOException {
        return (NetworkRequestMetric)NetworkRequestMetric.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static NetworkRequestMetric parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NetworkRequestMetric)NetworkRequestMetric.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkRequestMetric parseFrom(CodedInputStream input) throws IOException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input);
    }

    public static NetworkRequestMetric parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NetworkRequestMetric)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Builder newBuilder() {
        return (Builder)DEFAULT_INSTANCE.createBuilder();
    }

    public static Builder newBuilder(NetworkRequestMetric prototype) {
        return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
        switch (method) {
            case NEW_MUTABLE_INSTANCE: {
                return new NetworkRequestMetric();
            }
            case NEW_BUILDER: {
                return new Builder();
            }
            case BUILD_MESSAGE_INFO: {
                Object[] objects = new Object[]{"bitField0_", "url_", "httpMethod_", HttpMethod.internalGetVerifier(), "requestPayloadBytes_", "responsePayloadBytes_", "httpResponseCode_", "responseContentType_", "clientStartTimeUs_", "timeToRequestCompletedUs_", "timeToResponseInitiatedUs_", "timeToResponseCompletedUs_", "networkClientErrorReason_", NetworkClientErrorReason.internalGetVerifier(), "customAttributes_", CustomAttributesDefaultEntryHolder.defaultEntry, "perfSessions_", PerfSession.class};
                String info = "\u0001\r\u0000\u0001\u0001\r\r\u0001\u0001\u0000\u0001\b\u0000\u0002\f\u0001\u0003\u0002\u0002\u0004\u0002\u0003\u0005\u0004\u0005\u0006\b\u0006\u0007\u0002\u0007\b\u0002\b\t\u0002\t\n\u0002\n\u000b\f\u0004\f2\r\u001b";
                return NetworkRequestMetric.newMessageInfo((MessageLite)DEFAULT_INSTANCE, (String)info, (Object[])objects);
            }
            case GET_DEFAULT_INSTANCE: {
                return DEFAULT_INSTANCE;
            }
            case GET_PARSER: {
                GeneratedMessageLite.DefaultInstanceBasedParser parser = PARSER;
                if (parser != null) return parser;
                Class<NetworkRequestMetric> clazz = NetworkRequestMetric.class;
                synchronized (NetworkRequestMetric.class) {
                    parser = PARSER;
                    if (parser != null) return parser;
                    PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser((GeneratedMessageLite)DEFAULT_INSTANCE);
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    return parser;
                }
            }
            case GET_MEMOIZED_IS_INITIALIZED: {
                return (byte)1;
            }
            case SET_MEMOIZED_IS_INITIALIZED: {
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static NetworkRequestMetric getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<NetworkRequestMetric> parser() {
        return DEFAULT_INSTANCE.getParserForType();
    }

    static {
        NetworkRequestMetric defaultInstance;
        DEFAULT_INSTANCE = defaultInstance = new NetworkRequestMetric();
        GeneratedMessageLite.registerDefaultInstance(NetworkRequestMetric.class, (GeneratedMessageLite)defaultInstance);
    }

    public static final class Builder
    extends GeneratedMessageLite.Builder<NetworkRequestMetric, Builder>
    implements NetworkRequestMetricOrBuilder {
        private Builder() {
            super((GeneratedMessageLite)DEFAULT_INSTANCE);
        }

        @Override
        public boolean hasUrl() {
            return ((NetworkRequestMetric)this.instance).hasUrl();
        }

        @Override
        public String getUrl() {
            return ((NetworkRequestMetric)this.instance).getUrl();
        }

        @Override
        public ByteString getUrlBytes() {
            return ((NetworkRequestMetric)this.instance).getUrlBytes();
        }

        public Builder setUrl(String value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setUrl(value);
            return this;
        }

        public Builder clearUrl() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearUrl();
            return this;
        }

        public Builder setUrlBytes(ByteString value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setUrlBytes(value);
            return this;
        }

        @Override
        public boolean hasHttpMethod() {
            return ((NetworkRequestMetric)this.instance).hasHttpMethod();
        }

        @Override
        public HttpMethod getHttpMethod() {
            return ((NetworkRequestMetric)this.instance).getHttpMethod();
        }

        public Builder setHttpMethod(HttpMethod value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setHttpMethod(value);
            return this;
        }

        public Builder clearHttpMethod() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearHttpMethod();
            return this;
        }

        @Override
        public boolean hasRequestPayloadBytes() {
            return ((NetworkRequestMetric)this.instance).hasRequestPayloadBytes();
        }

        @Override
        public long getRequestPayloadBytes() {
            return ((NetworkRequestMetric)this.instance).getRequestPayloadBytes();
        }

        public Builder setRequestPayloadBytes(long value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setRequestPayloadBytes(value);
            return this;
        }

        public Builder clearRequestPayloadBytes() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearRequestPayloadBytes();
            return this;
        }

        @Override
        public boolean hasResponsePayloadBytes() {
            return ((NetworkRequestMetric)this.instance).hasResponsePayloadBytes();
        }

        @Override
        public long getResponsePayloadBytes() {
            return ((NetworkRequestMetric)this.instance).getResponsePayloadBytes();
        }

        public Builder setResponsePayloadBytes(long value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setResponsePayloadBytes(value);
            return this;
        }

        public Builder clearResponsePayloadBytes() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearResponsePayloadBytes();
            return this;
        }

        @Override
        public boolean hasNetworkClientErrorReason() {
            return ((NetworkRequestMetric)this.instance).hasNetworkClientErrorReason();
        }

        @Override
        public NetworkClientErrorReason getNetworkClientErrorReason() {
            return ((NetworkRequestMetric)this.instance).getNetworkClientErrorReason();
        }

        public Builder setNetworkClientErrorReason(NetworkClientErrorReason value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setNetworkClientErrorReason(value);
            return this;
        }

        public Builder clearNetworkClientErrorReason() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearNetworkClientErrorReason();
            return this;
        }

        @Override
        public boolean hasHttpResponseCode() {
            return ((NetworkRequestMetric)this.instance).hasHttpResponseCode();
        }

        @Override
        public int getHttpResponseCode() {
            return ((NetworkRequestMetric)this.instance).getHttpResponseCode();
        }

        public Builder setHttpResponseCode(int value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setHttpResponseCode(value);
            return this;
        }

        public Builder clearHttpResponseCode() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearHttpResponseCode();
            return this;
        }

        @Override
        public boolean hasResponseContentType() {
            return ((NetworkRequestMetric)this.instance).hasResponseContentType();
        }

        @Override
        public String getResponseContentType() {
            return ((NetworkRequestMetric)this.instance).getResponseContentType();
        }

        @Override
        public ByteString getResponseContentTypeBytes() {
            return ((NetworkRequestMetric)this.instance).getResponseContentTypeBytes();
        }

        public Builder setResponseContentType(String value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setResponseContentType(value);
            return this;
        }

        public Builder clearResponseContentType() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearResponseContentType();
            return this;
        }

        public Builder setResponseContentTypeBytes(ByteString value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setResponseContentTypeBytes(value);
            return this;
        }

        @Override
        public boolean hasClientStartTimeUs() {
            return ((NetworkRequestMetric)this.instance).hasClientStartTimeUs();
        }

        @Override
        public long getClientStartTimeUs() {
            return ((NetworkRequestMetric)this.instance).getClientStartTimeUs();
        }

        public Builder setClientStartTimeUs(long value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setClientStartTimeUs(value);
            return this;
        }

        public Builder clearClientStartTimeUs() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearClientStartTimeUs();
            return this;
        }

        @Override
        public boolean hasTimeToRequestCompletedUs() {
            return ((NetworkRequestMetric)this.instance).hasTimeToRequestCompletedUs();
        }

        @Override
        public long getTimeToRequestCompletedUs() {
            return ((NetworkRequestMetric)this.instance).getTimeToRequestCompletedUs();
        }

        public Builder setTimeToRequestCompletedUs(long value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setTimeToRequestCompletedUs(value);
            return this;
        }

        public Builder clearTimeToRequestCompletedUs() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearTimeToRequestCompletedUs();
            return this;
        }

        @Override
        public boolean hasTimeToResponseInitiatedUs() {
            return ((NetworkRequestMetric)this.instance).hasTimeToResponseInitiatedUs();
        }

        @Override
        public long getTimeToResponseInitiatedUs() {
            return ((NetworkRequestMetric)this.instance).getTimeToResponseInitiatedUs();
        }

        public Builder setTimeToResponseInitiatedUs(long value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setTimeToResponseInitiatedUs(value);
            return this;
        }

        public Builder clearTimeToResponseInitiatedUs() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearTimeToResponseInitiatedUs();
            return this;
        }

        @Override
        public boolean hasTimeToResponseCompletedUs() {
            return ((NetworkRequestMetric)this.instance).hasTimeToResponseCompletedUs();
        }

        @Override
        public long getTimeToResponseCompletedUs() {
            return ((NetworkRequestMetric)this.instance).getTimeToResponseCompletedUs();
        }

        public Builder setTimeToResponseCompletedUs(long value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setTimeToResponseCompletedUs(value);
            return this;
        }

        public Builder clearTimeToResponseCompletedUs() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearTimeToResponseCompletedUs();
            return this;
        }

        @Override
        public int getCustomAttributesCount() {
            return ((NetworkRequestMetric)this.instance).getCustomAttributesMap().size();
        }

        @Override
        public boolean containsCustomAttributes(String key) {
            key.getClass();
            return ((NetworkRequestMetric)this.instance).getCustomAttributesMap().containsKey(key);
        }

        public Builder clearCustomAttributes() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).getMutableCustomAttributesMap().clear();
            return this;
        }

        public Builder removeCustomAttributes(String key) {
            key.getClass();
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).getMutableCustomAttributesMap().remove(key);
            return this;
        }

        @Override
        @Deprecated
        public Map<String, String> getCustomAttributes() {
            return this.getCustomAttributesMap();
        }

        @Override
        public Map<String, String> getCustomAttributesMap() {
            return Collections.unmodifiableMap(((NetworkRequestMetric)this.instance).getCustomAttributesMap());
        }

        @Override
        public String getCustomAttributesOrDefault(String key, String defaultValue) {
            key.getClass();
            Map<String, String> map = ((NetworkRequestMetric)this.instance).getCustomAttributesMap();
            return map.containsKey(key) ? map.get(key) : defaultValue;
        }

        @Override
        public String getCustomAttributesOrThrow(String key) {
            key.getClass();
            Map<String, String> map = ((NetworkRequestMetric)this.instance).getCustomAttributesMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return map.get(key);
        }

        public Builder putCustomAttributes(String key, String value) {
            key.getClass();
            value.getClass();
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).getMutableCustomAttributesMap().put(key, value);
            return this;
        }

        public Builder putAllCustomAttributes(Map<String, String> values) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).getMutableCustomAttributesMap().putAll(values);
            return this;
        }

        @Override
        public List<PerfSession> getPerfSessionsList() {
            return Collections.unmodifiableList(((NetworkRequestMetric)this.instance).getPerfSessionsList());
        }

        @Override
        public int getPerfSessionsCount() {
            return ((NetworkRequestMetric)this.instance).getPerfSessionsCount();
        }

        @Override
        public PerfSession getPerfSessions(int index) {
            return ((NetworkRequestMetric)this.instance).getPerfSessions(index);
        }

        public Builder setPerfSessions(int index, PerfSession value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setPerfSessions(index, value);
            return this;
        }

        public Builder setPerfSessions(int index, PerfSession.Builder builderForValue) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).setPerfSessions(index, (PerfSession)builderForValue.build());
            return this;
        }

        public Builder addPerfSessions(PerfSession value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).addPerfSessions(value);
            return this;
        }

        public Builder addPerfSessions(int index, PerfSession value) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).addPerfSessions(index, value);
            return this;
        }

        public Builder addPerfSessions(PerfSession.Builder builderForValue) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).addPerfSessions((PerfSession)builderForValue.build());
            return this;
        }

        public Builder addPerfSessions(int index, PerfSession.Builder builderForValue) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).addPerfSessions(index, (PerfSession)builderForValue.build());
            return this;
        }

        public Builder addAllPerfSessions(Iterable<? extends PerfSession> values) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).addAllPerfSessions(values);
            return this;
        }

        public Builder clearPerfSessions() {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).clearPerfSessions();
            return this;
        }

        public Builder removePerfSessions(int index) {
            this.copyOnWrite();
            ((NetworkRequestMetric)this.instance).removePerfSessions(index);
            return this;
        }
    }

    private static final class CustomAttributesDefaultEntryHolder {
        static final MapEntryLite<String, String> defaultEntry = MapEntryLite.newDefaultInstance((WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private CustomAttributesDefaultEntryHolder() {
        }
    }

    public static enum NetworkClientErrorReason implements Internal.EnumLite
    {
        NETWORK_CLIENT_ERROR_REASON_UNKNOWN(0),
        GENERIC_CLIENT_ERROR(1);

        public static final int NETWORK_CLIENT_ERROR_REASON_UNKNOWN_VALUE = 0;
        public static final int GENERIC_CLIENT_ERROR_VALUE = 1;
        private static final Internal.EnumLiteMap<NetworkClientErrorReason> internalValueMap;
        private final int value;

        public final int getNumber() {
            return this.value;
        }

        @Deprecated
        public static NetworkClientErrorReason valueOf(int value) {
            return NetworkClientErrorReason.forNumber(value);
        }

        public static NetworkClientErrorReason forNumber(int value) {
            switch (value) {
                case 0: {
                    return NETWORK_CLIENT_ERROR_REASON_UNKNOWN;
                }
                case 1: {
                    return GENERIC_CLIENT_ERROR;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<NetworkClientErrorReason> internalGetValueMap() {
            return internalValueMap;
        }

        public static Internal.EnumVerifier internalGetVerifier() {
            return NetworkClientErrorReasonVerifier.INSTANCE;
        }

        private NetworkClientErrorReason(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<NetworkClientErrorReason>(){

                public NetworkClientErrorReason findValueByNumber(int number) {
                    return NetworkClientErrorReason.forNumber(number);
                }
            };
        }

        private static final class NetworkClientErrorReasonVerifier
        implements Internal.EnumVerifier {
            static final Internal.EnumVerifier INSTANCE = new NetworkClientErrorReasonVerifier();

            private NetworkClientErrorReasonVerifier() {
            }

            public boolean isInRange(int number) {
                return NetworkClientErrorReason.forNumber(number) != null;
            }
        }
    }

    public static enum HttpMethod implements Internal.EnumLite
    {
        HTTP_METHOD_UNKNOWN(0),
        GET(1),
        PUT(2),
        POST(3),
        DELETE(4),
        HEAD(5),
        PATCH(6),
        OPTIONS(7),
        TRACE(8),
        CONNECT(9);

        public static final int HTTP_METHOD_UNKNOWN_VALUE = 0;
        public static final int GET_VALUE = 1;
        public static final int PUT_VALUE = 2;
        public static final int POST_VALUE = 3;
        public static final int DELETE_VALUE = 4;
        public static final int HEAD_VALUE = 5;
        public static final int PATCH_VALUE = 6;
        public static final int OPTIONS_VALUE = 7;
        public static final int TRACE_VALUE = 8;
        public static final int CONNECT_VALUE = 9;
        private static final Internal.EnumLiteMap<HttpMethod> internalValueMap;
        private final int value;

        public final int getNumber() {
            return this.value;
        }

        @Deprecated
        public static HttpMethod valueOf(int value) {
            return HttpMethod.forNumber(value);
        }

        public static HttpMethod forNumber(int value) {
            switch (value) {
                case 0: {
                    return HTTP_METHOD_UNKNOWN;
                }
                case 1: {
                    return GET;
                }
                case 2: {
                    return PUT;
                }
                case 3: {
                    return POST;
                }
                case 4: {
                    return DELETE;
                }
                case 5: {
                    return HEAD;
                }
                case 6: {
                    return PATCH;
                }
                case 7: {
                    return OPTIONS;
                }
                case 8: {
                    return TRACE;
                }
                case 9: {
                    return CONNECT;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<HttpMethod> internalGetValueMap() {
            return internalValueMap;
        }

        public static Internal.EnumVerifier internalGetVerifier() {
            return HttpMethodVerifier.INSTANCE;
        }

        private HttpMethod(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<HttpMethod>(){

                public HttpMethod findValueByNumber(int number) {
                    return HttpMethod.forNumber(number);
                }
            };
        }

        private static final class HttpMethodVerifier
        implements Internal.EnumVerifier {
            static final Internal.EnumVerifier INSTANCE = new HttpMethodVerifier();

            private HttpMethodVerifier() {
            }

            public boolean isInRange(int number) {
                return HttpMethod.forNumber(number) != null;
            }
        }
    }
}

