/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.network;

import com.google.firebase.perf.metrics.NetworkRequestMetricBuilder;
import com.google.firebase.perf.network.NetworkRequestMetricBuilderUtil;
import com.google.firebase.perf.util.Timer;
import java.io.IOException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

public class InstrumentApacheHttpResponseHandler<T>
implements ResponseHandler<T> {
    private final ResponseHandler<? extends T> responseHandlerDelegate;
    private final Timer timer;
    private final NetworkRequestMetricBuilder networkMetricBuilder;

    public InstrumentApacheHttpResponseHandler(ResponseHandler<? extends T> responseHandler, Timer timer, NetworkRequestMetricBuilder builder) {
        this.responseHandlerDelegate = responseHandler;
        this.timer = timer;
        this.networkMetricBuilder = builder;
    }

    public T handleResponse(HttpResponse httpResponse) throws IOException {
        String contentType;
        this.networkMetricBuilder.setTimeToResponseCompletedMicros(this.timer.getDurationMicros());
        this.networkMetricBuilder.setHttpResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long responseContentLength = NetworkRequestMetricBuilderUtil.getApacheHttpMessageContentLength((HttpMessage)httpResponse);
        if (responseContentLength != null) {
            this.networkMetricBuilder.setResponsePayloadBytes(responseContentLength);
        }
        if ((contentType = NetworkRequestMetricBuilderUtil.getApacheHttpResponseContentType(httpResponse)) != null) {
            this.networkMetricBuilder.setResponseContentType(contentType);
        }
        this.networkMetricBuilder.build();
        return (T)this.responseHandlerDelegate.handleResponse(httpResponse);
    }
}

