/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.session.gauges;

import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.session.PerfSession;
import com.google.firebase.perf.session.gauges.CpuGaugeCollector;
import com.google.firebase.perf.session.gauges.GaugeMetadataManager;
import com.google.firebase.perf.session.gauges.MemoryGaugeCollector;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.v1.ApplicationProcessState;
import com.google.firebase.perf.v1.GaugeMetadata;
import com.google.firebase.perf.v1.GaugeMetric;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Keep
public class GaugeManager {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final GaugeManager instance = new GaugeManager();
    private static final long TIME_TO_WAIT_BEFORE_FLUSHING_GAUGES_QUEUE_MS = 20L;
    private static final long APPROX_NUMBER_OF_DATA_POINTS_PER_GAUGE_METRIC = 20L;
    private static final long INVALID_GAUGE_COLLECTION_FREQUENCY = -1L;
    private final ScheduledExecutorService gaugeManagerExecutor;
    private final ConfigResolver configResolver;
    private final CpuGaugeCollector cpuGaugeCollector;
    private final MemoryGaugeCollector memoryGaugeCollector;
    private final TransportManager transportManager;
    @Nullable
    private GaugeMetadataManager gaugeMetadataManager;
    @Nullable
    private ScheduledFuture gaugeManagerDataCollectionJob = null;
    @Nullable
    private String sessionId = null;
    private ApplicationProcessState applicationProcessState = ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN;

    private GaugeManager() {
        this(Executors.newSingleThreadScheduledExecutor(), TransportManager.getInstance(), ConfigResolver.getInstance(), null, CpuGaugeCollector.getInstance(), MemoryGaugeCollector.getInstance());
    }

    @VisibleForTesting
    GaugeManager(ScheduledExecutorService gaugeManagerExecutor, TransportManager transportManager, ConfigResolver configResolver, GaugeMetadataManager gaugeMetadataManager, CpuGaugeCollector cpuGaugeCollector, MemoryGaugeCollector memoryGaugeCollector) {
        this.gaugeManagerExecutor = gaugeManagerExecutor;
        this.transportManager = transportManager;
        this.configResolver = configResolver;
        this.gaugeMetadataManager = gaugeMetadataManager;
        this.cpuGaugeCollector = cpuGaugeCollector;
        this.memoryGaugeCollector = memoryGaugeCollector;
    }

    public void setApplicationContext(Context appContext) {
        this.gaugeMetadataManager = new GaugeMetadataManager(appContext);
    }

    public static synchronized GaugeManager getInstance() {
        return instance;
    }

    public void startCollectingGauges(PerfSession session, ApplicationProcessState applicationProcessState) {
        long collectionFrequency;
        if (this.sessionId != null) {
            this.stopCollectingGauges();
        }
        if ((collectionFrequency = this.startCollectingGauges(applicationProcessState, session.getTimer())) == -1L) {
            logger.warn("Invalid gauge collection frequency. Unable to start collecting Gauges.");
            return;
        }
        this.sessionId = session.sessionId();
        this.applicationProcessState = applicationProcessState;
        String sessionIdForScheduledTask = this.sessionId;
        ApplicationProcessState applicationProcessStateForScheduledTask = applicationProcessState;
        try {
            this.gaugeManagerDataCollectionJob = this.gaugeManagerExecutor.scheduleAtFixedRate(() -> this.syncFlush(sessionIdForScheduledTask, applicationProcessStateForScheduledTask), collectionFrequency * 20L, collectionFrequency * 20L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            logger.warn("Unable to start collecting Gauges: " + e.getMessage());
        }
    }

    private long startCollectingGauges(ApplicationProcessState appState, Timer referenceTime) {
        long memoryMetricCollectionFrequency;
        long collectionFrequency = -1L;
        long cpuMetricCollectionFrequency = this.getCpuGaugeCollectionFrequencyMs(appState);
        if (this.startCollectingCpuMetrics(cpuMetricCollectionFrequency, referenceTime)) {
            collectionFrequency = cpuMetricCollectionFrequency;
        }
        if (this.startCollectingMemoryMetrics(memoryMetricCollectionFrequency = this.getMemoryGaugeCollectionFrequencyMs(appState), referenceTime)) {
            collectionFrequency = collectionFrequency == -1L ? memoryMetricCollectionFrequency : Math.min(collectionFrequency, memoryMetricCollectionFrequency);
        }
        return collectionFrequency;
    }

    public void stopCollectingGauges() {
        if (this.sessionId == null) {
            return;
        }
        String sessionIdForScheduledTask = this.sessionId;
        ApplicationProcessState applicationProcessStateForScheduledTask = this.applicationProcessState;
        this.cpuGaugeCollector.stopCollecting();
        this.memoryGaugeCollector.stopCollecting();
        if (this.gaugeManagerDataCollectionJob != null) {
            this.gaugeManagerDataCollectionJob.cancel(false);
        }
        ScheduledFuture<?> unusedFuture = this.gaugeManagerExecutor.schedule(() -> this.syncFlush(sessionIdForScheduledTask, applicationProcessStateForScheduledTask), 20L, TimeUnit.MILLISECONDS);
        this.sessionId = null;
        this.applicationProcessState = ApplicationProcessState.APPLICATION_PROCESS_STATE_UNKNOWN;
    }

    private void syncFlush(String sessionId, ApplicationProcessState appState) {
        GaugeMetric.Builder gaugeMetricBuilder = GaugeMetric.newBuilder();
        while (!this.cpuGaugeCollector.cpuMetricReadings.isEmpty()) {
            gaugeMetricBuilder.addCpuMetricReadings(this.cpuGaugeCollector.cpuMetricReadings.poll());
        }
        while (!this.memoryGaugeCollector.memoryMetricReadings.isEmpty()) {
            gaugeMetricBuilder.addAndroidMemoryReadings(this.memoryGaugeCollector.memoryMetricReadings.poll());
        }
        gaugeMetricBuilder.setSessionId(sessionId);
        this.transportManager.log((GaugeMetric)gaugeMetricBuilder.build(), appState);
    }

    public boolean logGaugeMetadata(String sessionId, ApplicationProcessState appState) {
        if (this.gaugeMetadataManager != null) {
            GaugeMetric gaugeMetric = (GaugeMetric)GaugeMetric.newBuilder().setSessionId(sessionId).setGaugeMetadata(this.getGaugeMetadata()).build();
            this.transportManager.log(gaugeMetric, appState);
            return true;
        }
        return false;
    }

    private GaugeMetadata getGaugeMetadata() {
        return (GaugeMetadata)GaugeMetadata.newBuilder().setProcessName(this.gaugeMetadataManager.getProcessName()).setDeviceRamSizeKb(this.gaugeMetadataManager.getDeviceRamSizeKb()).setMaxAppJavaHeapMemoryKb(this.gaugeMetadataManager.getMaxAppJavaHeapMemoryKb()).setMaxEncouragedAppJavaHeapMemoryKb(this.gaugeMetadataManager.getMaxEncouragedAppJavaHeapMemoryKb()).build();
    }

    private boolean startCollectingCpuMetrics(long cpuMetricCollectionFrequency, Timer referenceTime) {
        if (cpuMetricCollectionFrequency == -1L) {
            logger.debug("Invalid Cpu Metrics collection frequency. Did not collect Cpu Metrics.");
            return false;
        }
        this.cpuGaugeCollector.startCollecting(cpuMetricCollectionFrequency, referenceTime);
        return true;
    }

    private boolean startCollectingMemoryMetrics(long memoryMetricCollectionFrequency, Timer referenceTime) {
        if (memoryMetricCollectionFrequency == -1L) {
            logger.debug("Invalid Memory Metrics collection frequency. Did not collect Memory Metrics.");
            return false;
        }
        this.memoryGaugeCollector.startCollecting(memoryMetricCollectionFrequency, referenceTime);
        return true;
    }

    public void collectGaugeMetricOnce(Timer referenceTime) {
        GaugeManager.collectGaugeMetricOnce(this.cpuGaugeCollector, this.memoryGaugeCollector, referenceTime);
    }

    private static void collectGaugeMetricOnce(CpuGaugeCollector cpuGaugeCollector, MemoryGaugeCollector memoryGaugeCollector, Timer referenceTime) {
        cpuGaugeCollector.collectOnce(referenceTime);
        memoryGaugeCollector.collectOnce(referenceTime);
    }

    private long getCpuGaugeCollectionFrequencyMs(ApplicationProcessState applicationProcessState) {
        long cpuGaugeCollectionFrequency;
        switch (applicationProcessState) {
            case BACKGROUND: {
                cpuGaugeCollectionFrequency = this.configResolver.getSessionsCpuCaptureFrequencyBackgroundMs();
                break;
            }
            case FOREGROUND: {
                cpuGaugeCollectionFrequency = this.configResolver.getSessionsCpuCaptureFrequencyForegroundMs();
                break;
            }
            default: {
                cpuGaugeCollectionFrequency = -1L;
            }
        }
        if (CpuGaugeCollector.isInvalidCollectionFrequency(cpuGaugeCollectionFrequency)) {
            return -1L;
        }
        return cpuGaugeCollectionFrequency;
    }

    private long getMemoryGaugeCollectionFrequencyMs(ApplicationProcessState applicationProcessState) {
        long memoryGaugeCollectionFrequency;
        switch (applicationProcessState) {
            case BACKGROUND: {
                memoryGaugeCollectionFrequency = this.configResolver.getSessionsMemoryCaptureFrequencyBackgroundMs();
                break;
            }
            case FOREGROUND: {
                memoryGaugeCollectionFrequency = this.configResolver.getSessionsMemoryCaptureFrequencyForegroundMs();
                break;
            }
            default: {
                memoryGaugeCollectionFrequency = -1L;
            }
        }
        if (MemoryGaugeCollector.isInvalidCollectionFrequency(memoryGaugeCollectionFrequency)) {
            return -1L;
        }
        return memoryGaugeCollectionFrequency;
    }
}

