/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.application;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.core.app.FrameMetricsAggregator;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.firebase.perf.config.ConfigResolver;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.Trace;
import com.google.firebase.perf.session.SessionManager;
import com.google.firebase.perf.transport.TransportManager;
import com.google.firebase.perf.util.Clock;
import com.google.firebase.perf.util.Constants;
import com.google.firebase.perf.util.Timer;
import com.google.firebase.perf.util.Utils;
import com.google.firebase.perf.v1.ApplicationProcessState;
import com.google.firebase.perf.v1.TraceMetric;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class AppStateMonitor
implements Application.ActivityLifecycleCallbacks {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final String FRAME_METRICS_AGGREGATOR_CLASSNAME = "androidx.core.app.FrameMetricsAggregator";
    private static volatile AppStateMonitor instance;
    private final WeakHashMap<Activity, Boolean> activityToResumedMap = new WeakHashMap();
    private final WeakHashMap<Activity, Trace> activityToScreenTraceMap = new WeakHashMap();
    private final Map<String, Long> metricToCountMap = new HashMap<String, Long>();
    private final Set<WeakReference<AppStateCallback>> appStateSubscribers = new HashSet<WeakReference<AppStateCallback>>();
    private Set<AppColdStartCallback> appColdStartSubscribers = new HashSet<AppColdStartCallback>();
    private final AtomicInteger tsnsCount = new AtomicInteger(0);
    private final TransportManager transportManager;
    private final ConfigResolver configResolver;
    private final Clock clock;
    private FrameMetricsAggregator frameMetricsAggregator;
    private Timer resumeTime;
    private Timer stopTime;
    private ApplicationProcessState currentAppState = ApplicationProcessState.BACKGROUND;
    private boolean isRegisteredForLifecycleCallbacks = false;
    private boolean isColdStart = true;
    private boolean hasFrameMetricsAggregator = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppStateMonitor getInstance() {
        if (instance != null) return instance;
        Class<AppStateMonitor> clazz = AppStateMonitor.class;
        synchronized (AppStateMonitor.class) {
            if (instance != null) return instance;
            instance = new AppStateMonitor(TransportManager.getInstance(), new Clock());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    AppStateMonitor(TransportManager transportManager, Clock clock) {
        this.transportManager = transportManager;
        this.clock = clock;
        this.configResolver = ConfigResolver.getInstance();
        this.hasFrameMetricsAggregator = this.hasFrameMetricsAggregatorClass();
        if (this.hasFrameMetricsAggregator) {
            this.frameMetricsAggregator = new FrameMetricsAggregator();
        }
    }

    public synchronized void registerActivityLifecycleCallbacks(Context context) {
        if (this.isRegisteredForLifecycleCallbacks) {
            return;
        }
        Context appContext = context.getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.isRegisteredForLifecycleCallbacks = true;
        }
    }

    public synchronized void unregisterActivityLifecycleCallbacks(Context context) {
        if (!this.isRegisteredForLifecycleCallbacks) {
            return;
        }
        Context appContext = context.getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.isRegisteredForLifecycleCallbacks = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCount(@NonNull String name, long value) {
        Map<String, Long> map = this.metricToCountMap;
        synchronized (map) {
            Long v = this.metricToCountMap.get(name);
            if (v == null) {
                this.metricToCountMap.put(name, value);
            } else {
                this.metricToCountMap.put(name, v + value);
            }
        }
    }

    public void incrementTsnsCount(int value) {
        this.tsnsCount.addAndGet(value);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public synchronized void onActivityStarted(Activity activity) {
        if (this.isScreenTraceSupported(activity) && this.configResolver.isPerformanceMonitoringEnabled()) {
            this.frameMetricsAggregator.add(activity);
            Trace screenTrace = new Trace(AppStateMonitor.getScreenTraceName(activity), this.transportManager, this.clock, this);
            screenTrace.start();
            this.activityToScreenTraceMap.put(activity, screenTrace);
        }
    }

    public synchronized void onActivityStopped(Activity activity) {
        if (this.isScreenTraceSupported(activity)) {
            this.sendScreenTrace(activity);
        }
        if (this.activityToResumedMap.containsKey(activity)) {
            this.activityToResumedMap.remove(activity);
            if (this.activityToResumedMap.isEmpty()) {
                this.stopTime = this.clock.getTime();
                this.sendSessionLog(Constants.TraceNames.FOREGROUND_TRACE_NAME.toString(), this.resumeTime, this.stopTime);
                this.updateAppState(ApplicationProcessState.BACKGROUND);
            }
        }
    }

    public synchronized void onActivityResumed(Activity activity) {
        if (this.activityToResumedMap.isEmpty()) {
            this.resumeTime = this.clock.getTime();
            this.activityToResumedMap.put(activity, true);
            if (this.isColdStart) {
                this.updateAppState(ApplicationProcessState.FOREGROUND);
                this.sendAppColdStartUpdate();
                this.isColdStart = false;
            } else {
                this.sendSessionLog(Constants.TraceNames.BACKGROUND_TRACE_NAME.toString(), this.stopTime, this.resumeTime);
                this.updateAppState(ApplicationProcessState.FOREGROUND);
            }
        } else {
            this.activityToResumedMap.put(activity, true);
        }
    }

    public boolean isColdStart() {
        return this.isColdStart;
    }

    public ApplicationProcessState getAppState() {
        return this.currentAppState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForAppState(WeakReference<AppStateCallback> subscriber) {
        Set<WeakReference<AppStateCallback>> set = this.appStateSubscribers;
        synchronized (set) {
            this.appStateSubscribers.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForAppState(WeakReference<AppStateCallback> subscriber) {
        Set<WeakReference<AppStateCallback>> set = this.appStateSubscribers;
        synchronized (set) {
            this.appStateSubscribers.remove(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForAppColdStart(AppColdStartCallback subscriber) {
        Set<WeakReference<AppStateCallback>> set = this.appStateSubscribers;
        synchronized (set) {
            this.appColdStartSubscribers.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppState(ApplicationProcessState newState) {
        this.currentAppState = newState;
        Set<WeakReference<AppStateCallback>> set = this.appStateSubscribers;
        synchronized (set) {
            Iterator<WeakReference<AppStateCallback>> i = this.appStateSubscribers.iterator();
            while (i.hasNext()) {
                AppStateCallback callback = (AppStateCallback)i.next().get();
                if (callback != null) {
                    callback.onUpdateAppState(this.currentAppState);
                    continue;
                }
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAppColdStartUpdate() {
        Set<WeakReference<AppStateCallback>> set = this.appStateSubscribers;
        synchronized (set) {
            for (AppColdStartCallback callback : this.appColdStartSubscribers) {
                if (callback == null) continue;
                callback.onAppColdStart();
            }
        }
    }

    public boolean isForeground() {
        return this.currentAppState == ApplicationProcessState.FOREGROUND;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityPaused(Activity activity) {
    }

    private void sendScreenTrace(Activity activity) {
        SparseIntArray frameTimes;
        if (!this.activityToScreenTraceMap.containsKey(activity)) {
            return;
        }
        Trace screenTrace = this.activityToScreenTraceMap.get(activity);
        if (screenTrace == null) {
            return;
        }
        this.activityToScreenTraceMap.remove(activity);
        int totalFrames = 0;
        int slowFrames = 0;
        int frozenFrames = 0;
        SparseIntArray[] arr = this.frameMetricsAggregator.reset();
        if (arr != null && (frameTimes = arr[0]) != null) {
            for (int i = 0; i < frameTimes.size(); ++i) {
                int frameTime = frameTimes.keyAt(i);
                int numFrames = frameTimes.valueAt(i);
                totalFrames += numFrames;
                if (frameTime > 700) {
                    frozenFrames += numFrames;
                }
                if (frameTime <= 16) continue;
                slowFrames += numFrames;
            }
        }
        if (totalFrames != 0 || slowFrames != 0 || frozenFrames == 0) {
            // empty if block
        }
        if (totalFrames > 0) {
            screenTrace.putMetric(Constants.CounterNames.FRAMES_TOTAL.toString(), totalFrames);
        }
        if (slowFrames > 0) {
            screenTrace.putMetric(Constants.CounterNames.FRAMES_SLOW.toString(), slowFrames);
        }
        if (frozenFrames > 0) {
            screenTrace.putMetric(Constants.CounterNames.FRAMES_FROZEN.toString(), frozenFrames);
        }
        if (Utils.isDebugLoggingEnabled(activity.getApplicationContext())) {
            logger.debug("sendScreenTrace name:" + AppStateMonitor.getScreenTraceName(activity) + " _fr_tot:" + totalFrames + " _fr_slo:" + slowFrames + " _fr_fzn:" + frozenFrames);
        }
        screenTrace.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSessionLog(String name, Timer startTime, Timer endTime) {
        if (!this.configResolver.isPerformanceMonitoringEnabled()) {
            return;
        }
        TraceMetric.Builder metric = TraceMetric.newBuilder().setName(name).setClientStartTimeUs(startTime.getMicros()).setDurationUs(startTime.getDurationMicros(endTime)).addPerfSessions(SessionManager.getInstance().perfSession().build());
        int tsnsCount = this.tsnsCount.getAndSet(0);
        Map<String, Long> map = this.metricToCountMap;
        synchronized (map) {
            metric.putAllCounters(this.metricToCountMap);
            if (tsnsCount != 0) {
                metric.putCounters(Constants.CounterNames.TRACE_STARTED_NOT_STOPPED.toString(), tsnsCount);
            }
            this.metricToCountMap.clear();
        }
        this.transportManager.log((TraceMetric)metric.build(), ApplicationProcessState.FOREGROUND_BACKGROUND);
    }

    private boolean isScreenTraceSupported(Activity activity) {
        return this.hasFrameMetricsAggregator;
    }

    private boolean hasFrameMetricsAggregatorClass() {
        try {
            Class<?> initializerClass = Class.forName(FRAME_METRICS_AGGREGATOR_CLASSNAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String getScreenTraceName(Activity activity) {
        return "_st_" + activity.getClass().getSimpleName();
    }

    @VisibleForTesting
    WeakHashMap<Activity, Boolean> getResumed() {
        return this.activityToResumedMap;
    }

    @VisibleForTesting
    WeakHashMap<Activity, Trace> getActivity2ScreenTrace() {
        return this.activityToScreenTraceMap;
    }

    @VisibleForTesting
    Timer getPauseTime() {
        return this.stopTime;
    }

    @VisibleForTesting
    void setStopTime(Timer timer) {
        this.stopTime = timer;
    }

    @VisibleForTesting
    Timer getResumeTime() {
        return this.resumeTime;
    }

    @VisibleForTesting
    public void setIsColdStart(boolean isColdStart) {
        this.isColdStart = isColdStart;
    }

    public static interface AppColdStartCallback {
        public void onAppColdStart();
    }

    public static interface AppStateCallback {
        public void onUpdateAppState(ApplicationProcessState var1);
    }
}

