/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.perf.metrics.validator;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.perf.logging.AndroidLogger;
import com.google.firebase.perf.metrics.validator.PerfMetricValidator;
import com.google.firebase.perf.util.URLAllowlist;
import com.google.firebase.perf.v1.NetworkRequestMetric;
import java.net.URI;

final class FirebasePerfNetworkValidator
extends PerfMetricValidator {
    private static final AndroidLogger logger = AndroidLogger.getInstance();
    private static final String HTTP_SCHEMA = "http";
    private static final String HTTPS = "https";
    private static final int EMPTY_PORT = -1;
    private final NetworkRequestMetric networkMetric;
    private final Context appContext;

    FirebasePerfNetworkValidator(NetworkRequestMetric networkRequestMetric, Context appContext) {
        this.appContext = appContext;
        this.networkMetric = networkRequestMetric;
    }

    @Override
    public boolean isValidPerfMetric() {
        if (this.isEmptyUrl(this.networkMetric.getUrl())) {
            logger.warn("URL is missing:" + this.networkMetric.getUrl());
            return false;
        }
        URI uri = this.getResultUrl(this.networkMetric.getUrl());
        if (uri == null) {
            logger.warn("URL cannot be parsed");
            return false;
        }
        if (!this.isAllowlisted(uri, this.appContext)) {
            logger.warn("URL fails allowlist rule: " + uri);
            return false;
        }
        if (!this.isValidHost(uri.getHost())) {
            logger.warn("URL host is null or invalid");
            return false;
        }
        if (!this.isValidScheme(uri.getScheme())) {
            logger.warn("URL scheme is null or invalid");
            return false;
        }
        if (!this.isValidUserInfo(uri.getUserInfo())) {
            logger.warn("URL user info is null");
            return false;
        }
        if (!this.isValidPort(uri.getPort())) {
            logger.warn("URL port is less than or equal to 0");
            return false;
        }
        if (!this.isValidHttpMethod(this.networkMetric.hasHttpMethod() ? this.networkMetric.getHttpMethod() : null)) {
            logger.warn("HTTP Method is null or invalid: " + (Object)((Object)this.networkMetric.getHttpMethod()));
            return false;
        }
        if (this.networkMetric.hasHttpResponseCode() && !this.isValidHttpResponseCode(this.networkMetric.getHttpResponseCode())) {
            logger.warn("HTTP ResponseCode is a negative value:" + this.networkMetric.getHttpResponseCode());
            return false;
        }
        if (this.networkMetric.hasRequestPayloadBytes() && !this.isValidPayload(this.networkMetric.getRequestPayloadBytes())) {
            logger.warn("Request Payload is a negative value:" + this.networkMetric.getRequestPayloadBytes());
            return false;
        }
        if (this.networkMetric.hasResponsePayloadBytes() && !this.isValidPayload(this.networkMetric.getResponsePayloadBytes())) {
            logger.warn("Response Payload is a negative value:" + this.networkMetric.getResponsePayloadBytes());
            return false;
        }
        if (!this.networkMetric.hasClientStartTimeUs() || this.networkMetric.getClientStartTimeUs() <= 0L) {
            logger.warn("Start time of the request is null, or zero, or a negative value:" + this.networkMetric.getClientStartTimeUs());
            return false;
        }
        if (this.networkMetric.hasTimeToRequestCompletedUs() && !this.isValidTime(this.networkMetric.getTimeToRequestCompletedUs())) {
            logger.warn("Time to complete the request is a negative value:" + this.networkMetric.getTimeToRequestCompletedUs());
            return false;
        }
        if (this.networkMetric.hasTimeToResponseInitiatedUs() && !this.isValidTime(this.networkMetric.getTimeToResponseInitiatedUs())) {
            logger.warn("Time from the start of the request to the start of the response is null or a negative value:" + this.networkMetric.getTimeToResponseInitiatedUs());
            return false;
        }
        if (!this.networkMetric.hasTimeToResponseCompletedUs() || this.networkMetric.getTimeToResponseCompletedUs() <= 0L) {
            logger.warn("Time from the start of the request to the end of the response is null, negative or zero:" + this.networkMetric.getTimeToResponseCompletedUs());
            return false;
        }
        if (!this.networkMetric.hasHttpResponseCode()) {
            logger.warn("Did not receive a HTTP Response Code");
            return false;
        }
        return true;
    }

    private boolean isEmptyUrl(@Nullable String url) {
        return this.isBlank(url);
    }

    @Nullable
    private URI getResultUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        try {
            return URI.create(url);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.warn("getResultUrl throws exception %s", e.getMessage());
            return null;
        }
    }

    private boolean isAllowlisted(@Nullable URI uri, @NonNull Context context) {
        if (uri == null) {
            return false;
        }
        return URLAllowlist.isURLAllowlisted(uri, context);
    }

    private boolean isValidHost(@Nullable String host) {
        return host != null && !this.isBlank(host) && host.length() <= 255;
    }

    private boolean isValidPort(int port) {
        return port == -1 || port > 0;
    }

    private boolean isValidUserInfo(@Nullable String userInfo) {
        return userInfo == null;
    }

    private boolean isValidScheme(@Nullable String scheme) {
        if (scheme == null) {
            return false;
        }
        return HTTP_SCHEMA.equalsIgnoreCase(scheme) || HTTPS.equalsIgnoreCase(scheme);
    }

    boolean isValidHttpMethod(@Nullable NetworkRequestMetric.HttpMethod httpMethod) {
        return httpMethod != null && httpMethod != NetworkRequestMetric.HttpMethod.HTTP_METHOD_UNKNOWN;
    }

    private boolean isValidHttpResponseCode(int responseCode) {
        return responseCode > 0;
    }

    private boolean isValidTime(long time) {
        return time >= 0L;
    }

    private boolean isValidPayload(long payload) {
        return payload >= 0L;
    }

    private boolean isBlank(@Nullable String str) {
        if (str == null) {
            return true;
        }
        str = str.trim();
        return str.isEmpty();
    }
}

